package com.whaleal.icefrog.db.ds.simple;

import javax.sql.DataSource;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;

/**
 * 数据源抽象实现
 *
 * @author Looly
 * @author wh
 */
public abstract class AbstractDataSource implements DataSource, Cloneable, Closeable {
    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter( PrintWriter out ) {
        DriverManager.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout( int seconds ) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap( Class<T> iface ) throws SQLException {
        throw new SQLException("Can't support unwrap method!");
    }

    @Override
    public boolean isWrapperFor( Class<?> iface ) throws SQLException {
        throw new SQLException("Can't support isWrapperFor method!");
    }

    /**
     * Support from JDK7
     *
     * @since 1.0.0
     */
    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("DataSource can't support getParentLogger method!");
    }
}
