/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.compress;

import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.io.resource.Resource;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter
implements Closeable {
    private final ZipOutputStream out;

    public ZipWriter(File zipFile, Charset charset) {
        this.out = ZipWriter.getZipOutputStream(zipFile, charset);
    }

    public ZipWriter(OutputStream out, Charset charset) {
        this.out = ZipWriter.getZipOutputStream(out, charset);
    }

    public ZipWriter(ZipOutputStream out) {
        this.out = out;
    }

    public static ZipWriter of(File zipFile, Charset charset) {
        return new ZipWriter(zipFile, charset);
    }

    public static ZipWriter of(OutputStream out, Charset charset) {
        return new ZipWriter(out, charset);
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipWriter.getZipOutputStream(FileUtil.getOutputStream(zipFile), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, charset);
    }

    public ZipWriter setLevel(int level) {
        this.out.setLevel(level);
        return this;
    }

    public ZipWriter setComment(String comment) {
        this.out.setComment(comment);
        return this;
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    public ZipWriter add(boolean withSrcDir, FileFilter filter, File ... files) throws IORuntimeException {
        for (File file : files) {
            String srcRootDir;
            try {
                srcRootDir = file.getCanonicalPath();
                if (!file.isDirectory() || withSrcDir) {
                    srcRootDir = file.getCanonicalFile().getParentFile().getCanonicalPath();
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            this._add(file, srcRootDir, filter);
        }
        return this;
    }

    public ZipWriter add(Resource ... resources) throws IORuntimeException {
        for (Resource resource : resources) {
            if (null == resource) continue;
            this.add(resource.getName(), resource.getStream());
        }
        return this;
    }

    public ZipWriter add(String path, InputStream in) throws IORuntimeException {
        path = StrUtil.nullToEmpty(path);
        if (null == in && StrUtil.isBlank(path = StrUtil.addSuffixIfNot(path, "/"))) {
            return this;
        }
        return this.putEntry(path, in);
    }

    @Override
    public void close() throws IORuntimeException {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(this.out);
        }
    }

    private ZipWriter _add(File file, String srcRootDir, FileFilter filter) throws IORuntimeException {
        if (null == file || null != filter && !filter.accept(file)) {
            return this;
        }
        String subPath = FileUtil.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayUtil.isEmpty(files)) {
                this.add(subPath, null);
            } else {
                for (File childFile : files) {
                    this._add(childFile, srcRootDir, filter);
                }
            }
        } else {
            this.putEntry(subPath, FileUtil.getInputStream(file));
        }
        return this;
    }

    private ZipWriter putEntry(String path, InputStream in) throws IORuntimeException {
        try {
            this.out.putNextEntry(new ZipEntry(path));
            if (null != in) {
                IoUtil.copy(in, this.out);
            }
            this.out.closeEntry();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(in);
        }
        IoUtil.flush(this.out);
        return this;
    }
}

