/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.date;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class TZUtil {
    private static final Map<String, String> tzDisplayMap = new HashMap<String, String>();
    private static final Map<String, String> tzCanonicalMap = new HashMap<String, String>();
    private static final Map<String, Boolean> tzNoLongerSupported = new HashMap<String, Boolean>();

    public static String getTimeZoneCanonicalName(String tzDisplayName) {
        return tzCanonicalMap.get(tzDisplayName);
    }

    public static String getTimeZoneDisplayName(String tzCanonicalName) {
        String displayName = tzDisplayMap.get(tzCanonicalName);
        return displayName != null ? displayName : tzCanonicalName;
    }

    public static String getTimeZoneDisplayShort(String tzCanonicalName) {
        TimeZone tz = TimeZone.getTimeZone(tzCanonicalName);
        if (tz == null) {
            return tzCanonicalName;
        }
        return tz.getDisplayName(tz.inDaylightTime(new Date()), 0);
    }

    public static String[] getTimeZoneDisplayNames() {
        Object[] tzKeys = tzCanonicalMap.keySet().toArray();
        String[] result = new String[tzKeys.length];
        for (int k = 0; k < tzKeys.length; ++k) {
            result[k] = (String)tzKeys[k];
        }
        return result;
    }

    public static boolean isValidTimeZone(String tzCanonicalName) {
        return tzDisplayMap.containsKey(tzCanonicalName);
    }

    public static boolean isTimeZoneNoLongerSupported(String tzCanonicalName) {
        return tzNoLongerSupported.containsKey(tzCanonicalName);
    }

    public static double getOffset(String tzCanonicalName) {
        TimeZone timeZone = TimeZone.getTimeZone(tzCanonicalName);
        double offset = (double)timeZone.getOffset(System.currentTimeMillis()) / 3600000.0;
        return offset;
    }

    public static String getDisplayWithOffset(String pDisplayName) {
        String tzCanonicalName = TZUtil.getTimeZoneCanonicalName(pDisplayName);
        double offset = TZUtil.getOffset(tzCanonicalName);
        String sign = offset > 0.0 ? "+" : "-";
        double absoluteOffset = Math.abs(offset);
        Double hours = Math.floor(absoluteOffset);
        Double minutes = (absoluteOffset - hours) * 60.0;
        String hoursString = Integer.toString(hours.intValue());
        String minutesString = Integer.toString(minutes.intValue());
        if (hours < 10.0) {
            hoursString = "0" + hoursString;
        }
        if (minutes < 10.0) {
            minutesString = "0" + minutesString;
        }
        return "(" + sign + hoursString + ":" + minutesString + ") " + pDisplayName;
    }

    static {
        tzDisplayMap.put("Africa/Algiers", "West Central Africa");
        tzDisplayMap.put("Africa/Cairo", "Cairo");
        tzDisplayMap.put("Africa/Casablanca", "Casablanca");
        tzDisplayMap.put("Africa/Harare", "Harare");
        tzDisplayMap.put("Africa/Johannesburg", "Pretoria");
        tzDisplayMap.put("Africa/Monrovia", "Monrovia");
        tzDisplayMap.put("Africa/Nairobi", "Nairobi");
        tzDisplayMap.put("America/Argentina/Buenos_Aires", "Buenos Aires");
        tzDisplayMap.put("America/Bogota", "Bogota");
        tzDisplayMap.put("America/Caracas", "Caracas");
        tzDisplayMap.put("America/Chicago", "Central Time (US & Canada)");
        tzDisplayMap.put("America/Chihuahua", "Chihuahua");
        tzDisplayMap.put("America/Denver", "Mountain Time (US & Canada)");
        tzDisplayMap.put("America/Godthab", "Greenland");
        tzDisplayMap.put("America/Guatemala", "Central America");
        tzDisplayMap.put("America/Guyana", "Georgetown");
        tzDisplayMap.put("America/Halifax", "Atlantic Time (Canada)");
        tzDisplayMap.put("America/Indiana/Indianapolis", "Indiana (East)");
        tzDisplayMap.put("America/Juneau", "Alaska");
        tzDisplayMap.put("America/La_Paz", "La Paz");
        tzDisplayMap.put("America/Lima", "Lima");
        tzDisplayMap.put("America/Los_Angeles", "Pacific Time (US & Canada)");
        tzDisplayMap.put("America/Mazatlan", "Mazatlan");
        tzDisplayMap.put("America/Mexico_City", "Mexico City");
        tzDisplayMap.put("America/Monterrey", "Monterrey");
        tzDisplayMap.put("America/Montevideo", "Montevideo");
        tzDisplayMap.put("America/New_York", "Eastern Time (US & Canada)");
        tzDisplayMap.put("America/Phoenix", "Arizona");
        tzDisplayMap.put("America/Regina", "Saskatchewan");
        tzDisplayMap.put("America/Santiago", "Santiago");
        tzDisplayMap.put("America/Sao_Paulo", "Brasilia");
        tzDisplayMap.put("America/St_Johns", "Newfoundland");
        tzDisplayMap.put("America/Tijuana", "Tijuana");
        tzDisplayMap.put("Asia/Almaty", "Almaty");
        tzDisplayMap.put("Asia/Baghdad", "Baghdad");
        tzDisplayMap.put("Asia/Baku", "Baku");
        tzDisplayMap.put("Asia/Bangkok", "Bangkok");
        tzDisplayMap.put("Asia/Chongqing", "Chongqing");
        tzDisplayMap.put("Asia/Colombo", "Sri Jayawardenepura");
        tzDisplayMap.put("Asia/Dhaka", "Dhaka");
        tzDisplayMap.put("Asia/Hong_Kong", "Hong Kong");
        tzDisplayMap.put("Asia/Irkutsk", "Irkutsk");
        tzDisplayMap.put("Asia/Jakarta", "Jakarta");
        tzDisplayMap.put("Asia/Jerusalem", "Jerusalem");
        tzDisplayMap.put("Asia/Kabul", "Kabul");
        tzDisplayMap.put("Asia/Kamchatka", "Kamchatka");
        tzDisplayMap.put("Asia/Karachi", "Karachi");
        tzDisplayMap.put("Asia/Kathmandu", "Kathmandu");
        tzDisplayMap.put("Asia/Kolkata", "Kolkata");
        tzDisplayMap.put("Asia/Krasnoyarsk", "Krasnoyarsk");
        tzDisplayMap.put("Asia/Kuala_Lumpur", "Kuala Lumpur");
        tzDisplayMap.put("Asia/Kuwait", "Kuwait");
        tzDisplayMap.put("Asia/Magadan", "Magadan");
        tzDisplayMap.put("Asia/Muscat", "Muscat");
        tzDisplayMap.put("Asia/Novosibirsk", "Novosibirsk");
        tzDisplayMap.put("Asia/Rangoon", "Rangoon");
        tzDisplayMap.put("Asia/Riyadh", "Riyadh");
        tzDisplayMap.put("Asia/Seoul", "Seoul");
        tzDisplayMap.put("Asia/Shanghai", "Beijing");
        tzDisplayMap.put("Asia/Singapore", "Singapore");
        tzDisplayMap.put("Asia/Taipei", "Taipei");
        tzDisplayMap.put("Asia/Tashkent", "Tashkent");
        tzDisplayMap.put("Asia/Tbilisi", "Tbilisi");
        tzDisplayMap.put("Asia/Tehran", "Tehran");
        tzDisplayMap.put("Asia/Tokyo", "Tokyo");
        tzDisplayMap.put("Asia/Ulaanbaatar", "Ulaanbaatar");
        tzDisplayMap.put("Asia/Urumqi", "Urumqi");
        tzDisplayMap.put("Asia/Vladivostok", "Vladivostok");
        tzDisplayMap.put("Asia/Yakutsk", "Yakutsk");
        tzDisplayMap.put("Asia/Yekaterinburg", "Ekaterinburg");
        tzDisplayMap.put("Asia/Yerevan", "Yerevan");
        tzDisplayMap.put("Atlantic/Azores", "Azores");
        tzDisplayMap.put("Atlantic/Cape_Verde", "Cape Verde Is.");
        tzDisplayMap.put("Atlantic/South_Georgia", "Mid-Atlantic");
        tzDisplayMap.put("Australia/Adelaide", "Adelaide");
        tzDisplayMap.put("Australia/Brisbane", "Brisbane");
        tzDisplayMap.put("Australia/Darwin", "Darwin");
        tzDisplayMap.put("Australia/Hobart", "Hobart");
        tzDisplayMap.put("Australia/Melbourne", "Melbourne");
        tzDisplayMap.put("Australia/Perth", "Perth");
        tzDisplayMap.put("Australia/Sydney", "Sydney");
        tzDisplayMap.put("Etc/UTC", "UTC");
        tzDisplayMap.put("Europe/Amsterdam", "Amsterdam");
        tzDisplayMap.put("Europe/Athens", "Athens");
        tzDisplayMap.put("Europe/Belgrade", "Belgrade");
        tzDisplayMap.put("Europe/Berlin", "Berlin");
        tzDisplayMap.put("Europe/Bratislava", "Bratislava");
        tzDisplayMap.put("Europe/Brussels", "Brussels");
        tzDisplayMap.put("Europe/Bucharest", "Bucharest");
        tzDisplayMap.put("Europe/Budapest", "Budapest");
        tzDisplayMap.put("Europe/Copenhagen", "Copenhagen");
        tzDisplayMap.put("Europe/Dublin", "Dublin");
        tzDisplayMap.put("Europe/Helsinki", "Helsinki");
        tzDisplayMap.put("Europe/Istanbul", "Istanbul");
        tzDisplayMap.put("Europe/Kiev", "Kyiv");
        tzDisplayMap.put("Europe/Lisbon", "Lisbon");
        tzDisplayMap.put("Europe/Ljubljana", "Ljubljana");
        tzDisplayMap.put("Europe/London", "London");
        tzDisplayMap.put("Europe/Madrid", "Madrid");
        tzDisplayMap.put("Europe/Minsk", "Minsk");
        tzDisplayMap.put("Europe/Moscow", "Moscow");
        tzDisplayMap.put("Europe/Paris", "Paris");
        tzDisplayMap.put("Europe/Prague", "Prague");
        tzDisplayMap.put("Europe/Riga", "Riga");
        tzDisplayMap.put("Europe/Rome", "Rome");
        tzDisplayMap.put("Europe/Sarajevo", "Sarajevo");
        tzDisplayMap.put("Europe/Skopje", "Skopje");
        tzDisplayMap.put("Europe/Sofia", "Sofia");
        tzDisplayMap.put("Europe/Stockholm", "Stockholm");
        tzDisplayMap.put("Europe/Tallinn", "Tallinn");
        tzDisplayMap.put("Europe/Vienna", "Vienna");
        tzDisplayMap.put("Europe/Vilnius", "Vilnius");
        tzDisplayMap.put("Europe/Warsaw", "Warsaw");
        tzDisplayMap.put("Europe/Zagreb", "Zagreb");
        tzDisplayMap.put("Pacific/Apia", "Samoa");
        tzDisplayMap.put("Pacific/Auckland", "Auckland");
        tzDisplayMap.put("Pacific/Chatham", "Chatham Is.");
        tzDisplayMap.put("Pacific/Fakaofo", "Tokelau Is.");
        tzDisplayMap.put("Pacific/Fiji", "Fiji");
        tzDisplayMap.put("Pacific/Guadalcanal", "Solomon Is.");
        tzDisplayMap.put("Pacific/Guam", "Guam");
        tzDisplayMap.put("Pacific/Honolulu", "Hawaii");
        tzDisplayMap.put("Pacific/Majuro", "Marshall Is.");
        tzDisplayMap.put("Pacific/Midway", "Midway Island");
        tzDisplayMap.put("Pacific/Noumea", "New Caledonia");
        tzDisplayMap.put("Pacific/Pago_Pago", "American Samoa");
        tzDisplayMap.put("Pacific/Port_Moresby", "Port Moresby");
        tzDisplayMap.put("Pacific/Tongatapu", "Nuku'alofa");
        tzCanonicalMap.put("International Date Line West", "Pacific/Midway");
        tzCanonicalMap.put("Midway Island", "Pacific/Midway");
        tzCanonicalMap.put("American Samoa", "Pacific/Pago_Pago");
        tzCanonicalMap.put("Hawaii", "Pacific/Honolulu");
        tzCanonicalMap.put("Alaska", "America/Juneau");
        tzCanonicalMap.put("Pacific Time (US & Canada)", "America/Los_Angeles");
        tzCanonicalMap.put("Tijuana", "America/Tijuana");
        tzCanonicalMap.put("Mountain Time (US & Canada)", "America/Denver");
        tzCanonicalMap.put("Arizona", "America/Phoenix");
        tzCanonicalMap.put("Chihuahua", "America/Chihuahua");
        tzCanonicalMap.put("Mazatlan", "America/Mazatlan");
        tzCanonicalMap.put("Central Time (US & Canada)", "America/Chicago");
        tzCanonicalMap.put("Saskatchewan", "America/Regina");
        tzCanonicalMap.put("Guadalajara", "America/Mexico_City");
        tzCanonicalMap.put("Mexico City", "America/Mexico_City");
        tzCanonicalMap.put("Monterrey", "America/Monterrey");
        tzCanonicalMap.put("Central America", "America/Guatemala");
        tzCanonicalMap.put("Eastern Time (US & Canada)", "America/New_York");
        tzCanonicalMap.put("Indiana (East)", "America/Indiana/Indianapolis");
        tzCanonicalMap.put("Bogota", "America/Bogota");
        tzCanonicalMap.put("Lima", "America/Lima");
        tzCanonicalMap.put("Quito", "America/Lima");
        tzCanonicalMap.put("Atlantic Time (Canada)", "America/Halifax");
        tzCanonicalMap.put("Caracas", "America/Caracas");
        tzCanonicalMap.put("La Paz", "America/La_Paz");
        tzCanonicalMap.put("Santiago", "America/Santiago");
        tzCanonicalMap.put("Newfoundland", "America/St_Johns");
        tzCanonicalMap.put("Brasilia", "America/Sao_Paulo");
        tzCanonicalMap.put("Buenos Aires", "America/Argentina/Buenos_Aires");
        tzCanonicalMap.put("Montevideo", "America/Montevideo");
        tzCanonicalMap.put("Georgetown", "America/Guyana");
        tzCanonicalMap.put("Greenland", "America/Godthab");
        tzCanonicalMap.put("Mid-Atlantic", "Atlantic/South_Georgia");
        tzCanonicalMap.put("Azores", "Atlantic/Azores");
        tzCanonicalMap.put("Cape Verde Is.", "Atlantic/Cape_Verde");
        tzCanonicalMap.put("Dublin", "Europe/Dublin");
        tzCanonicalMap.put("Edinburgh", "Europe/London");
        tzCanonicalMap.put("Lisbon", "Europe/Lisbon");
        tzCanonicalMap.put("London", "Europe/London");
        tzCanonicalMap.put("Casablanca", "Africa/Casablanca");
        tzCanonicalMap.put("Monrovia", "Africa/Monrovia");
        tzCanonicalMap.put("UTC", "Etc/UTC");
        tzCanonicalMap.put("Belgrade", "Europe/Belgrade");
        tzCanonicalMap.put("Bratislava", "Europe/Bratislava");
        tzCanonicalMap.put("Budapest", "Europe/Budapest");
        tzCanonicalMap.put("Ljubljana", "Europe/Ljubljana");
        tzCanonicalMap.put("Prague", "Europe/Prague");
        tzCanonicalMap.put("Sarajevo", "Europe/Sarajevo");
        tzCanonicalMap.put("Skopje", "Europe/Skopje");
        tzCanonicalMap.put("Warsaw", "Europe/Warsaw");
        tzCanonicalMap.put("Zagreb", "Europe/Zagreb");
        tzCanonicalMap.put("Brussels", "Europe/Brussels");
        tzCanonicalMap.put("Copenhagen", "Europe/Copenhagen");
        tzCanonicalMap.put("Madrid", "Europe/Madrid");
        tzCanonicalMap.put("Paris", "Europe/Paris");
        tzCanonicalMap.put("Amsterdam", "Europe/Amsterdam");
        tzCanonicalMap.put("Berlin", "Europe/Berlin");
        tzCanonicalMap.put("Bern", "Europe/Berlin");
        tzCanonicalMap.put("Rome", "Europe/Rome");
        tzCanonicalMap.put("Stockholm", "Europe/Stockholm");
        tzCanonicalMap.put("Vienna", "Europe/Vienna");
        tzCanonicalMap.put("West Central Africa", "Africa/Algiers");
        tzCanonicalMap.put("Bucharest", "Europe/Bucharest");
        tzCanonicalMap.put("Cairo", "Africa/Cairo");
        tzCanonicalMap.put("Helsinki", "Europe/Helsinki");
        tzCanonicalMap.put("Kyiv", "Europe/Kiev");
        tzCanonicalMap.put("Riga", "Europe/Riga");
        tzCanonicalMap.put("Sofia", "Europe/Sofia");
        tzCanonicalMap.put("Tallinn", "Europe/Tallinn");
        tzCanonicalMap.put("Vilnius", "Europe/Vilnius");
        tzCanonicalMap.put("Athens", "Europe/Athens");
        tzCanonicalMap.put("Istanbul", "Europe/Istanbul");
        tzCanonicalMap.put("Minsk", "Europe/Minsk");
        tzCanonicalMap.put("Jerusalem", "Asia/Jerusalem");
        tzCanonicalMap.put("Harare", "Africa/Harare");
        tzCanonicalMap.put("Pretoria", "Africa/Johannesburg");
        tzCanonicalMap.put("Moscow", "Europe/Moscow");
        tzCanonicalMap.put("St. Petersburg", "Europe/Moscow");
        tzCanonicalMap.put("Volgograd", "Europe/Moscow");
        tzCanonicalMap.put("Kuwait", "Asia/Kuwait");
        tzCanonicalMap.put("Riyadh", "Asia/Riyadh");
        tzCanonicalMap.put("Nairobi", "Africa/Nairobi");
        tzCanonicalMap.put("Baghdad", "Asia/Baghdad");
        tzCanonicalMap.put("Tehran", "Asia/Tehran");
        tzCanonicalMap.put("Abu Dhabi", "Asia/Muscat");
        tzCanonicalMap.put("Muscat", "Asia/Muscat");
        tzCanonicalMap.put("Baku", "Asia/Baku");
        tzCanonicalMap.put("Tbilisi", "Asia/Tbilisi");
        tzCanonicalMap.put("Yerevan", "Asia/Yerevan");
        tzCanonicalMap.put("Kabul", "Asia/Kabul");
        tzCanonicalMap.put("Ekaterinburg", "Asia/Yekaterinburg");
        tzCanonicalMap.put("Islamabad", "Asia/Karachi");
        tzCanonicalMap.put("Karachi", "Asia/Karachi");
        tzCanonicalMap.put("Tashkent", "Asia/Tashkent");
        tzCanonicalMap.put("Chennai", "Asia/Kolkata");
        tzCanonicalMap.put("Kolkata", "Asia/Kolkata");
        tzCanonicalMap.put("Mumbai", "Asia/Kolkata");
        tzCanonicalMap.put("New Delhi", "Asia/Kolkata");
        tzCanonicalMap.put("Kathmandu", "Asia/Kathmandu");
        tzCanonicalMap.put("Astana", "Asia/Dhaka");
        tzCanonicalMap.put("Dhaka", "Asia/Dhaka");
        tzCanonicalMap.put("Sri Jayawardenepura", "Asia/Colombo");
        tzCanonicalMap.put("Almaty", "Asia/Almaty");
        tzCanonicalMap.put("Novosibirsk", "Asia/Novosibirsk");
        tzCanonicalMap.put("Rangoon", "Asia/Rangoon");
        tzCanonicalMap.put("Bangkok", "Asia/Bangkok");
        tzCanonicalMap.put("Hanoi", "Asia/Bangkok");
        tzCanonicalMap.put("Jakarta", "Asia/Jakarta");
        tzCanonicalMap.put("Krasnoyarsk", "Asia/Krasnoyarsk");
        tzCanonicalMap.put("Beijing", "Asia/Shanghai");
        tzCanonicalMap.put("Chongqing", "Asia/Chongqing");
        tzCanonicalMap.put("Hong Kong", "Asia/Hong_Kong");
        tzCanonicalMap.put("Urumqi", "Asia/Urumqi");
        tzCanonicalMap.put("Kuala Lumpur", "Asia/Kuala_Lumpur");
        tzCanonicalMap.put("Singapore", "Asia/Singapore");
        tzCanonicalMap.put("Taipei", "Asia/Taipei");
        tzCanonicalMap.put("Perth", "Australia/Perth");
        tzCanonicalMap.put("Irkutsk", "Asia/Irkutsk");
        tzCanonicalMap.put("Ulaanbaatar", "Asia/Ulaanbaatar");
        tzCanonicalMap.put("Seoul", "Asia/Seoul");
        tzCanonicalMap.put("Osaka", "Asia/Tokyo");
        tzCanonicalMap.put("Sapporo", "Asia/Tokyo");
        tzCanonicalMap.put("Tokyo", "Asia/Tokyo");
        tzCanonicalMap.put("Yakutsk", "Asia/Yakutsk");
        tzCanonicalMap.put("Darwin", "Australia/Darwin");
        tzCanonicalMap.put("Adelaide", "Australia/Adelaide");
        tzCanonicalMap.put("Canberra", "Australia/Melbourne");
        tzCanonicalMap.put("Melbourne", "Australia/Melbourne");
        tzCanonicalMap.put("Sydney", "Australia/Sydney");
        tzCanonicalMap.put("Brisbane", "Australia/Brisbane");
        tzCanonicalMap.put("Hobart", "Australia/Hobart");
        tzCanonicalMap.put("Vladivostok", "Asia/Vladivostok");
        tzCanonicalMap.put("Guam", "Pacific/Guam");
        tzCanonicalMap.put("Port Moresby", "Pacific/Port_Moresby");
        tzCanonicalMap.put("Magadan", "Asia/Magadan");
        tzCanonicalMap.put("Solomon Is.", "Pacific/Guadalcanal");
        tzCanonicalMap.put("New Caledonia", "Pacific/Noumea");
        tzCanonicalMap.put("Fiji", "Pacific/Fiji");
        tzCanonicalMap.put("Kamchatka", "Asia/Kamchatka");
        tzCanonicalMap.put("Marshall Is.", "Pacific/Majuro");
        tzCanonicalMap.put("Auckland", "Pacific/Auckland");
        tzCanonicalMap.put("Wellington", "Pacific/Auckland");
        tzCanonicalMap.put("Nuku'alofa", "Pacific/Tongatapu");
        tzCanonicalMap.put("Tokelau Is.", "Pacific/Fakaofo");
        tzCanonicalMap.put("Chatham Is.", "Pacific/Chatham");
        tzCanonicalMap.put("Samoa", "Pacific/Apia");
        tzNoLongerSupported.put("ACT", true);
        tzNoLongerSupported.put("AET", true);
        tzNoLongerSupported.put("AGT", true);
        tzNoLongerSupported.put("ART", true);
        tzNoLongerSupported.put("AST", true);
        tzNoLongerSupported.put("Africa/Abidjan", true);
        tzNoLongerSupported.put("Africa/Accra", true);
        tzNoLongerSupported.put("Africa/Addis_Ababa", true);
        tzNoLongerSupported.put("Africa/Asmara", true);
        tzNoLongerSupported.put("Africa/Banjul", true);
        tzNoLongerSupported.put("Africa/Conakry", true);
        tzNoLongerSupported.put("Africa/Dakar", true);
        tzNoLongerSupported.put("Africa/Dar_es_Salaam", true);
        tzNoLongerSupported.put("Africa/Douala", true);
        tzNoLongerSupported.put("Africa/Khartoum", true);
        tzNoLongerSupported.put("Africa/Lagos", true);
        tzNoLongerSupported.put("Africa/Sao_Tome", true);
        tzNoLongerSupported.put("Africa/Windhoek", true);
        tzNoLongerSupported.put("America/Adak", true);
        tzNoLongerSupported.put("America/Anchorage", true);
        tzNoLongerSupported.put("America/Argentina/Cordoba", true);
        tzNoLongerSupported.put("America/Argentina/Mendoza", true);
        tzNoLongerSupported.put("America/Asuncion", true);
        tzNoLongerSupported.put("America/Barbados", true);
        tzNoLongerSupported.put("America/Boise", true);
        tzNoLongerSupported.put("America/Buenos_Aires", true);
        tzNoLongerSupported.put("America/Cancun", true);
        tzNoLongerSupported.put("America/Costa_Rica", true);
        tzNoLongerSupported.put("America/Curacao", true);
        tzNoLongerSupported.put("America/Detroit", true);
        tzNoLongerSupported.put("America/Edmonton", true);
        tzNoLongerSupported.put("America/Fortaleza", true);
        tzNoLongerSupported.put("America/Guayaquil", true);
        tzNoLongerSupported.put("America/Indianapolis", true);
        tzNoLongerSupported.put("America/Kentucky/Louisville", true);
        tzNoLongerSupported.put("America/Knox_IN", true);
        tzNoLongerSupported.put("America/Matamoros", true);
        tzNoLongerSupported.put("America/Montreal", true);
        tzNoLongerSupported.put("America/Recife", true);
        tzNoLongerSupported.put("America/Santo_Domingo", true);
        tzNoLongerSupported.put("America/Toronto", true);
        tzNoLongerSupported.put("America/Vancouver", true);
        tzNoLongerSupported.put("Asia/Amman", true);
        tzNoLongerSupported.put("Asia/Bahrain", true);
        tzNoLongerSupported.put("Asia/Beirut", true);
        tzNoLongerSupported.put("Asia/Bishkek", true);
        tzNoLongerSupported.put("Asia/Calcutta", true);
        tzNoLongerSupported.put("Asia/Chungking", true);
        tzNoLongerSupported.put("Asia/Dili", true);
        tzNoLongerSupported.put("Asia/Dubai", true);
        tzNoLongerSupported.put("Asia/Harbin", true);
        tzNoLongerSupported.put("Asia/Ho_Chi_Minh", true);
        tzNoLongerSupported.put("Asia/Istanbul", true);
        tzNoLongerSupported.put("Asia/Jayapura", true);
        tzNoLongerSupported.put("Asia/Katmandu", true);
        tzNoLongerSupported.put("Asia/Macao", true);
        tzNoLongerSupported.put("Asia/Macau", true);
        tzNoLongerSupported.put("Asia/Makassar", true);
        tzNoLongerSupported.put("Asia/Manila", true);
        tzNoLongerSupported.put("Asia/Omsk", true);
        tzNoLongerSupported.put("Asia/Phnom_Penh", true);
        tzNoLongerSupported.put("Asia/Saigon", true);
        tzNoLongerSupported.put("Asia/Sakhalin", true);
        tzNoLongerSupported.put("Asia/Samarkand", true);
        tzNoLongerSupported.put("Asia/Tel_Aviv", true);
        tzNoLongerSupported.put("Asia/Ujung_Pandang", true);
        tzNoLongerSupported.put("Asia/Ulan_Bator", true);
        tzNoLongerSupported.put("Atlantic/Reykjavik", true);
        tzNoLongerSupported.put("Australia/ACT", true);
        tzNoLongerSupported.put("Australia/NSW", true);
        tzNoLongerSupported.put("Australia/Queensland", true);
        tzNoLongerSupported.put("Australia/Victoria", true);
        tzNoLongerSupported.put("BET", true);
        tzNoLongerSupported.put("BST", true);
        tzNoLongerSupported.put("Brazil/East", true);
        tzNoLongerSupported.put("Brazil/West", true);
        tzNoLongerSupported.put("CAT", true);
        tzNoLongerSupported.put("CET", true);
        tzNoLongerSupported.put("CST", true);
        tzNoLongerSupported.put("CST6CDT", true);
        tzNoLongerSupported.put("Canada/Atlantic", true);
        tzNoLongerSupported.put("Canada/Central", true);
        tzNoLongerSupported.put("Canada/Eastern", true);
        tzNoLongerSupported.put("Canada/Mountain", true);
        tzNoLongerSupported.put("Canada/Pacific", true);
        tzNoLongerSupported.put("Canada/Saskatchewan", true);
        tzNoLongerSupported.put("Chile/Continental", true);
        tzNoLongerSupported.put("EAT", true);
        tzNoLongerSupported.put("EET", true);
        tzNoLongerSupported.put("EST", true);
        tzNoLongerSupported.put("EST5EDT", true);
        tzNoLongerSupported.put("Egypt", true);
        tzNoLongerSupported.put("Eire", true);
        tzNoLongerSupported.put("Etc/GMT", true);
        tzNoLongerSupported.put("Etc/GMT+0", true);
        tzNoLongerSupported.put("Etc/GMT+1", true);
        tzNoLongerSupported.put("Etc/GMT+11", true);
        tzNoLongerSupported.put("Etc/GMT+2", true);
        tzNoLongerSupported.put("Etc/GMT+3", true);
        tzNoLongerSupported.put("Etc/GMT+4", true);
        tzNoLongerSupported.put("Etc/GMT+5", true);
        tzNoLongerSupported.put("Etc/GMT+6", true);
        tzNoLongerSupported.put("Etc/GMT+7", true);
        tzNoLongerSupported.put("Etc/GMT+8", true);
        tzNoLongerSupported.put("Etc/GMT+9", true);
        tzNoLongerSupported.put("Etc/GMT-0", true);
        tzNoLongerSupported.put("Etc/GMT-2", true);
        tzNoLongerSupported.put("Etc/GMT-4", true);
        tzNoLongerSupported.put("Etc/GMT-5", true);
        tzNoLongerSupported.put("Etc/GMT-6", true);
        tzNoLongerSupported.put("Etc/GMT-8", true);
        tzNoLongerSupported.put("Etc/GMT-9", true);
        tzNoLongerSupported.put("Etc/GMT0", true);
        tzNoLongerSupported.put("Etc/Greenwich", true);
        tzNoLongerSupported.put("Etc/UCT", true);
        tzNoLongerSupported.put("Europe/Andorra", true);
        tzNoLongerSupported.put("Europe/Chisinau", true);
        tzNoLongerSupported.put("Europe/Kaliningrad", true);
        tzNoLongerSupported.put("Europe/Luxembourg", true);
        tzNoLongerSupported.put("Europe/Malta", true);
        tzNoLongerSupported.put("Europe/Oslo", true);
        tzNoLongerSupported.put("Europe/Simferopol", true);
        tzNoLongerSupported.put("Europe/Vatican", true);
        tzNoLongerSupported.put("Europe/Volgograd", true);
        tzNoLongerSupported.put("Europe/Zaporozhye", true);
        tzNoLongerSupported.put("Europe/Zurich", true);
        tzNoLongerSupported.put("GB", true);
        tzNoLongerSupported.put("GB-Eire", true);
        tzNoLongerSupported.put("GMT", true);
        tzNoLongerSupported.put("GMT0", true);
        tzNoLongerSupported.put("Greenwich", true);
        tzNoLongerSupported.put("Hongkong", true);
        tzNoLongerSupported.put("IET", true);
        tzNoLongerSupported.put("IST", true);
        tzNoLongerSupported.put("Iceland", true);
        tzNoLongerSupported.put("Indian/Antananarivo", true);
        tzNoLongerSupported.put("Indian/Chagos", true);
        tzNoLongerSupported.put("Indian/Christmas", true);
        tzNoLongerSupported.put("Indian/Cocos", true);
        tzNoLongerSupported.put("Indian/Comoro", true);
        tzNoLongerSupported.put("Indian/Kerguelen", true);
        tzNoLongerSupported.put("Indian/Mahe", true);
        tzNoLongerSupported.put("Indian/Maldives", true);
        tzNoLongerSupported.put("Indian/Mauritius", true);
        tzNoLongerSupported.put("Indian/Mayotte", true);
        tzNoLongerSupported.put("Indian/Reunion", true);
        tzNoLongerSupported.put("Iran", true);
        tzNoLongerSupported.put("Israel", true);
        tzNoLongerSupported.put("JST", true);
        tzNoLongerSupported.put("Japan", true);
        tzNoLongerSupported.put("Kwajalein", true);
        tzNoLongerSupported.put("MET", true);
        tzNoLongerSupported.put("MST", true);
        tzNoLongerSupported.put("MST7MDT", true);
        tzNoLongerSupported.put("Mexico/General", true);
        tzNoLongerSupported.put("NET", true);
        tzNoLongerSupported.put("NZ", true);
        tzNoLongerSupported.put("PRC", true);
        tzNoLongerSupported.put("PST", true);
        tzNoLongerSupported.put("PST8PDT", true);
        tzNoLongerSupported.put("Pacific/Chuuk", true);
        tzNoLongerSupported.put("Poland", true);
        tzNoLongerSupported.put("Portugal", true);
        tzNoLongerSupported.put("ROK", true);
        tzNoLongerSupported.put("SST", true);
        tzNoLongerSupported.put("Singapore", true);
        tzNoLongerSupported.put("SystemV/EST5", true);
        tzNoLongerSupported.put("SystemV/MST7MDT", true);
        tzNoLongerSupported.put("SystemV/PST8PDT", true);
        tzNoLongerSupported.put("Turkey", true);
        tzNoLongerSupported.put("UCT", true);
        tzNoLongerSupported.put("US/Alaska", true);
        tzNoLongerSupported.put("US/Aleutian", true);
        tzNoLongerSupported.put("US/Arizona", true);
        tzNoLongerSupported.put("US/Central", true);
        tzNoLongerSupported.put("US/East-Indiana", true);
        tzNoLongerSupported.put("US/Eastern", true);
        tzNoLongerSupported.put("US/Indiana-Starke", true);
        tzNoLongerSupported.put("US/Mountain", true);
        tzNoLongerSupported.put("US/Pacific", true);
        tzNoLongerSupported.put("US/Pacific-New", true);
        tzNoLongerSupported.put("UTC,225", true);
        tzNoLongerSupported.put("Universal", true);
    }
}

