/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang;

import com.whaleal.icefrog.core.collection.ListUtil;
import com.whaleal.icefrog.core.lang.Country;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CountrySet implements Iterable<Country>
{
    EURO_COUNTRIES(Country.AUSTRIA, Country.BELGIUM, Country.CYPRUS, Country.ESTONIA, Country.FINLAND, Country.FRANCE, Country.GERMANY, Country.GREECE, Country.IRELAND, Country.ITALY, Country.LATVIA, Country.LITHUANIA, Country.LUXEMBOURG, Country.MALTA, Country.NETHERLANDS, Country.PORTUGAL, Country.SLOVAKIA, Country.SLOVENIA, Country.SPAIN),
    VAT_EURO_SUPPLIER(Country.BULGARIA, Country.CROATIA, Country.CZECH_REPUBLIC, Country.DENMARK, Country.POLAND, Country.ROMANIA, Country.SWEDEN),
    VAT_EURO_COUNTRIES(Stream.concat(VAT_EURO_SUPPLIER.getCountries().stream(), EURO_COUNTRIES.getCountries().stream()).collect(Collectors.toList()));

    private final Set<Country> _countries = new HashSet<Country>();

    private CountrySet(Country ... pCountries) {
        this(ListUtil.of(pCountries));
    }

    private CountrySet(List<Country> pCountries) {
        this._countries.addAll(pCountries);
    }

    @Override
    public Iterator<Country> iterator() {
        return this._countries.iterator();
    }

    public boolean contains(Country pCountry) {
        return this._countries.contains((Object)pCountry);
    }

    public Set<Country> getCountries() {
        return this._countries;
    }
}

