/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.map;

import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.getter.OptNullBasicTypeFromObjectGetter;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.BooleanUtil;
import com.whaleal.icefrog.core.util.ClassLoaderUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MapProxy
implements Map<Object, Object>,
OptNullBasicTypeFromObjectGetter<Object>,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    Map map;

    public MapProxy(Map<?, ?> map) {
        this.map = map;
    }

    public static MapProxy create(Map<?, ?> map) {
        return map instanceof MapProxy ? (MapProxy)map : new MapProxy(map);
    }

    @Override
    public Object getObj(Object key, Object defaultValue) {
        Object value = this.map.get(key);
        return null != value ? value : defaultValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<?, ?> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (ArrayUtil.isEmpty(parameterTypes)) {
            Class<?> returnType = method.getReturnType();
            if (Void.TYPE != returnType) {
                String methodName = method.getName();
                String fieldName = null;
                if (methodName.startsWith("get")) {
                    fieldName = StrUtil.removePreAndLowerFirst((CharSequence)methodName, 3);
                } else if (BooleanUtil.isBoolean(returnType) && methodName.startsWith("is")) {
                    fieldName = StrUtil.removePreAndLowerFirst((CharSequence)methodName, 2);
                } else {
                    if ("hashCode".equals(methodName)) {
                        return this.hashCode();
                    }
                    if ("toString".equals(methodName)) {
                        return this.toString();
                    }
                }
                if (StrUtil.isNotBlank(fieldName)) {
                    if (!this.containsKey(fieldName)) {
                        fieldName = StrUtil.toUnderlineCase(fieldName);
                    }
                    return Convert.convert(method.getGenericReturnType(), this.get(fieldName));
                }
            }
        } else if (1 == parameterTypes.length) {
            String methodName = method.getName();
            if (methodName.startsWith("set")) {
                String fieldName = StrUtil.removePreAndLowerFirst((CharSequence)methodName, 3);
                if (StrUtil.isNotBlank(fieldName)) {
                    this.put(fieldName, args[0]);
                    Class<?> returnType = method.getReturnType();
                    if (returnType.isInstance(proxy)) {
                        return proxy;
                    }
                }
            } else if ("equals".equals(methodName)) {
                return this.equals(args[0]);
            }
        }
        throw new UnsupportedOperationException(method.toGenericString());
    }

    public <T> T toProxyBean(Class<T> interfaceClass) {
        return (T)Proxy.newProxyInstance(ClassLoaderUtil.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this);
    }
}

