/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.map.multi;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.IterUtil;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.map.multi.AbsCollValueMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SetValueMap<K, V>
extends AbsCollValueMap<K, V, Set<V>> {
    private static final long serialVersionUID = 6044017508487827899L;

    public SetValueMap() {
        this(16);
    }

    public SetValueMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SetValueMap(Map<? extends K, ? extends Collection<V>> m) {
        this(0.75f, (Map<? extends K, Collection<V>>)m);
    }

    public SetValueMap(float loadFactor, Map<? extends K, ? extends Collection<V>> m) {
        this(m.size(), loadFactor);
        this.putAllValues(m);
    }

    public SetValueMap(int initialCapacity, float loadFactor) {
        super(new HashMap(initialCapacity, loadFactor));
    }

    @Override
    protected Set<V> createCollection() {
        return new LinkedHashSet(3);
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        Collection collection = (Collection)this.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean putAll(K key, Iterable<V> values) {
        Precondition.checkNotNull(values);
        Set valueCollection = (Set)values;
        if (valueCollection == null) {
            try {
                this.put(key, CollUtil.newHashSet(false, values.iterator()));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (values instanceof Collection) {
            return !valueCollection.isEmpty() && ((Set)this.get(key)).addAll(valueCollection);
        }
        Iterator<V> valueItr = values.iterator();
        return valueItr.hasNext() && IterUtil.addAll((Collection)this.get(key), valueItr);
    }

    @Override
    public Set<V> replaceValues(K key, Iterable<V> values) {
        Iterator<V> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return (Set)this.remove(key);
        }
        Set coll = (Set)this.get(key);
        if (null != coll) {
            coll.clear();
            IterUtil.addAll(coll, values);
            return coll;
        }
        HashSet<V> set = CollUtil.newHashSet(false, values.iterator());
        this.put(key, set);
        return set;
    }
}

