/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.net;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.EnumerationIter;
import com.whaleal.icefrog.core.exceptions.UtilException;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.Predicate;
import com.whaleal.icefrog.core.net.Ipv4Util;
import com.whaleal.icefrog.core.net.UserPassAuthenticator;
import com.whaleal.icefrog.core.util.JNDIUtil;
import com.whaleal.icefrog.core.util.RandomUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.DatagramSocket;
import java.net.HttpCookie;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class NetUtil {
    public static final String LOCAL_IP = "127.0.0.1";
    public static final String IPV6_LOOPBACK_ADDRESS = "0:0:0:0:0:0:0:1";
    public static final int DEFAULT_SNMP_TRAP_PORT = 162;
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    public static String localhostName;

    public static String longToIpv4(long longIP) {
        return Ipv4Util.longToIpv4(longIP);
    }

    public static long ipv4ToLong(String strIP) {
        return Ipv4Util.ipv4ToLong(strIP);
    }

    public static BigInteger ipv6ToBitInteger(String IPv6Str) {
        try {
            InetAddress address = InetAddress.getByName(IPv6Str);
            if (address instanceof Inet6Address) {
                return new BigInteger(1, address.getAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static String bigIntegerToIPv6(BigInteger bigInteger) {
        try {
            return InetAddress.getByAddress(bigInteger.toByteArray()).toString().substring(1);
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    public static boolean isUsableLocalPort(int port) {
        Throwable throwable;
        if (!NetUtil.isValidPort(port)) {
            return false;
        }
        try {
            throwable = null;
            try (ServerSocket ss = new ServerSocket(port);){
                ss.setReuseAddress(true);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        try {
            throwable = null;
            try (DatagramSocket ds = new DatagramSocket(port);){
                ds.setReuseAddress(true);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static int getUsableLocalPort() {
        return NetUtil.getUsableLocalPort(1024);
    }

    public static int getUsableLocalPort(int minPort) {
        return NetUtil.getUsableLocalPort(minPort, 65535);
    }

    public static int getUsableLocalPort(int minPort, int maxPort) {
        int maxPortExclude = maxPort + 1;
        for (int i = minPort; i < maxPortExclude; ++i) {
            int randomPort = RandomUtil.randomInt(minPort, maxPortExclude);
            if (!NetUtil.isUsableLocalPort(randomPort)) continue;
            return randomPort;
        }
        throw new UtilException("Could not find an available port in the range [{}, {}] after {} attempts", minPort, maxPort, maxPort - minPort);
    }

    public static TreeSet<Integer> getUsableLocalPorts(int numRequested, int minPort, int maxPort) {
        TreeSet<Integer> availablePorts = new TreeSet<Integer>();
        int attemptCount = 0;
        while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
            availablePorts.add(NetUtil.getUsableLocalPort(minPort, maxPort));
        }
        if (availablePorts.size() != numRequested) {
            throw new UtilException("Could not find {} available  ports in the range [{}, {}]", numRequested, minPort, maxPort);
        }
        return availablePorts;
    }

    public static boolean isInnerIP(String ipAddress) {
        long ipNum = NetUtil.ipv4ToLong(ipAddress);
        long aBegin = NetUtil.ipv4ToLong("10.0.0.0");
        long aEnd = NetUtil.ipv4ToLong("10.255.255.255");
        long bBegin = NetUtil.ipv4ToLong("172.16.0.0");
        long bEnd = NetUtil.ipv4ToLong("172.31.255.255");
        long cBegin = NetUtil.ipv4ToLong("192.168.0.0");
        long cEnd = NetUtil.ipv4ToLong("192.168.255.255");
        boolean isInnerIp = NetUtil.isInner(ipNum, aBegin, aEnd) || NetUtil.isInner(ipNum, bBegin, bEnd) || NetUtil.isInner(ipNum, cBegin, cEnd) || LOCAL_IP.equals(ipAddress);
        return isInnerIp;
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new UtilException(e, "To absolute url [{}] base [{}] error!", relativePath, absoluteBasePath);
        }
    }

    public static String hideIpPart(String ip) {
        return StrUtil.builder(ip.length()).append(ip, 0, ip.lastIndexOf(".") + 1).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetUtil.hideIpPart(NetUtil.longToIpv4(ip));
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        int port;
        String destHost;
        int index;
        if (StrUtil.isBlank(host)) {
            host = LOCAL_IP;
        }
        if ((index = host.indexOf(":")) != -1) {
            destHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            destHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(destHost, port);
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static NetworkInterface getNetworkInterface(String name) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = networkInterfaces.nextElement();
            if (null == netInterface || !name.equals(netInterface.getName())) continue;
            return netInterface;
        }
        return null;
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollUtil.addAll(new ArrayList(), networkInterfaces);
    }

    public static LinkedHashSet<String> localIpv4s() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(t -> t instanceof Inet4Address);
        return NetUtil.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> localIpv6s() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(t -> t instanceof Inet6Address);
        return NetUtil.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        for (InetAddress address : addressList) {
            ipSet.add(address.getHostAddress());
        }
        return ipSet;
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(null);
        return NetUtil.toIpList(localAddressList);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<InetAddress> addressPredicate) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new UtilException(e);
        }
        if (networkInterfaces == null) {
            throw new UtilException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressPredicate && !addressPredicate.apply(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static String getLocalhostStr() {
        InetAddress localhost = NetUtil.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(address -> false == address.isLoopbackAddress() && address instanceof Inet4Address);
        if (CollUtil.isNotEmpty(localAddressList)) {
            InetAddress address2 = null;
            for (InetAddress inetAddress : localAddressList) {
                if (!inetAddress.isSiteLocalAddress()) {
                    return inetAddress;
                }
                if (null != address2) continue;
                address2 = inetAddress;
            }
            if (null != address2) {
                return address2;
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static String getLocalMacAddress() {
        return NetUtil.getMacAddress(NetUtil.getLocalhost());
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetUtil.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String separator) {
        if (null == inetAddress) {
            return null;
        }
        byte[] mac = NetUtil.getHardwareAddress(inetAddress);
        if (null != mac) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            return sb.toString();
        }
        return null;
    }

    public static byte[] getLocalHardwareAddress() {
        return NetUtil.getHardwareAddress(NetUtil.getLocalhost());
    }

    public static byte[] getHardwareAddress(InetAddress inetAddress) {
        if (null == inetAddress) {
            return null;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (null != networkInterface) {
                return networkInterface.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            throw new UtilException(e);
        }
        return null;
    }

    public static String getLocalHostName() {
        if (StrUtil.isNotBlank(localhostName)) {
            return localhostName;
        }
        InetAddress localhost = NetUtil.getLocalhost();
        if (null != localhost) {
            String name = localhost.getHostName();
            if (StrUtil.isEmpty(name)) {
                name = localhost.getHostAddress();
            }
            localhostName = name;
        }
        return localhostName;
    }

    public static InetSocketAddress createAddress(String host, int port) {
        if (StrUtil.isBlank(host)) {
            return new InetSocketAddress(port);
        }
        return new InetSocketAddress(host, port);
    }

    public static void netCat(String host, int port, boolean isBlock, ByteBuffer data) throws IORuntimeException {
        try (SocketChannel channel = SocketChannel.open(NetUtil.createAddress(host, port));){
            channel.configureBlocking(isBlock);
            channel.write(data);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void netCat(String host, int port, byte[] data) throws IORuntimeException {
        OutputStream out = null;
        try (Socket socket = new Socket(host, port);){
            out = socket.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(out);
                throw throwable;
            }
        }
        IoUtil.close(out);
    }

    public static boolean isInRange(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = StrUtil.splitToArray((CharSequence)ip, '.');
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }

    public static String idnToASCII(String unicode) {
        return IDN.toASCII(unicode);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (NetUtil.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return StrUtil.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static boolean ping(String ip) {
        return NetUtil.ping(ip, 200);
    }

    public static boolean ping(String ip, int timeout) {
        try {
            return InetAddress.getByName(ip).isReachable(timeout);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        if (StrUtil.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(cookieStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOpen(InetSocketAddress address, int timeout) {
        try (Socket sc = new Socket();){
            sc.connect(address, timeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setGlobalAuthenticator(String user, char[] pass) {
        NetUtil.setGlobalAuthenticator(new UserPassAuthenticator(user, pass));
    }

    public static void setGlobalAuthenticator(Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
    }

    public static List<String> getDnsInfo(String hostName, String ... attrNames) {
        String uri = StrUtil.addPrefixIfNot(hostName, "dns:");
        Attributes attributes = JNDIUtil.getAttributes(uri, attrNames);
        ArrayList<String> infos = new ArrayList<String>();
        for (Attribute attribute : new EnumerationIter<Attribute>(attributes.getAll())) {
            try {
                infos.add((String)attribute.get());
            }
            catch (NamingException namingException) {}
        }
        return infos;
    }

    private static boolean hasNoExtraLeadingZeroes(String pIpV4Cidr) {
        String[] parts = pIpV4Cidr.split("/");
        String[] addressParts = parts[0].split("\\.");
        return addressParts.length != 4 ? false : Stream.concat(Stream.of(parts[1]), Arrays.stream(addressParts)).noneMatch(s -> s.startsWith("0") && s.length() > 1);
    }

    public static boolean isValidSnmpAddr(String pAddress) {
        if (StrUtil.isBlank(pAddress)) {
            return false;
        }
        String[] addresses = pAddress.trim().split(",", -1);
        if (addresses.length == 0) {
            return false;
        }
        String[] var2 = addresses;
        int var3 = addresses.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String address = var2[var4];
            String[] hostAndPort = (address = address.trim()).split(":", 2);
            if (hostAndPort.length == 0) {
                return false;
            }
            if (hostAndPort.length > 2) {
                return false;
            }
            if (StrUtil.isBlank(hostAndPort[0])) {
                return false;
            }
            if (hostAndPort.length != 2) continue;
            try {
                int port = Integer.parseInt(hostAndPort[1]);
                if (port == 162) continue;
                return false;
            }
            catch (Exception var8) {
                return false;
            }
        }
        return true;
    }

    public static boolean isIpv4CidrMaskInvalid(int pCidrMask) {
        return pCidrMask < 1 || pCidrMask > 32;
    }

    public static String ipv4AddressToString(int pIpAddress) {
        return String.format("%d.%d.%d.%d", pIpAddress >> 24 & 0xFF, pIpAddress >> 16 & 0xFF, pIpAddress >> 8 & 0xFF, pIpAddress & 0xFF);
    }

    public static int findFirstOpenPort(int start, int end, String host) {
        for (int i = start; i <= end; ++i) {
            try {
                int var5;
                try (ServerSocket ignored = new ServerSocket(i, 1, InetAddress.getByName(host));){
                    ignored.isBound();
                    var5 = i;
                }
                return var5;
            }
            catch (IOException var9) {
                continue;
            }
        }
        throw new IllegalArgumentException("no free port found");
    }

    private static String removeBrackets(String pIpAddress) {
        return pIpAddress.replaceAll("[\\[\\]]", "");
    }

    public static int nextPowerOf2(int pX) {
        int n = pX - 1;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return ++n;
    }

    public static int highestBit(int pX) {
        int n = pX;
        int r = 0;
        while ((n >>= 1) != 0) {
            ++r;
        }
        return r;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }
}

