/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.lang.Pair;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.stream.StreamUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OptionalUtil {
    public static boolean isAnyPresent(Optional<?> ... optionals) {
        Precondition.notNull(optionals, "Optionals must not be null!", new Object[0]);
        return Arrays.stream(optionals).anyMatch(Optional::isPresent);
    }

    @SafeVarargs
    public static <T> Stream<T> toStream(Optional<? extends T> ... optionals) {
        Precondition.notNull(optionals, "Optional must not be null!", new Object[0]);
        return Arrays.asList(optionals).stream().flatMap(it -> it.map(Stream::of).orElseGet(Stream::empty));
    }

    public static <S, T> Optional<T> firstNonEmpty(Iterable<S> source, Function<S, Optional<T>> function) {
        Precondition.notNull(source, "Source must not be null!", new Object[0]);
        Precondition.notNull(function, "Function must not be null!", new Object[0]);
        return StreamUtil.of(source).map(function::apply).filter(Optional::isPresent).findFirst().orElseGet(Optional::empty);
    }

    public static <S, T> T firstNonEmpty(Iterable<S> source, Function<S, T> function, T defaultValue) {
        Precondition.notNull(source, "Source must not be null!", new Object[0]);
        Precondition.notNull(function, "Function must not be null!", new Object[0]);
        return (T)StreamUtil.of(source).map(function::apply).filter(it -> !it.equals(defaultValue)).findFirst().orElse(defaultValue);
    }

    @SafeVarargs
    public static <T> Optional<T> firstNonEmpty(Supplier<Optional<T>> ... suppliers) {
        Precondition.notNull(suppliers, "Suppliers must not be null!", new Object[0]);
        return OptionalUtil.firstNonEmpty(StreamUtil.of(suppliers).collect(Collectors.toList()));
    }

    public static <T> Optional<T> firstNonEmpty(Iterable<Supplier<Optional<T>>> suppliers) {
        Precondition.notNull(suppliers, "Suppliers must not be null!", new Object[0]);
        return StreamUtil.of(suppliers).map(Supplier::get).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public static <T> Optional<T> next(Iterator<T> iterator) {
        Precondition.notNull(iterator, "Iterator must not be null!", new Object[0]);
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    public static <T, S> Optional<Pair<T, S>> withBoth(Optional<T> left, Optional<S> right) {
        return left.flatMap(l -> right.map(r -> Pair.of(l, r)));
    }

    public static <T, S> void ifAllPresent(Optional<T> left, Optional<S> right, BiConsumer<T, S> consumer) {
        Precondition.notNull(left, "Optional must not be null!", new Object[0]);
        Precondition.notNull(right, "Optional must not be null!", new Object[0]);
        Precondition.notNull(consumer, "Consumer must not be null!", new Object[0]);
        OptionalUtil.mapIfAllPresent(left, right, (l, r) -> {
            consumer.accept(l, r);
            return null;
        });
    }

    public static <T, S, R> Optional<R> mapIfAllPresent(Optional<T> left, Optional<S> right, BiFunction<T, S, R> function) {
        Precondition.notNull(left, "Optional must not be null!", new Object[0]);
        Precondition.notNull(right, "Optional must not be null!", new Object[0]);
        Precondition.notNull(function, "BiFunctionmust not be null!", new Object[0]);
        return left.flatMap(l -> right.map(r -> function.apply(l, r)));
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<? super T> consumer, Runnable runnable) {
        Precondition.notNull(optional, "Optional must not be null!", new Object[0]);
        Precondition.notNull(consumer, "Consumer must not be null!", new Object[0]);
        Precondition.notNull(runnable, "Runnable must not be null!", new Object[0]);
        if (optional.isPresent()) {
            optional.ifPresent(consumer);
        } else {
            runnable.run();
        }
    }
}

