/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.cron;

import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.thread.ExecutorBuilder;
import com.whaleal.icefrog.core.thread.ThreadFactoryBuilder;
import com.whaleal.icefrog.core.util.IdUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.cron.CronConfig;
import com.whaleal.icefrog.cron.CronException;
import com.whaleal.icefrog.cron.CronTimer;
import com.whaleal.icefrog.cron.TaskExecutorManager;
import com.whaleal.icefrog.cron.TaskLauncherManager;
import com.whaleal.icefrog.cron.TaskTable;
import com.whaleal.icefrog.cron.listener.TaskListener;
import com.whaleal.icefrog.cron.listener.TaskListenerManager;
import com.whaleal.icefrog.cron.pattern.CronPattern;
import com.whaleal.icefrog.cron.task.InvokeTask;
import com.whaleal.icefrog.cron.task.RunnableTask;
import com.whaleal.icefrog.cron.task.Task;
import com.whaleal.icefrog.log.StaticLog;
import com.whaleal.icefrog.setting.Setting;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Scheduler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Lock lock = new ReentrantLock();
    protected CronConfig config = new CronConfig();
    protected boolean daemon;
    protected TaskTable taskTable = new TaskTable();
    protected TaskLauncherManager taskLauncherManager;
    protected TaskExecutorManager taskExecutorManager;
    protected TaskListenerManager listenerManager = new TaskListenerManager();
    protected ExecutorService threadExecutor;
    private boolean started = false;
    private CronTimer timer;

    public TimeZone getTimeZone() {
        return this.config.getTimeZone();
    }

    public Scheduler setTimeZone(TimeZone timeZone) {
        this.config.setTimeZone(timeZone);
        return this;
    }

    public Scheduler setThreadExecutor(ExecutorService threadExecutor) throws CronException {
        this.lock.lock();
        try {
            this.checkStarted();
            this.threadExecutor = threadExecutor;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public Scheduler setDaemon(boolean on) throws CronException {
        this.lock.lock();
        try {
            this.checkStarted();
            this.daemon = on;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public boolean isMatchSecond() {
        return this.config.isMatchSecond();
    }

    public Scheduler setMatchSecond(boolean isMatchSecond) {
        this.config.setMatchSecond(isMatchSecond);
        return this;
    }

    public Scheduler addListener(TaskListener listener) {
        this.listenerManager.addListener(listener);
        return this;
    }

    public Scheduler removeListener(TaskListener listener) {
        this.listenerManager.removeListener(listener);
        return this;
    }

    public Scheduler schedule(Setting cronSetting) {
        if (MapUtil.isNotEmpty(cronSetting)) {
            for (Map.Entry<String, LinkedHashMap<String, String>> groupedEntry : cronSetting.getGroupedMap().entrySet()) {
                String group = groupedEntry.getKey();
                for (Map.Entry<String, String> entry : groupedEntry.getValue().entrySet()) {
                    String jobClass = entry.getKey();
                    if (StrUtil.isNotBlank(group)) {
                        jobClass = group + '.' + jobClass;
                    }
                    String pattern = entry.getValue();
                    StaticLog.debug("Load job: {} {}", pattern, jobClass);
                    try {
                        this.schedule(pattern, new InvokeTask(jobClass));
                    }
                    catch (Exception e) {
                        throw new CronException(e, "Schedule [{}] [{}] error!", pattern, jobClass);
                    }
                }
            }
        }
        return this;
    }

    public String schedule(String pattern, Runnable task) {
        return this.schedule(pattern, new RunnableTask(task));
    }

    public String schedule(String pattern, Task task) {
        String id = IdUtil.fastUUID();
        this.schedule(id, pattern, task);
        return id;
    }

    public Scheduler schedule(String id, String pattern, Runnable task) {
        return this.schedule(id, new CronPattern(pattern), (Task)new RunnableTask(task));
    }

    public Scheduler schedule(String id, String pattern, Task task) {
        return this.schedule(id, new CronPattern(pattern), task);
    }

    public Scheduler schedule(String id, CronPattern pattern, Task task) {
        this.taskTable.add(id, pattern, task);
        return this;
    }

    public Scheduler deschedule(String id) {
        this.taskTable.remove(id);
        return this;
    }

    public Scheduler updatePattern(String id, CronPattern pattern) {
        this.taskTable.updatePattern(id, pattern);
        return this;
    }

    public TaskTable getTaskTable() {
        return this.taskTable;
    }

    public CronPattern getPattern(String id) {
        return this.taskTable.getPattern(id);
    }

    public Task getTask(String id) {
        return this.taskTable.getTask(id);
    }

    public boolean isEmpty() {
        return this.taskTable.isEmpty();
    }

    public int size() {
        return this.taskTable.size();
    }

    public Scheduler clear() {
        this.taskTable = new TaskTable();
        return this;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Scheduler start(boolean isDaemon) {
        this.daemon = isDaemon;
        return this.start();
    }

    public Scheduler start() {
        this.lock.lock();
        try {
            this.checkStarted();
            if (null == this.threadExecutor) {
                this.threadExecutor = ExecutorBuilder.create().useSynchronousQueue().setThreadFactory(ThreadFactoryBuilder.create().setNamePrefix("icefrog-cron-").setDaemon(this.daemon).build()).build();
            }
            this.taskLauncherManager = new TaskLauncherManager(this);
            this.taskExecutorManager = new TaskExecutorManager(this);
            this.timer = new CronTimer(this);
            this.timer.setDaemon(this.daemon);
            this.timer.start();
            this.started = true;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public Scheduler stop() {
        return this.stop(false);
    }

    public Scheduler stop(boolean clearTasks) {
        this.lock.lock();
        try {
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started !");
            }
            this.timer.stopTimer();
            this.timer = null;
            this.threadExecutor.shutdown();
            this.threadExecutor = null;
            if (clearTasks) {
                this.clear();
            }
            this.started = false;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    private void checkStarted() throws CronException {
        if (this.started) {
            throw new CronException("Scheduler already started!");
        }
    }
}

