/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.crypto.digest.mac;

import com.whaleal.icefrog.crypto.digest.mac.MacEngine;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class BCHMacEngine
implements MacEngine {
    private Mac mac;

    public BCHMacEngine(Digest digest, byte[] key, byte[] iv) {
        this(digest, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
    }

    public BCHMacEngine(Digest digest, byte[] key) {
        this(digest, (CipherParameters)new KeyParameter(key));
    }

    public BCHMacEngine(Digest digest, CipherParameters params) {
        this.init(digest, params);
    }

    public BCHMacEngine init(Digest digest, CipherParameters params) {
        this.mac = new HMac(digest);
        this.mac.init(params);
        return this;
    }

    public Mac getMac() {
        return this.mac;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.mac.update(in, inOff, len);
    }

    @Override
    public byte[] doFinal() {
        byte[] result = new byte[this.getMacLength()];
        this.mac.doFinal(result, 0);
        return result;
    }

    @Override
    public void reset() {
        this.mac.reset();
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacSize();
    }

    @Override
    public String getAlgorithm() {
        return this.mac.getAlgorithmName();
    }
}

