/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.crypto.symmetric;

import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.HexUtil;
import com.whaleal.icefrog.core.util.RandomUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.crypto.CipherMode;
import com.whaleal.icefrog.crypto.CryptoException;
import com.whaleal.icefrog.crypto.KeyUtil;
import com.whaleal.icefrog.crypto.Padding;
import com.whaleal.icefrog.crypto.SecureUtil;
import com.whaleal.icefrog.crypto.symmetric.SymmetricAlgorithm;
import com.whaleal.icefrog.crypto.symmetric.SymmetricDecryptor;
import com.whaleal.icefrog.crypto.symmetric.SymmetricEncryptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class SymmetricCrypto
implements SymmetricEncryptor,
SymmetricDecryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Lock lock = new ReentrantLock();
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private boolean isZeroPadding;

    public SymmetricCrypto(SymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, SecretKey key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this(algorithm, KeyUtil.generateKey(algorithm, key));
    }

    public SymmetricCrypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        this.initParams(algorithm, paramsSpec);
    }

    private static void copyForZeroPadding(CipherInputStream in, OutputStream out, int blockSize) throws IOException {
        int i;
        int readSize;
        int n = 1;
        if (8192 > blockSize) {
            n = Math.max(n, 8192 / blockSize);
        }
        int bufSize = blockSize * n;
        byte[] preBuffer = new byte[bufSize];
        byte[] buffer = new byte[bufSize];
        boolean isFirst = true;
        int preReadSize = 0;
        while ((readSize = in.read(buffer)) != -1) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(preBuffer, 0, preReadSize);
            }
            ArrayUtil.copy(buffer, preBuffer, readSize);
            preReadSize = readSize;
        }
        for (i = preReadSize - 1; i >= 0 && 0 == preBuffer[i]; --i) {
        }
        out.write(preBuffer, 0, i + 1);
        out.flush();
    }

    public SymmetricCrypto init(String algorithm, SecretKey key) {
        Precondition.notBlank(algorithm, "'algorithm' must be not blank !", new Object[0]);
        this.secretKey = key;
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = StrUtil.replace(algorithm, Padding.ZeroPadding.name(), Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipher = SecureUtil.createCipher(algorithm);
        return this;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public SymmetricCrypto setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public SymmetricCrypto setIv(IvParameterSpec iv) {
        this.setParams(iv);
        return this;
    }

    public SymmetricCrypto setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }

    public SymmetricCrypto setMode(CipherMode mode) {
        this.lock.lock();
        try {
            this.initMode(mode.getValue());
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public byte[] update(byte[] data) {
        this.lock.lock();
        try {
            byte[] byArray = this.cipher.update(this.paddingDataWithZero(data, this.cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String updateHex(byte[] data) {
        return HexUtil.encodeHexStr(this.update(data));
    }

    @Override
    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            Cipher cipher = this.initMode(1);
            byte[] byArray = cipher.doFinal(this.paddingDataWithZero(data, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        this.lock.lock();
        CipherOutputStream cipherOutputStream = null;
        try {
            int remainLength;
            int blockSize;
            Cipher cipher = this.initMode(1);
            cipherOutputStream = new CipherOutputStream(out, cipher);
            long length = IoUtil.copy(data, cipherOutputStream);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0 && (remainLength = (int)(length % (long)blockSize)) > 0) {
                cipherOutputStream.write(new byte[blockSize - remainLength]);
                cipherOutputStream.flush();
            }
        }
        catch (IORuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new CryptoException(e2);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                IoUtil.close(cipherOutputStream);
                if (!isClose) throw throwable;
                IoUtil.close(data);
                throw throwable;
            }
        }
        this.lock.unlock();
        IoUtil.close(cipherOutputStream);
        if (!isClose) return;
        IoUtil.close(data);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            Cipher cipher = this.initMode(2);
            blockSize = cipher.getBlockSize();
            decryptData = cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        CipherInputStream cipherInputStream;
        block7: {
            int blockSize;
            this.lock.lock();
            cipherInputStream = null;
            Cipher cipher = this.initMode(2);
            cipherInputStream = new CipherInputStream(data, cipher);
            if (!this.isZeroPadding || (blockSize = cipher.getBlockSize()) <= 0) break block7;
            SymmetricCrypto.copyForZeroPadding(cipherInputStream, out, blockSize);
            this.lock.unlock();
            IoUtil.close(cipherInputStream);
            if (!isClose) return;
            IoUtil.close(data);
            return;
        }
        try {
            IoUtil.copy(cipherInputStream, out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
                catch (IORuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new CryptoException(e3);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                IoUtil.close(cipherInputStream);
                if (!isClose) throw throwable;
                IoUtil.close(data);
                throw throwable;
            }
        }
        this.lock.unlock();
        IoUtil.close(cipherInputStream);
        if (!isClose) return;
        IoUtil.close(data);
        return;
    }

    private SymmetricCrypto initParams(String algorithm, AlgorithmParameterSpec paramsSpec) {
        if (null == paramsSpec) {
            byte[] iv = null;
            Cipher cipher = this.cipher;
            if (null != cipher) {
                iv = cipher.getIV();
            }
            if (StrUtil.startWithIgnoreCase(algorithm, "PBE")) {
                if (null == iv) {
                    iv = RandomUtil.randomBytes(8);
                }
                paramsSpec = new PBEParameterSpec(iv, 100);
            } else if (StrUtil.startWithIgnoreCase(algorithm, "AES") && null != iv) {
                paramsSpec = new IvParameterSpec(iv);
            }
        }
        return this.setParams(paramsSpec);
    }

    private Cipher initMode(int mode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.cipher;
        if (null == this.params) {
            cipher.init(mode, this.secretKey);
        } else {
            cipher.init(mode, (Key)this.secretKey, this.params);
        }
        return cipher;
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return ArrayUtil.resize(data, length + blockSize - remainLength);
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && blockSize > 0 && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayUtil.resize(data, i + 1);
        }
        return data;
    }
}

