package com.whaleal.icefrog.core.convert.impl;

import com.whaleal.icefrog.core.convert.AbstractConverter;

import java.util.Optional;

/**
 * {@link Optional}对象转换器
 *
 * @author Looly
 * @author wh
 * @since 1.0.0
 */
public class OptionalConverter extends AbstractConverter<Optional<?>> {
    private static final long serialVersionUID = 1L;

    @Override
    protected Optional<?> convertInternal( Object value ) {
        return Optional.ofNullable(value);
    }

}
