/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class BytesLRUCache {
    private static final ConcurrentMap<BytesLRUCache, Boolean> _activeCaches = new ConcurrentHashMap<BytesLRUCache, Boolean>();
    private static final AtomicLong _bytesInGlobalCache = new AtomicLong(0L);
    private static volatile long _bytesGlobalCapacity = 0L;
    final LinkedHashMap<String, byte[]> _cache;
    long _bytesInCache;

    public BytesLRUCache(long bytesCapacity) {
        _bytesGlobalCapacity = bytesCapacity;
        this._bytesInCache = 0L;
        this._cache = new LinkedHashMap(16, 0.75f, true);
    }

    public static void resetAllCache() {
        _activeCaches.clear();
        _bytesInGlobalCache.set(0L);
        _bytesGlobalCapacity = 0L;
    }

    private static void fairlyEvictFromAllActiveCaches() {
        for (BytesLRUCache cache : _activeCaches.keySet()) {
            BytesLRUCache.evictFromCache(cache);
        }
    }

    private static void evictFromCache(BytesLRUCache cache) {
        long targetSize = _bytesGlobalCapacity / (long)_activeCaches.size();
        while (cache._bytesInCache > targetSize) {
            Map.Entry<String, byte[]> oldestEntry = cache._cache.entrySet().iterator().next();
            cache._cache.remove(oldestEntry.getKey());
            _bytesInGlobalCache.addAndGet(-oldestEntry.getValue().length);
            cache._bytesInCache -= (long)oldestEntry.getValue().length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String key) {
        BytesLRUCache bytesLRUCache = this;
        synchronized (bytesLRUCache) {
            return this._cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, byte[] value) {
        BytesLRUCache bytesLRUCache = this;
        synchronized (bytesLRUCache) {
            if (!_activeCaches.containsKey(this) && _activeCaches.putIfAbsent(this, Boolean.TRUE) == null) {
                BytesLRUCache.fairlyEvictFromAllActiveCaches();
            }
            if ((long)value.length <= _bytesGlobalCapacity / (long)_activeCaches.size()) {
                byte[] oldValue = this._cache.put(key, value);
                if (oldValue != null) {
                    _bytesInGlobalCache.addAndGet(-oldValue.length);
                    this._bytesInCache -= (long)oldValue.length;
                }
                _bytesInGlobalCache.addAndGet(value.length);
                this._bytesInCache += (long)value.length;
                BytesLRUCache.evictFromCache(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        BytesLRUCache bytesLRUCache = this;
        synchronized (bytesLRUCache) {
            this._cache.clear();
            _bytesInGlobalCache.addAndGet(-this._bytesInCache);
            this._bytesInCache = 0L;
            _activeCaches.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getStatistics() {
        BytesLRUCache bytesLRUCache = this;
        synchronized (bytesLRUCache) {
            return new Statistics(_activeCaches.size(), this._bytesInCache, _bytesInGlobalCache.get(), _bytesGlobalCapacity);
        }
    }

    public static class Statistics {
        private final int _activeCaches;
        private final long _bytesInCache;
        private final long _bytesInGlobalCache;
        private final long _bytesGlobalCapacity;

        Statistics(int pActiveCaches, long pBytesInCache, long pBytesInGlobalCache, long pBytesGlobalCapacity) {
            this._activeCaches = pActiveCaches;
            this._bytesInCache = pBytesInCache;
            this._bytesInGlobalCache = pBytesInGlobalCache;
            this._bytesGlobalCapacity = pBytesGlobalCapacity;
        }

        public int getActiveCaches() {
            return this._activeCaches;
        }

        public long getBytesInCache() {
            return this._bytesInCache;
        }

        public long getBytesCapacity() {
            if (this._activeCaches == 0) {
                return 0L;
            }
            return this._bytesGlobalCapacity / (long)this._activeCaches;
        }

        public long getBytesInGlobalCache() {
            return this._bytesInGlobalCache;
        }

        public long getBytesGlobalCapacity() {
            return this._bytesGlobalCapacity;
        }

        public double getUtilizationPercent() {
            long capacityPerCache = this.getBytesCapacity();
            if (capacityPerCache == 0L) {
                return 0.0;
            }
            return (double)(this._bytesInCache / capacityPerCache) * 100.0;
        }

        public double getGlobalUtilizationPercent() {
            if (this._bytesGlobalCapacity == 0L) {
                return 0.0;
            }
            return (double)(this._bytesInGlobalCache / this._bytesGlobalCapacity) * 100.0;
        }

        public String toString() {
            return "Cache Statistics: activeCaches=" + this._activeCaches + ", bytesInCache=" + this._bytesInCache + ", bytesCapacity=" + this.getBytesCapacity() + ", cacheUtilization=" + String.format("%.1f", this.getUtilizationPercent()) + ", globalBytesInCache=" + this._bytesInGlobalCache + ", globalBytesCapacity=" + this._bytesGlobalCapacity + ", globalCacheUtilization=" + String.format("%.1f", this.getGlobalUtilizationPercent());
        }
    }
}

