/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.map.multi;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.IterUtil;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.lang.func.Func0;
import com.whaleal.icefrog.core.map.multi.AbsCollValueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CollectionValueMap<K, V>
extends AbsCollValueMap<K, V, Collection<V>> {
    private static final long serialVersionUID = 9012989578038102983L;
    private final Func0<Collection<V>> collectionCreateFunc;

    public CollectionValueMap() {
        this(16);
    }

    public CollectionValueMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CollectionValueMap(Map<? extends K, ? extends Collection<V>> m) {
        this(0.75f, (Map<? extends K, Collection<V>>)m);
    }

    public CollectionValueMap(float loadFactor, Map<? extends K, ? extends Collection<V>> m) {
        this(loadFactor, m, ArrayList::new);
    }

    public CollectionValueMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, ArrayList::new);
    }

    public CollectionValueMap(float loadFactor, Map<? extends K, ? extends Collection<V>> m, Func0<Collection<V>> collectionCreateFunc) {
        this(m.size(), loadFactor, collectionCreateFunc);
        this.putAll(m);
    }

    public CollectionValueMap(int initialCapacity, float loadFactor, Func0<Collection<V>> collectionCreateFunc) {
        super(new HashMap(initialCapacity, loadFactor));
        this.collectionCreateFunc = collectionCreateFunc;
    }

    @Override
    protected Collection<V> createCollection() {
        return this.collectionCreateFunc.applyWithRuntimeException();
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        Collection collection = (Collection)this.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean putAll(K key, Iterable<V> values) {
        Precondition.checkNotNull(values);
        Collection valueCollection = (Collection)values;
        if (valueCollection == null) {
            try {
                this.put(key, CollUtil.newArrayList(values));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (values instanceof Collection) {
            return !valueCollection.isEmpty() && ((Collection)this.get(key)).addAll(valueCollection);
        }
        Iterator<V> valueItr = values.iterator();
        return valueItr.hasNext() && IterUtil.addAll((Collection)this.get(key), valueItr);
    }

    @Override
    public Collection<V> replaceValues(K key, Iterable<V> values) {
        Iterator<V> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return (Collection)this.remove(key);
        }
        Collection coll = (Collection)this.get(key);
        if (null != coll) {
            coll.clear();
            IterUtil.addAll(coll, values);
            return coll;
        }
        Collection<Object> list = CollUtil.addAll(CollUtil.newArrayList(new Object[0]), values);
        this.put(key, list);
        return list;
    }
}

