/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.bean.NullWrapperBean;
import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.convert.BasicType;
import com.whaleal.icefrog.core.exceptions.UtilException;
import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.resource.ResourceUtil;
import com.whaleal.icefrog.core.lang.ClassScanner;
import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.lang.Predicate;
import com.whaleal.icefrog.core.lang.Singleton;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.ClassLoaderUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.core.util.TypeUtil;
import com.whaleal.icefrog.core.util.URLUtil;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ClassUtil {
    private static final Map<String, PrimitiveInfo<?>> PRIMITIVES = CollUtil.createHashMap();
    private static final Map<Class<?>, Set<Class<?>>> assignmentTable = CollUtil.createHashMap();

    public static <T> Class<T> getClass(T obj) {
        return null == obj ? null : obj.getClass();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        return null == clazz ? null : clazz.getEnclosingClass();
    }

    public static boolean isTopLevelClass(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return null == ClassUtil.getEnclosingClass(clazz);
    }

    public static String getClassName(Object obj, boolean isSimple) {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        return ClassUtil.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static String getShortClassName(String className) {
        List<String> packages = StrUtil.split((CharSequence)className, '.');
        if (null == packages || packages.size() < 2) {
            return className;
        }
        int size = packages.size();
        StringBuilder result = StrUtil.builder();
        result.append(packages.get(0).charAt(0));
        for (int i = 1; i < size - 1; ++i) {
            result.append('.').append(packages.get(i).charAt(0));
        }
        result.append('.').append(packages.get(size - 1));
        return result.toString();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            classes[i] = obj instanceof NullWrapperBean ? ((NullWrapperBean)obj).getWrappedClass() : (null == obj ? Object.class : obj.getClass());
        }
        return classes;
    }

    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || StrUtil.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackageByAnnotation(packageName, annotationClass);
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackageBySuper(packageName, superClass);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage();
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName);
    }

    public static Set<Class<?>> scanPackage(String packageName, Predicate<Class<?>> classPredicate) {
        return ClassScanner.scanPackage(packageName, classPredicate);
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        return ReflectUtil.getPublicMethodNames(clazz);
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return ReflectUtil.getPublicMethods(clazz);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Predicate<Method> predicate) {
        return ReflectUtil.getPublicMethods(clazz, predicate);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        return ReflectUtil.getPublicMethods(clazz, excludeMethods);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        return ReflectUtil.getPublicMethods(clazz, excludeMethodNames);
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getPublicMethod(clazz, methodName, paramTypes);
    }

    public static Set<String> getDeclaredMethodNames(Class<?> clazz) {
        return ReflectUtil.getMethodNames(clazz);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectUtil.getMethods(clazz);
    }

    public static Method getDeclaredMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        return ClassUtil.getDeclaredMethod(obj.getClass(), methodName, ClassUtil.getClasses(args));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, methodName, parameterTypes);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(fieldName)) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return clazz.getDeclaredFields();
    }

    public static Set<String> getClassPathResources() {
        return ClassUtil.getClassPathResources(false);
    }

    public static Set<String> getClassPathResources(boolean isDecode) {
        return ClassUtil.getClassPaths("", isDecode);
    }

    public static Set<String> getClassPaths(String packageName) {
        return ClassUtil.getClassPaths(packageName, false);
    }

    public static Set<String> getClassPaths(String packageName, boolean isDecode) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassUtil.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new UtilException(e, "Loading classPath [{}] error!", packagePath);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            String path = resources.nextElement().getPath();
            paths.add(isDecode ? URLUtil.decode(path, CharsetUtil.systemCharsetName()) : path);
        }
        return paths;
    }

    public static String getClassPath() {
        return ClassUtil.getClassPath(false);
    }

    public static String getClassPath(boolean isEncoded) {
        URL classPathURL = ClassUtil.getClassPathURL();
        String url = isEncoded ? classPathURL.getPath() : URLUtil.getDecodedPath(classPathURL);
        return FileUtil.normalize(url);
    }

    public static URL getClassPathURL() {
        return ClassUtil.getResourceURL("");
    }

    public static URL getResourceURL(String resource) throws IORuntimeException {
        return ResourceUtil.getResource(resource);
    }

    public static List<URL> getResources(String resource) {
        return ResourceUtil.getResources(resource);
    }

    public static URL getResourceUrl(String resource, Class<?> baseClass) {
        return ResourceUtil.getResource(resource, baseClass);
    }

    public static String[] getJavaClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    public static ClassLoader getContextClassLoader() {
        return ClassLoaderUtil.getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        return ClassLoaderUtil.getClassLoader();
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayUtil.isEmpty(types1) && ArrayUtil.isEmpty(types2)) {
            return true;
        }
        if (null == types1 || null == types2) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ClassUtil.isBasicType(type1) && ClassUtil.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : false == type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static <T> Class<T> loadClass(String className, boolean isInitialized) {
        return ClassLoaderUtil.loadClass(className, isInitialized);
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassUtil.loadClass(className, true);
    }

    public static <T> T invoke(String classNameWithMethodName, Object[] args) {
        return ClassUtil.invoke(classNameWithMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object ... args) {
        if (StrUtil.isBlank(classNameWithMethodName)) {
            throw new UtilException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new UtilException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return ClassUtil.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return ClassUtil.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class<T> clazz = ClassUtil.loadClass(className);
        try {
            Method method = ClassUtil.getDeclaredMethod(clazz, methodName, ClassUtil.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StrUtil.format("No such method: [{}]", methodName));
            }
            if (ClassUtil.isStatic(method)) {
                return ReflectUtil.invoke(null, method, args);
            }
            return ReflectUtil.invoke(isSingleton ? Singleton.get(clazz, new Object[0]) : clazz.newInstance(), method, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.WRAPPER_PRIMITIVE_MAP.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtil.isPrimitiveWrapper(clazz);
    }

    public static boolean isBasicClass(Class<?> clazz) {
        boolean isPrimitive = false;
        try {
            isPrimitive = clazz.isPrimitive() || clazz.isAssignableFrom(String.class) ? true : ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            isPrimitive = false;
        }
        return isPrimitive;
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassUtil.isSimpleValueType(clazz) || clazz.isArray() && ClassUtil.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassUtil.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class) || TemporalAccessor.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            Class<?> resolvedPrimitive = BasicType.WRAPPER_PRIMITIVE_MAP.get(sourceType);
            return targetType.equals(resolvedPrimitive);
        }
        Class<?> resolvedWrapper = BasicType.PRIMITIVE_WRAPPER_MAP.get(sourceType);
        return resolvedWrapper != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        Precondition.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return false == ClassUtil.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return false == ClassUtil.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        Precondition.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && !method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && false == clazz.isInterface() && false == ClassUtil.isAbstract(clazz) && false == clazz.isEnum() && false == clazz.isArray() && false == clazz.isAnnotation() && false == clazz.isSynthetic() && false == clazz.isPrimitive();
    }

    public static boolean isEnum(Class<?> clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassUtil.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type argumentType = TypeUtil.getTypeArgument(clazz, index);
        return TypeUtil.getClass(argumentType);
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassUtil.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (Long.TYPE == clazz) {
                return 0L;
            }
            if (Integer.TYPE == clazz) {
                return 0;
            }
            if (Short.TYPE == clazz) {
                return (short)0;
            }
            if (Character.TYPE == clazz) {
                return Character.valueOf('\u0000');
            }
            if (Byte.TYPE == clazz) {
                return (byte)0;
            }
            if (Double.TYPE == clazz) {
                return 0.0;
            }
            if (Float.TYPE == clazz) {
                return Float.valueOf(0.0f);
            }
            if (Boolean.TYPE == clazz) {
                return false;
            }
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = ClassUtil.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static boolean isJdkClass(Class<?> clazz) {
        Package objectPackage = clazz.getPackage();
        if (null == objectPackage) {
            return false;
        }
        String objectPackageName = objectPackage.getName();
        return objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || clazz.getClassLoader() == null;
    }

    public static URL getLocation(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String getLocationPath(Class<?> clazz) {
        URL location = ClassUtil.getLocation(clazz);
        if (null == location) {
            return null;
        }
        return location.getPath();
    }

    public static int checkInterfaceDeepth(Class<?> pInterface, Class<?> targetClass) {
        if (targetClass.isAssignableFrom(pInterface)) {
            return 0;
        }
        int min = -1;
        for (Class<?> c : targetClass.getInterfaces()) {
            if (!pInterface.isAssignableFrom(c)) continue;
            int i = ClassUtil.checkInterfaceDeepth(pInterface, c) + 1;
            if (min != -1 && min <= i) continue;
            min = i;
        }
        return min;
    }

    public static int checkSupperClassDeepth(Class<?> supperClass, Class<?> targetClass) {
        int interfaceDeepth;
        if (!supperClass.isAssignableFrom(targetClass)) {
            return -1;
        }
        if (targetClass.isAssignableFrom(supperClass)) {
            return 0;
        }
        int supperDeepth = ClassUtil.checkSupperClassDeepth(supperClass, targetClass.getSuperclass()) + 1;
        if (supperDeepth < (interfaceDeepth = ClassUtil.checkInterfaceDeepth(supperClass, targetClass.getSuperclass()) + 1)) {
            return supperDeepth;
        }
        return interfaceDeepth;
    }

    public static <T> String humpString(Class<T> clazz) {
        String simpleName = clazz.getSimpleName();
        String first = simpleName.charAt(0) + "";
        return first.toLowerCase() + simpleName.substring(1);
    }

    public static String getFriendlyClassNameForObject(Object object) {
        if (object == null) {
            return null;
        }
        String javaClassName = object.getClass().getName();
        return ClassUtil.toFriendlyClassName(javaClassName, true, javaClassName);
    }

    public static String getFriendlyClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String javaClassName = clazz.getName();
        return ClassUtil.toFriendlyClassName(javaClassName, true, javaClassName);
    }

    public static String getFriendlyClassName(String javaClassName) {
        return ClassUtil.toFriendlyClassName(javaClassName, true, javaClassName);
    }

    private static String toFriendlyClassName(String javaClassName, boolean processInnerClass, String defaultIfInvalid) {
        String name = StrUtil.trimToNull(javaClassName);
        if (name == null) {
            return defaultIfInvalid;
        }
        if (processInnerClass) {
            name = name.replace('$', '.');
        }
        int length = name.length();
        int dimension = 0;
        int i = 0;
        while (i < length && name.charAt(i) == '[') {
            ++i;
            ++dimension;
        }
        if (dimension == 0) {
            return name;
        }
        if (length <= dimension) {
            return defaultIfInvalid;
        }
        StringBuilder componentTypeName = new StringBuilder();
        switch (name.charAt(dimension)) {
            case 'Z': {
                componentTypeName.append("boolean");
                break;
            }
            case 'B': {
                componentTypeName.append("byte");
                break;
            }
            case 'C': {
                componentTypeName.append("char");
                break;
            }
            case 'D': {
                componentTypeName.append("double");
                break;
            }
            case 'F': {
                componentTypeName.append("float");
                break;
            }
            case 'I': {
                componentTypeName.append("int");
                break;
            }
            case 'J': {
                componentTypeName.append("long");
                break;
            }
            case 'S': {
                componentTypeName.append("short");
                break;
            }
            case 'L': {
                if (name.charAt(length - 1) != ';' || length <= dimension + 2) {
                    return defaultIfInvalid;
                }
                componentTypeName.append(name.substring(dimension + 1, length - 1));
                break;
            }
            default: {
                return defaultIfInvalid;
            }
        }
        for (int i2 = 0; i2 < dimension; ++i2) {
            componentTypeName.append("[]");
        }
        return componentTypeName.toString();
    }

    public static String getSimpleClassNameForObject(Object object) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getSimpleClassName(object.getClass().getName());
    }

    public static String getSimpleClassNameForObject(Object object, boolean processInnerClass) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getSimpleClassName(object.getClass().getName(), processInnerClass);
    }

    public static String getSimpleClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getSimpleClassName(clazz.getName());
    }

    public static String getSimpleClassName(Class<?> clazz, boolean proccessInnerClass) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getSimpleClassName(clazz.getName(), proccessInnerClass);
    }

    public static String getSimpleClassName(String javaClassName) {
        return ClassUtil.getSimpleClassName(javaClassName, true);
    }

    public static String getSimpleClassName(String javaClassName, boolean proccesInnerClass) {
        String friendlyClassName = ClassUtil.toFriendlyClassName(javaClassName, false, null);
        if (friendlyClassName == null) {
            return javaClassName;
        }
        if (proccesInnerClass) {
            char[] chars = friendlyClassName.toCharArray();
            int beginIndex = 0;
            for (int i = chars.length - 1; i >= 0; --i) {
                if (chars[i] == '.') {
                    beginIndex = i + 1;
                    break;
                }
                if (chars[i] != '$') continue;
                chars[i] = 46;
            }
            return new String(chars, beginIndex, chars.length - beginIndex);
        }
        return friendlyClassName.substring(friendlyClassName.lastIndexOf(".") + 1);
    }

    public static String getSimpleMethodSignature(Method method) {
        return ClassUtil.getSimpleMethodSignature(method, false, false, false, false);
    }

    public static String getSimpleMethodSignature(Method method, boolean withClassName) {
        return ClassUtil.getSimpleMethodSignature(method, false, false, withClassName, false);
    }

    public static String getSimpleMethodSignature(Method method, boolean withModifiers, boolean withReturnType, boolean withClassName, boolean withExceptionType) {
        Class<?>[] exceptionTypes;
        if (method == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (withModifiers) {
            buf.append(Modifier.toString(method.getModifiers())).append(' ');
        }
        if (withReturnType) {
            buf.append(ClassUtil.getSimpleClassName(method.getReturnType())).append(' ');
        }
        if (withClassName) {
            buf.append(ClassUtil.getSimpleClassName(method.getDeclaringClass())).append('.');
        }
        buf.append(method.getName()).append('(');
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            buf.append(ClassUtil.getSimpleClassName(paramType));
            if (i >= paramTypes.length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        if (withExceptionType && !ArrayUtil.isEmptyArray(exceptionTypes = method.getExceptionTypes())) {
            buf.append(" throws ");
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class<?> exceptionType = exceptionTypes[i];
                buf.append(ClassUtil.getSimpleClassName(exceptionType));
                if (i >= exceptionTypes.length - 1) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public static String getPackageNameForObject(Object object) {
        if (object == null) {
            return "";
        }
        return ClassUtil.getPackageName(object.getClass().getName());
    }

    public static String getPackageName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtil.getPackageName(clazz.getName());
    }

    public static String getPackageName(String javaClassName) {
        String friendlyClassName = ClassUtil.toFriendlyClassName(javaClassName, false, null);
        if (friendlyClassName == null) {
            return "";
        }
        int i = friendlyClassName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return friendlyClassName.substring(0, i);
    }

    public static String getResourceNameForObjectClass(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName().replace('.', '/') + ".class";
    }

    public static String getResourceNameForClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static String getResourceNameForClass(String className) {
        if (className == null) {
            return null;
        }
        return className.replace('.', '/') + ".class";
    }

    public static String getResourceNameForObjectPackage(Object object) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getPackageNameForObject(object).replace('.', '/');
    }

    public static String getResourceNameForPackage(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getPackageName(clazz).replace('.', '/');
    }

    public static String getResourceNameForPackage(String className) {
        if (className == null) {
            return null;
        }
        return ClassUtil.getPackageName(className).replace('.', '/');
    }

    public static Class<?> getArrayClass(Class<?> componentType) {
        return ClassUtil.getArrayClass(componentType, 1);
    }

    public static Class<?> getArrayClass(Class<?> componentClass, int dimension) {
        if (componentClass == null) {
            return null;
        }
        switch (dimension) {
            case 1: {
                return Array.newInstance(componentClass, 0).getClass();
            }
            case 0: {
                return componentClass;
            }
        }
        return Array.newInstance(componentClass, new int[dimension]).getClass();
    }

    public static Class<?> getPrimitiveType(String name) {
        PrimitiveInfo<?> info = PRIMITIVES.get(name);
        if (info != null) {
            return info.type;
        }
        return null;
    }

    public static Class<?> getPrimitiveType(Class<?> type) {
        return ClassUtil.getPrimitiveType(type.getName());
    }

    public static <T> Class<T> getWrapperTypeIfPrimitive(Class<T> type) {
        if (type.isPrimitive()) {
            return ClassUtil.PRIMITIVES.get((Object)type.getName()).wrapperType;
        }
        return type;
    }

    public static <T> T getPrimitiveDefaultValue(Class<T> type) {
        PrimitiveInfo<?> info = PRIMITIVES.get(type.getName());
        if (info != null) {
            return info.defaultValue;
        }
        return null;
    }

    private static <T> void addPrimitive(Class<T> type, String typeCode, Class<T> wrapperType, String unwrapMethod, T defaultValue) {
        PrimitiveInfo<T> info = new PrimitiveInfo<T>(type, typeCode, wrapperType, unwrapMethod, defaultValue);
        PRIMITIVES.put(type.getName(), info);
        PRIMITIVES.put(wrapperType.getName(), info);
    }

    public static boolean isAssignable(Class<?>[] classes, Class<?>[] fromClasses) {
        if (!ArrayUtil.isArraySameLength(fromClasses, classes)) {
            return false;
        }
        if (fromClasses == null) {
            fromClasses = ArrayUtil.EMPTY_CLASS_ARRAY;
        }
        if (classes == null) {
            classes = ArrayUtil.EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < fromClasses.length; ++i) {
            if (ClassUtil.isAssignable(classes[i], fromClasses[i])) continue;
            return false;
        }
        return true;
    }

    private static Set<Class<?>> assignableSet(Class<?> ... types) {
        HashSet<Class<?>> assignableSet = CollUtil.createHashSet();
        for (Class<?> type : types) {
            assignableSet.add(ClassUtil.getPrimitiveType(type));
            assignableSet.add(ClassUtil.getWrapperTypeIfPrimitive(type));
        }
        return assignableSet;
    }

    public static String locateClass(Class<?> clazz) {
        return ClassUtil.locateClass(clazz.getName(), clazz.getClassLoader());
    }

    public static String locateClass(String className) {
        return ClassUtil.locateClass(className, null);
    }

    public static String locateClass(String className, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        String classFile = className.replace('.', '/') + ".class";
        URL locationURL = loader.getResource(classFile);
        String location = null;
        if (locationURL != null) {
            location = locationURL.toExternalForm();
            if (location.endsWith(classFile)) {
                location = location.substring(0, location.length() - classFile.length());
            }
            location = location.replaceAll("^(jar|zip):|!/$", "");
        }
        return location;
    }

    public static String getShortNameAsProperty(Class<?> clazz) {
        String shortName = ClassUtil.getShortName(clazz);
        int dotIndex = shortName.lastIndexOf(46);
        shortName = dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
        return Introspector.decapitalize(shortName);
    }

    public static String getShortName(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf("$$");
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getShortName(Class<?> clazz) {
        return ClassUtil.getShortName(ClassUtil.getQualifiedName(clazz));
    }

    public static String getQualifiedName(Class<?> clazz) {
        if (clazz.isArray()) {
            return ClassUtil.getQualifiedNameForArray(clazz);
        }
        return clazz.getName();
    }

    private static String getQualifiedNameForArray(Class<?> clazz) {
        StringBuilder result = new StringBuilder();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            result.append("[]");
        }
        result.insert(0, clazz.getName());
        return result.toString();
    }

    public static String getQualifiedMethodName(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    public static Class[] getAllInterfaces(Object instance) {
        return ClassUtil.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ClassUtil.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, ClassLoader classLoader) {
        Set<Class> ifcs = ClassUtil.getAllInterfacesForClassAsSet(clazz, classLoader);
        return ifcs.toArray(new Class[ifcs.size()]);
    }

    public static Set<Class> getAllInterfacesAsSet(Object instance) {
        return ClassUtil.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz) {
        return ClassUtil.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz, ClassLoader classLoader) {
        if (clazz.isInterface() && ClassUtil.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        while (clazz != null) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                interfaces.addAll(ClassUtil.getAllInterfacesForClassAsSet(ifc, classLoader));
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            Class<?> actualClass = classLoader.loadClass(clazz.getName());
            return clazz == actualClass;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static String getClassFileName(Class clazz) {
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + ".class";
    }

    static {
        ClassUtil.addPrimitive(Boolean.TYPE, "Z", Boolean.class, "booleanValue", false);
        ClassUtil.addPrimitive(Short.TYPE, "S", Short.class, "shortValue", (short)0);
        ClassUtil.addPrimitive(Integer.TYPE, "I", Integer.class, "intValue", 0);
        ClassUtil.addPrimitive(Long.TYPE, "J", Long.class, "longValue", 0L);
        ClassUtil.addPrimitive(Float.TYPE, "F", Float.class, "floatValue", Float.valueOf(0.0f));
        ClassUtil.addPrimitive(Double.TYPE, "D", Double.class, "doubleValue", 0.0);
        ClassUtil.addPrimitive(Character.TYPE, "C", Character.class, "charValue", Character.valueOf('\u0000'));
        ClassUtil.addPrimitive(Byte.TYPE, "B", Byte.class, "byteValue", (byte)0);
        ClassUtil.addPrimitive(Void.TYPE, "V", Void.class, null, null);
        assignmentTable.put(Boolean.TYPE, ClassUtil.assignableSet(Boolean.TYPE));
        assignmentTable.put(Byte.TYPE, ClassUtil.assignableSet(Byte.TYPE));
        assignmentTable.put(Character.TYPE, ClassUtil.assignableSet(Character.TYPE));
        assignmentTable.put(Short.TYPE, ClassUtil.assignableSet(Short.TYPE, Byte.TYPE));
        assignmentTable.put(Integer.TYPE, ClassUtil.assignableSet(Integer.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE));
        assignmentTable.put(Long.TYPE, ClassUtil.assignableSet(Long.TYPE, Integer.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE));
        assignmentTable.put(Float.TYPE, ClassUtil.assignableSet(Float.TYPE, Long.TYPE, Integer.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE));
        assignmentTable.put(Double.TYPE, ClassUtil.assignableSet(Double.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE));
    }

    private static class PrimitiveInfo<T> {
        final Class<T> type;
        final String typeCode;
        final Class<T> wrapperType;
        final String unwrapMethod;
        final T defaultValue;

        public PrimitiveInfo(Class<T> type, String typeCode, Class<T> wrapperType, String unwrapMethod, T defaultValue) {
            this.type = type;
            this.typeCode = typeCode;
            this.wrapperType = wrapperType;
            this.unwrapMethod = unwrapMethod;
            this.defaultValue = defaultValue;
        }
    }
}

