/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.lang.Predicate;
import com.whaleal.icefrog.core.text.escape.Html4Escape;
import com.whaleal.icefrog.core.text.escape.Html4Unescape;
import com.whaleal.icefrog.core.text.escape.XmlEscape;
import com.whaleal.icefrog.core.text.escape.XmlUnescape;
import com.whaleal.icefrog.core.util.StrUtil;

public class EscapeUtil {
    private static final String NOT_ESCAPE_CHARS = "*@-_+./";
    private static final Predicate<Character> JS_ESCAPE_PREDICATE = c -> false == (Character.isDigit(c.charValue()) || Character.isLowerCase(c.charValue()) || Character.isUpperCase(c.charValue()) || StrUtil.contains((CharSequence)NOT_ESCAPE_CHARS, c.charValue()));

    public static String escapeXml(CharSequence xml) {
        XmlEscape escape = new XmlEscape();
        return escape.replace(xml).toString();
    }

    public static String unescapeXml(CharSequence xml) {
        XmlUnescape unescape = new XmlUnescape();
        return unescape.replace(xml).toString();
    }

    public static String escapeHtml4(CharSequence html) {
        Html4Escape escape = new Html4Escape();
        return escape.replace(html).toString();
    }

    public static String unescapeHtml4(CharSequence html) {
        Html4Unescape unescape = new Html4Unescape();
        return unescape.replace(html).toString();
    }

    public static String escape(CharSequence content) {
        return EscapeUtil.escape(content, JS_ESCAPE_PREDICATE);
    }

    public static String escapeAll(CharSequence content) {
        return EscapeUtil.escape(content, c -> true);
    }

    public static String escape(CharSequence content, Predicate<Character> predicate) {
        if (StrUtil.isEmpty(content)) {
            return StrUtil.str(content);
        }
        StringBuilder tmp = new StringBuilder(content.length() * 6);
        for (int i = 0; i < content.length(); ++i) {
            char j = content.charAt(i);
            if (!predicate.apply(Character.valueOf(j))) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String content) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        StringBuilder tmp = new StringBuilder(content.length());
        int lastPos = 0;
        while (lastPos < content.length()) {
            int pos = content.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (content.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(content.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(content.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(content.substring(lastPos));
                lastPos = content.length();
                continue;
            }
            tmp.append(content, lastPos, pos);
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String safeUnescape(String content) {
        try {
            return EscapeUtil.unescape(content);
        }
        catch (Exception exception) {
            return content;
        }
    }
}

