/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.dfa;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.CollectionUtil;
import com.whaleal.icefrog.core.lang.Predicate;
import com.whaleal.icefrog.core.text.StrBuilder;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.dfa.FoundWord;
import com.whaleal.icefrog.dfa.StopChar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WordTree
extends HashMap<Character, WordTree> {
    private static final long serialVersionUID = -4646423269465809276L;
    private final Set<Character> endCharacterSet = new HashSet<Character>();
    private Predicate<Character> charPredicate = StopChar::isNotStopChar;

    public WordTree setCharFilter(Predicate<Character> charPredicate) {
        this.charPredicate = charPredicate;
        return this;
    }

    public WordTree addWords(Collection<String> words) {
        if (!(words instanceof Set)) {
            words = new HashSet<String>(words);
        }
        for (String word : words) {
            this.addWord(word);
        }
        return this;
    }

    public WordTree addWords(String ... words) {
        HashSet<String> wordsSet = CollectionUtil.newHashSet(words);
        for (String word : wordsSet) {
            this.addWord(word);
        }
        return this;
    }

    public WordTree addWord(String word) {
        Predicate<Character> charPredicate = this.charPredicate;
        WordTree parent = null;
        WordTree current = this;
        char currentChar = '\u0000';
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            currentChar = word.charAt(i);
            if (!charPredicate.apply(Character.valueOf(currentChar))) continue;
            WordTree child = (WordTree)current.get(Character.valueOf(currentChar));
            if (child == null) {
                child = new WordTree();
                current.put(Character.valueOf(currentChar), child);
            }
            parent = current;
            current = child;
        }
        if (null != parent) {
            super.setEnd(Character.valueOf(currentChar));
        }
        return this;
    }

    public boolean isMatch(String text) {
        if (null == text) {
            return false;
        }
        return null != this.matchWord(text);
    }

    public String match(String text) {
        FoundWord foundWord = this.matchWord(text);
        return null != foundWord ? foundWord.toString() : null;
    }

    public FoundWord matchWord(String text) {
        if (null == text) {
            return null;
        }
        List<FoundWord> matchAll = this.matchAllWords(text, 1);
        return CollUtil.get(matchAll, 0);
    }

    public List<String> matchAll(String text) {
        return this.matchAll(text, -1);
    }

    public List<FoundWord> matchAllWords(String text) {
        return this.matchAllWords(text, -1);
    }

    public List<String> matchAll(String text, int limit) {
        return this.matchAll(text, limit, false, false);
    }

    public List<FoundWord> matchAllWords(String text, int limit) {
        return this.matchAllWords(text, limit, false, false);
    }

    public List<String> matchAll(String text, int limit, boolean isDensityMatch, boolean isGreedMatch) {
        List<FoundWord> matchAllWords = this.matchAllWords(text, limit, isDensityMatch, isGreedMatch);
        return CollUtil.map(matchAllWords, FoundWord::toString, true);
    }

    public List<FoundWord> matchAllWords(String text, int limit, boolean isDensityMatch, boolean isGreedMatch) {
        if (null == text) {
            return null;
        }
        ArrayList<FoundWord> foundWords = new ArrayList<FoundWord>();
        WordTree current = this;
        int length = text.length();
        Predicate<Character> charPredicate = this.charPredicate;
        StrBuilder wordBuffer = StrUtil.strBuilder();
        StrBuilder keyBuffer = StrUtil.strBuilder();
        for (int i = 0; i < length; ++i) {
            wordBuffer.reset();
            keyBuffer.reset();
            for (int j = i; j < length; ++j) {
                char currentChar = text.charAt(j);
                if (!charPredicate.apply(Character.valueOf(currentChar))) {
                    if (wordBuffer.length() > 0) {
                        wordBuffer.append(currentChar);
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (!current.containsKey(Character.valueOf(currentChar))) break;
                wordBuffer.append(currentChar);
                keyBuffer.append(currentChar);
                if (current.isEnd(Character.valueOf(currentChar))) {
                    foundWords.add(new FoundWord(keyBuffer.toString(), wordBuffer.toString(), i, j));
                    if (limit > 0 && foundWords.size() >= limit) {
                        return foundWords;
                    }
                    if (!isDensityMatch) {
                        i = j;
                    }
                    if (!isGreedMatch) break;
                }
                if (null == (current = (WordTree)current.get(Character.valueOf(currentChar)))) break;
            }
            current = this;
        }
        return foundWords;
    }

    private boolean isEnd(Character c) {
        return this.endCharacterSet.contains(c);
    }

    private void setEnd(Character c) {
        if (null != c) {
            this.endCharacterSet.add(c);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.endCharacterSet.clear();
    }
}

