/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.template.engine.thymeleaf;

import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.TypeReference;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.extra.template.AbstractTemplate;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public class ThymeleafTemplate
extends AbstractTemplate
implements Serializable {
    private static final long serialVersionUID = 781284916568562509L;
    private final TemplateEngine engine;
    private final String template;
    private final Charset charset;

    public ThymeleafTemplate(TemplateEngine engine, String template, Charset charset) {
        this.engine = engine;
        this.template = template;
        this.charset = ObjectUtil.defaultIfNull(charset, CharsetUtil.CHARSET_UTF_8);
    }

    public static ThymeleafTemplate wrap(TemplateEngine engine, String template, Charset charset) {
        return null == engine ? null : new ThymeleafTemplate(engine, template, charset);
    }

    @Override
    public void render(Map<?, ?> bindingMap, Writer writer) {
        Map<String, Object> map = Convert.convert(new TypeReference<Map<String, Object>>(){}, bindingMap);
        Context context = new Context(Locale.getDefault(), map);
        this.engine.process(this.template, (IContext)context, writer);
    }

    @Override
    public void render(Map<?, ?> bindingMap, OutputStream out) {
        this.render(bindingMap, IoUtil.getWriter(out, this.charset));
    }
}

