/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.template.engine.velocity;

import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.TypeReference;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.extra.template.AbstractTemplate;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class VelocityTemplate
extends AbstractTemplate
implements Serializable {
    private static final long serialVersionUID = -132774960373894911L;
    private final Template rawTemplate;
    private String charset;

    public VelocityTemplate(Template rawTemplate) {
        this.rawTemplate = rawTemplate;
    }

    public static VelocityTemplate wrap(Template template) {
        return null == template ? null : new VelocityTemplate(template);
    }

    @Override
    public void render(Map<?, ?> bindingMap, Writer writer) {
        this.rawTemplate.merge((Context)this.toContext(bindingMap), writer);
        IoUtil.flush(writer);
    }

    @Override
    public void render(Map<?, ?> bindingMap, OutputStream out) {
        if (null == this.charset) {
            this.loadEncoding();
        }
        this.render(bindingMap, IoUtil.getWriter(out, this.charset));
    }

    private VelocityContext toContext(Map<?, ?> bindingMap) {
        Map<String, Object> map = Convert.convert(new TypeReference<Map<String, Object>>(){}, bindingMap);
        return new VelocityContext(map);
    }

    private void loadEncoding() {
        String charset = (String)Velocity.getProperty((String)"resource.default_encoding");
        this.charset = StrUtil.isEmpty(charset) ? "UTF-8" : charset;
    }
}

