/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.http.body;

import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.io.resource.MultiResource;
import com.whaleal.icefrog.core.io.resource.Resource;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.RandomUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.http.ContentType;
import com.whaleal.icefrog.http.HttpUtil;
import com.whaleal.icefrog.http.body.RequestBody;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class MultipartBody
implements RequestBody {
    private static final String BOUNDARY = "--------------------icefrog_" + RandomUtil.randomString(16);
    private static final String BOUNDARY_END = StrUtil.format("--{}--\r\n", BOUNDARY);
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_MULTIPART_PREFIX = ContentType.MULTIPART.getValue() + "; boundary=";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n\r\n";
    private final Map<String, Object> form;
    private final Charset charset;

    public MultipartBody(Map<String, Object> form, Charset charset) {
        this.form = form;
        this.charset = charset;
    }

    public static MultipartBody create(Map<String, Object> form, Charset charset) {
        return new MultipartBody(form, charset);
    }

    public static String getContentType() {
        return CONTENT_TYPE_MULTIPART_PREFIX + BOUNDARY;
    }

    @Override
    public void write(OutputStream out) {
        this.writeForm(out);
        this.formEnd(out);
    }

    private void writeForm(OutputStream out) {
        if (MapUtil.isNotEmpty(this.form)) {
            for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                this.appendPart(entry.getKey(), entry.getValue(), out);
            }
        }
    }

    private void appendPart(String formFieldName, Object value, OutputStream out) throws IORuntimeException {
        if (value instanceof MultiResource) {
            for (Resource subResource : (MultiResource)value) {
                this.appendPart(formFieldName, subResource, out);
            }
            return;
        }
        this.write(out, "--", BOUNDARY, "\r\n");
        if (value instanceof Resource) {
            Resource resource = (Resource)value;
            String fileName = resource.getName();
            this.write(out, StrUtil.format(CONTENT_DISPOSITION_FILE_TEMPLATE, formFieldName, ObjectUtil.defaultIfNull(fileName, formFieldName)));
            this.write(out, StrUtil.format(CONTENT_TYPE_FILE_TEMPLATE, HttpUtil.getMimeType(fileName, "application/octet-stream")));
            resource.writeTo(out);
        } else {
            this.write(out, StrUtil.format(CONTENT_DISPOSITION_TEMPLATE, formFieldName));
            this.write(out, value);
        }
        this.write(out, "\r\n");
    }

    private void formEnd(OutputStream out) throws IORuntimeException {
        this.write(out, BOUNDARY_END);
    }

    private void write(OutputStream out, Object ... objs) {
        IoUtil.write(out, this.charset, false, objs);
    }
}

