/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.otp.android.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import com.whatsapp.otp.android.sdk.WhatsAppOtpIntentBuilder;
import com.whatsapp.otp.android.sdk.enums.WhatsAppClientType;
import java.util.List;

public class WhatsAppOtpHandler {
    private final WhatsAppOtpIntentBuilder whatsAppOtpIntentBuilder;

    public WhatsAppOtpHandler() {
        this.whatsAppOtpIntentBuilder = new WhatsAppOtpIntentBuilder();
    }

    public WhatsAppOtpHandler(boolean sendSdkVersion) {
        this.whatsAppOtpIntentBuilder = new WhatsAppOtpIntentBuilder(sendSdkVersion);
    }

    public WhatsAppOtpHandler(WhatsAppOtpIntentBuilder whatsAppOtpIntentBuilder) {
        this.whatsAppOtpIntentBuilder = whatsAppOtpIntentBuilder;
    }

    public void sendOtpIntentToWhatsApp(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("Context cannot be null");
        }
        this.sendOtpIntentToWhatsApp(context, WhatsAppClientType.CONSUMER);
        this.sendOtpIntentToWhatsApp(context, WhatsAppClientType.BUSINESS);
    }

    public Intent sendOtpIntentToWhatsApp(@NonNull Context context, @NonNull WhatsAppClientType type) {
        Intent intent = this.whatsAppOtpIntentBuilder.create(context, type);
        context.sendBroadcast(intent);
        return intent;
    }

    public boolean isWhatsAppOtpHandshakeSupported(@NonNull Context context) {
        return this.isWhatsAppOtpHandshakeSupported(context, WhatsAppClientType.CONSUMER) || this.isWhatsAppOtpHandshakeSupported(context, WhatsAppClientType.BUSINESS);
    }

    public boolean isWhatsAppOtpHandshakeSupported(@NonNull Context context, @NonNull WhatsAppClientType type) {
        Intent intent = new Intent();
        intent.setPackage(type.getPackageName());
        intent.setAction("com.whatsapp.otp.OTP_REQUESTED");
        PackageManager packageManager = context.getPackageManager();
        List receivers = packageManager.queryBroadcastReceivers(intent, 0);
        return !receivers.isEmpty();
    }

    public boolean isWhatsAppInstalled(@NonNull Context context) {
        return this.isWhatsAppInstalled(context, WhatsAppClientType.CONSUMER) || this.isWhatsAppInstalled(context, WhatsAppClientType.BUSINESS);
    }

    public boolean isWhatsAppInstalled(@NonNull Context context, @NonNull WhatsAppClientType type) {
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo(type.getPackageName(), 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

