/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.otp.android.sdk;

import android.app.PendingIntent;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.whatsapp.otp.android.sdk.data.DebugSignal;
import com.whatsapp.otp.android.sdk.enums.WhatsAppClientType;
import com.whatsapp.otp.android.sdk.enums.WhatsAppOtpError;
import com.whatsapp.otp.android.sdk.exceptions.InvalidWhatsAppOtpIntentException;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class WhatsAppOtpIncomingIntentHandler {
    private static final String CODE_KEY = "code";
    private static final String OTP_ERROR_IDENTIFIER_KEY = "error";
    private static final String OTP_ERROR_MESSAGE_KEY = "error_message";
    private static final WhatsAppClientType[] WA_PACKAGES = new WhatsAppClientType[]{WhatsAppClientType.CONSUMER, WhatsAppClientType.BUSINESS};

    public void processOtpCode(Intent intent, Consumer<String> onCodePresent, BiConsumer<WhatsAppOtpError, Exception> errorHandler) {
        try {
            String otpCode = this.getOtpCodeFromWhatsAppIntent(intent);
            if (otpCode != null) {
                onCodePresent.accept(otpCode);
            } else {
                errorHandler.accept(WhatsAppOtpError.OTP_CODE_NOT_RECEIVED, null);
            }
        }
        catch (InvalidWhatsAppOtpIntentException e) {
            errorHandler.accept(WhatsAppOtpError.INTENT_IS_NOT_FROM_WHATSAPP, e);
        }
        catch (Exception e) {
            errorHandler.accept(WhatsAppOtpError.GENERIC_EXCEPTION, e);
        }
    }

    @Nullable
    public String getOtpCodeFromWhatsAppIntent(@NonNull Intent intent) {
        if (this.isIntentFromWhatsApp(intent)) {
            return intent.getStringExtra(CODE_KEY);
        }
        throw new InvalidWhatsAppOtpIntentException("Invalid Intent");
    }

    public void processOtpDebugSignals(@NonNull Intent intent, @NonNull Consumer<DebugSignal> debugSignalConsumer, @NonNull BiConsumer<WhatsAppOtpError, Exception> errorHandler) {
        try {
            DebugSignal debugSignal = this.getDebugSignalFromWhatsAppIntent(intent);
            debugSignalConsumer.accept(debugSignal);
        }
        catch (InvalidWhatsAppOtpIntentException e) {
            errorHandler.accept(WhatsAppOtpError.INTENT_IS_NOT_FROM_WHATSAPP, e);
        }
        catch (Exception e) {
            errorHandler.accept(WhatsAppOtpError.GENERIC_EXCEPTION, e);
        }
    }

    public DebugSignal getDebugSignalFromWhatsAppIntent(@NonNull Intent intent) {
        if (this.isIntentFromWhatsApp(intent)) {
            return this.extractDebugSignal(intent);
        }
        throw new InvalidWhatsAppOtpIntentException("Invalid Intent");
    }

    private DebugSignal extractDebugSignal(Intent intent) {
        String otpErrorKey = intent.getStringExtra(OTP_ERROR_IDENTIFIER_KEY);
        String otpErrorMessage = intent.getStringExtra(OTP_ERROR_MESSAGE_KEY);
        return new DebugSignal(otpErrorKey, otpErrorMessage);
    }

    public boolean isIntentFromWhatsApp(@NonNull Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("_ci_");
        if (pendingIntent == null) {
            return false;
        }
        return WhatsAppOtpIncomingIntentHandler.isPendingIntentFromWhatsApp(pendingIntent, WA_PACKAGES);
    }

    public boolean isIntentFromWhatsApp(@NonNull Intent intent, WhatsAppClientType ... clientType) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("_ci_");
        if (pendingIntent == null) {
            return false;
        }
        return WhatsAppOtpIncomingIntentHandler.isPendingIntentFromWhatsApp(pendingIntent, clientType);
    }

    private static boolean isPendingIntentFromWhatsApp(@NonNull PendingIntent pendingIntent, WhatsAppClientType ... clientType) {
        String pendingIntentCreatorPackage = pendingIntent.getCreatorPackage();
        return Arrays.stream(clientType).map(WhatsAppClientType::getPackageName).anyMatch(packageName -> packageName.equals(pendingIntentCreatorPackage));
    }
}

