/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.otp.android.sdk;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import com.whatsapp.otp.android.sdk.enums.WhatsAppClientType;

public class WhatsAppOtpIntentBuilder {
    private static final String TAG = WhatsAppOtpIntentBuilder.class.getSimpleName();
    public static final String CALLER_INFO = "_ci_";
    public static final String SDK_VERSION = "SDK_VERSION";
    public static final String DEFAULT_VERSION = "0.1.0_not_from_manifest";
    private boolean sendSdkVersion;

    public WhatsAppOtpIntentBuilder() {
        this.sendSdkVersion = true;
    }

    public WhatsAppOtpIntentBuilder(boolean sendSdkVersion) {
        this.sendSdkVersion = sendSdkVersion;
    }

    @NonNull
    public synchronized Intent create(@NonNull Context context, @NonNull WhatsAppClientType type) {
        if (type == null) {
            throw new NullPointerException("WhatsApp application type must be defined.");
        }
        if (context == null) {
            throw new NullPointerException("Context cannot be null.");
        }
        Intent intent = this.createOtpRequestedIntentForWhatsApp(context, type.getPackageName());
        this.addPendingIntentForOtp(context, intent);
        return intent;
    }

    @NonNull
    private Intent createOtpRequestedIntentForWhatsApp(Context context, String whatsAppPackageName) {
        Intent listenIntent = new Intent();
        listenIntent.setPackage(whatsAppPackageName);
        listenIntent.setAction("com.whatsapp.otp.OTP_REQUESTED");
        return listenIntent;
    }

    private void addPendingIntentForOtp(Context context, Intent intent) {
        int flag = Build.VERSION.SDK_INT >= 31 ? 0x4000000 : 0;
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)flag);
        Bundle extras = intent.getExtras();
        if (extras == null) {
            extras = new Bundle();
        }
        extras.putParcelable(CALLER_INFO, (Parcelable)pendingIntent);
        if (this.sendSdkVersion) {
            String implementationVersionFromManifest = this.getSdkVersion();
            extras.putString(SDK_VERSION, implementationVersionFromManifest);
        }
        intent.putExtras(extras);
    }

    private String getSdkVersion() {
        Package aPackage = this.getClass().getPackage();
        String versionFromPackage = aPackage != null ? aPackage.getImplementationVersion() : null;
        return versionFromPackage != null ? versionFromPackage : DEFAULT_VERSION;
    }

    private static /* synthetic */ void lambda$createOtpRequestedIntentForWhatsApp$0(ResolveInfo item) {
        Log.d((String)TAG, (String)item.toString());
    }
}

