/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache;

import com.whirlycott.cache.Cache;
import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheDecorator;
import com.whirlycott.cache.CacheException;
import com.whirlycott.cache.CacheMaintenancePolicy;
import com.whirlycott.cache.ManagedCache;
import com.whirlycott.cache.Messages;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class CacheManager {
    protected static final Map configuration = new HashMap();
    static String defaultCacheName = null;
    private static final Log log = LogFactory.getLog((Class)(class$com$whirlycott$cache$CacheManager == null ? (class$com$whirlycott$cache$CacheManager = CacheManager.class$("com.whirlycott.cache.CacheManager")) : class$com$whirlycott$cache$CacheManager));
    protected static final CacheManager singleton = new CacheManager();
    protected final Map namedCaches = new HashMap();
    static /* synthetic */ Class class$com$whirlycott$cache$CacheManager;

    public static Map getConfiguration() {
        return configuration;
    }

    public static CacheManager getInstance() {
        return singleton;
    }

    private CacheManager() {
        log.info((Object)Messages.getString("CacheManager.creating_new_cache_manager_singleton"));
        try {
            this.configure();
            log.debug((Object)Messages.getString("CacheManager.creating_default_cache"));
            this.createCache((CacheConfiguration)configuration.get(defaultCacheName));
        }
        catch (CacheException cacheException) {
            log.fatal((Object)cacheException.getMessage(), (Throwable)cacheException);
        }
    }

    protected void configure() throws CacheException {
        log.debug((Object)Messages.getString("CacheManager.configuring_the_whirlycache"));
        Document document = this.loadConfigFile("/whirlycache.xml");
        if (document == null) {
            log.warn((Object)"Could not load /whirlycache.xml file. Falling back to defaults.");
            document = this.loadConfigFile("/whirlycache-default.xml");
            if (document == null) {
                String string = Messages.getString("CacheManager.cannot_load_default_config_file");
                throw new CacheException(string);
            }
        }
        Element element = document.getRootElement();
        defaultCacheName = element.getChild("default-cache").getValue();
        log.debug((Object)(Messages.getString("CacheManager.default_cache_name") + defaultCacheName));
        List list = element.getChildren("cache");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CacheConfiguration cacheConfiguration = new CacheConfiguration();
            Element element2 = (Element)iterator.next();
            String string = element2.getAttribute("name").getValue();
            log.debug((Object)(Messages.getString("CacheManager.cache_name") + string));
            cacheConfiguration.setName(string);
            List list2 = element2.getChildren();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Element element3 = (Element)iterator2.next();
                if ("backend".equals(element3.getName())) {
                    cacheConfiguration.setBackend(element3.getValue());
                } else if ("tuner-sleeptime".equals(element3.getName())) {
                    cacheConfiguration.setTunerSleepTime(new Integer(element3.getValue()));
                } else if ("policy".equals(element3.getName())) {
                    cacheConfiguration.setPolicy(element3.getValue());
                } else if ("maxsize".equals(element3.getName())) {
                    cacheConfiguration.setMaxSize(new Integer(element3.getValue()));
                } else {
                    cacheConfiguration.setAttribute(element3.getName(), element3.getValue());
                }
                log.debug((Object)(" - " + element3.getName() + "=" + element3.getValue()));
            }
            log.debug((Object)Messages.getString("CacheManager.making_named_caches"));
            this.createCache(cacheConfiguration);
            configuration.put(element2.getAttribute("name").getValue(), cacheConfiguration);
        }
    }

    public Cache createCache(CacheConfiguration cacheConfiguration) throws CacheException {
        Cache cache;
        if (cacheConfiguration == null || cacheConfiguration.getName() == null) {
            String string = Messages.getString("CacheManager.cache_name_cannot_be_null");
            log.error((Object)string);
            throw new CacheException(string);
        }
        Object v = this.namedCaches.get(cacheConfiguration.getName());
        if (v == null) {
            try {
                String string = cacheConfiguration.getBackend();
                log.debug((Object)("Cache backend is " + string));
                Object obj = Class.forName(string).newInstance();
                if (!(obj instanceof ManagedCache)) {
                    throw new CacheException("Problem creating an instance of " + string + " because it does not implement the ManagedCache interface.");
                }
                ManagedCache managedCache = (ManagedCache)obj;
                CacheMaintenancePolicy cacheMaintenancePolicy = this.createPolicy(managedCache, cacheConfiguration);
                cache = new CacheDecorator(managedCache, cacheConfiguration, new CacheMaintenancePolicy[]{cacheMaintenancePolicy});
            }
            catch (Exception exception) {
                log.fatal((Object)Messages.getString("CacheManager.cannot_create_instance_of_impl"), (Throwable)exception);
                throw new CacheException(exception);
            }
            this.namedCaches.put(cacheConfiguration.getName(), cache);
        } else {
            cache = (Cache)v;
        }
        return cache;
    }

    private CacheMaintenancePolicy createPolicy(ManagedCache managedCache, CacheConfiguration cacheConfiguration) throws CacheException {
        CacheMaintenancePolicy cacheMaintenancePolicy;
        String string = cacheConfiguration.getPolicy();
        if (null == string) {
            throw new IllegalArgumentException(Messages.getString("CacheManager.cache_config_get_policy_cannot_be_null"));
        }
        try {
            cacheMaintenancePolicy = (CacheMaintenancePolicy)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new CacheException("Cannot make an instance of policy class " + string, exception);
        }
        if (cacheMaintenancePolicy != null) {
            cacheMaintenancePolicy.setCache(managedCache);
            cacheMaintenancePolicy.setConfiguration(cacheConfiguration);
        }
        return cacheMaintenancePolicy;
    }

    public void destroy() throws CacheException {
        this.destroy(defaultCacheName);
    }

    public void destroy(String string) throws CacheException {
        CacheDecorator cacheDecorator = (CacheDecorator)this.getCache(string);
        cacheDecorator.clear();
        cacheDecorator.shutdown();
        this.namedCaches.remove(string);
    }

    public Cache getCache() throws CacheException {
        return this.getCache(defaultCacheName);
    }

    public Cache getCache(String string) throws CacheException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("CacheManager.cannot_get_cache_with_null_name"));
        }
        Cache cache = (Cache)this.namedCaches.get(string);
        if (cache == null) {
            throw new CacheException("There is no cache called '" + string + "'");
        }
        return cache;
    }

    protected Document loadConfigFile(String string) throws CacheException {
        if (string == null) {
            throw new CacheException(Messages.getString("CacheManager.cannot_load_null_config_file"));
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                return new SAXBuilder().build(inputStream);
            }
            catch (Exception exception) {
                log.error((Object)("Problem loading " + string));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws CacheException {
        Map map = this.namedCaches;
        synchronized (map) {
            Iterator iterator = this.namedCaches.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    this.destroy((String)iterator.next());
                }
                catch (CacheException cacheException) {
                    throw new CacheException(Messages.getString("CacheManager.problem_shutting_down"));
                }
            }
        }
    }

    public String[] getCacheNames() {
        Object[] objectArray = this.namedCaches.keySet().toArray();
        int n = objectArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

