/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache.component.store;

import com.whirlycott.cache.Cache;
import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheDecorator;
import com.whirlycott.cache.CacheMaintenancePolicy;
import com.whirlycott.cache.ManagedCache;
import com.whirlycott.cache.Messages;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;

public class WhirlycacheStore
implements Store,
ThreadSafe,
Configurable,
Initializable,
Disposable {
    private Cache cache;
    private CacheConfiguration cacheConfiguration;
    private Class cacheMaintenancePolicyClass;
    private Class managedCacheClass;

    public void clear() {
        this.cache.clear();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration backend = configuration.getChild("backend");
        Configuration policy = configuration.getChild("policy");
        this.cacheConfiguration = new CacheConfiguration();
        this.cacheConfiguration.setName(configuration.getChild("name").getValue(this.toString()));
        this.cacheConfiguration.setBackend(backend.getValue());
        this.cacheConfiguration.setMaxSize(configuration.getChild("maxsize").getValueAsInteger());
        this.cacheConfiguration.setPolicy(policy.getValue());
        this.cacheConfiguration.setTunerSleepTime(configuration.getChild("tuner-sleeptime").getValueAsInteger());
        this.managedCacheClass = this.loadManagedCacheClass(backend.getLocation());
        this.cacheMaintenancePolicyClass = this.loadCacheMaintenancePolicyClass(policy.getLocation());
    }

    public boolean containsKey(Object key) {
        boolean retval = false;
        if (this.cache.retrieve(key) != null) {
            retval = true;
        }
        return retval;
    }

    private CacheMaintenancePolicy[] createCacheMaintenancePolicies(ManagedCache cache) throws IllegalAccessException, InstantiationException {
        CacheMaintenancePolicy policy = (CacheMaintenancePolicy)this.cacheMaintenancePolicyClass.newInstance();
        policy.setCache(cache);
        policy.setConfiguration(this.cacheConfiguration);
        return new CacheMaintenancePolicy[]{policy};
    }

    public void dispose() {
        this.cache.clear();
        ((CacheDecorator)this.cache).shutdown();
    }

    public void free() {
    }

    public Object get(Object key) {
        return this.cache.retrieve(key);
    }

    public void initialize() throws Exception {
        ManagedCache managedCache = (ManagedCache)this.managedCacheClass.newInstance();
        this.cache = new CacheDecorator(managedCache, this.cacheConfiguration, this.createCacheMaintenancePolicies(managedCache));
    }

    public Enumeration keys() {
        throw new UnsupportedOperationException();
    }

    private Class loadCacheMaintenancePolicyClass(String _location) throws ConfigurationException {
        String policy = this.cacheConfiguration.getPolicy();
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(policy);
            if (!CacheMaintenancePolicy.class.isAssignableFrom(clazz)) {
                Object[] args = new Object[]{policy, _location};
                throw new ConfigurationException(Messages.getCompoundString("WhirlycacheStore.not_cache_maintenance_policy", args));
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{policy, _location};
            throw new ConfigurationException(Messages.getCompoundString("WhirlycacheStore.cannot_load_policy", args), (Throwable)e);
        }
    }

    private Class loadManagedCacheClass(String _location) throws ConfigurationException {
        String backend = this.cacheConfiguration.getBackend();
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(backend);
            if (!ManagedCache.class.isAssignableFrom(clazz)) {
                Object[] args = new Object[]{backend, _location};
                throw new ConfigurationException(Messages.getCompoundString("WhirlycacheStore.not_managed_cache", args));
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{backend, _location};
            throw new ConfigurationException(Messages.getCompoundString("WhirlycacheStore.cannot_load_backend", args), (Throwable)e);
        }
    }

    public void remove(Object key) {
        this.cache.remove(key);
    }

    public int size() {
        return this.cache.size();
    }

    public void store(Object key, Object value) throws IOException {
        this.cache.store(key, value);
    }
}

