/*
 * Decompiled with CFR 0.152.
 */
package com.whisk.docker.impl.spotify;

import com.google.common.io.Closeables;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.exceptions.ContainerNotFoundException;
import com.spotify.docker.client.messages.AttachedNetwork;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.HostConfig;
import com.whisk.docker.ContainerLink;
import com.whisk.docker.ContainerPort$;
import com.whisk.docker.DockerCommandExecutor;
import com.whisk.docker.DockerContainer;
import com.whisk.docker.DockerPortMapping;
import com.whisk.docker.InspectContainerResult;
import com.whisk.docker.PortBinding;
import com.whisk.docker.RetryUtils$;
import com.whisk.docker.impl.spotify.SpotifyDockerCommandExecutor$;
import com.whisk.docker.package;
import com.whisk.docker.package$;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001\u0002\b\u0010\u0001iA\u0001\"\n\u0001\u0003\u0006\u0004%\tE\n\u0005\te\u0001\u0011\t\u0011)A\u0005O!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003B\u0001\u0011\u0005#\tC\u0003U\u0001\u0011\u0005S\u000bC\u0003_\u0001\u0011\u0005s\fC\u0003k\u0001\u0011\u00053\u000eC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0002\u001d'B|G/\u001b4z\t>\u001c7.\u001a:D_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^8s\u0015\t\u0001\u0012#A\u0004ta>$\u0018NZ=\u000b\u0005I\u0019\u0012\u0001B5na2T!\u0001F\u000b\u0002\r\u0011|7m[3s\u0015\t1r#A\u0003xQ&\u001c8NC\u0001\u0019\u0003\r\u0019w.\\\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001aS\"A\n\n\u0005\u0011\u001a\"!\u0006#pG.,'oQ8n[\u0006tG-\u0012=fGV$xN]\u0001\u0005Q>\u001cH/F\u0001(!\tAsF\u0004\u0002*[A\u0011!&H\u0007\u0002W)\u0011A&G\u0001\u0007yI|w\u000e\u001e \n\u00059j\u0012A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\u000f\u0002\u000b!|7\u000f\u001e\u0011\u0002\r\rd\u0017.\u001a8u!\t)\u0014(D\u00017\u0015\t\u0019tG\u0003\u0002\u0015q)\u0011\u0001cF\u0005\u0003uY\u0012A\u0002R8dW\u0016\u00148\t\\5f]R\fa\u0001P5oSRtDcA\u001f@\u0001B\u0011a\bA\u0007\u0002\u001f!)Q\u0005\u0002a\u0001O!)1\u0007\u0002a\u0001i\u0005y1M]3bi\u0016\u001cuN\u001c;bS:,'\u000f\u0006\u0002D\u001fR\u0011AI\u0013\t\u0004\u000b\";S\"\u0001$\u000b\u0005\u001dk\u0012AC2p]\u000e,(O]3oi&\u0011\u0011J\u0012\u0002\u0007\rV$XO]3\t\u000b-+\u00019\u0001'\u0002\u0005\u0015\u001c\u0007CA#N\u0013\tqeI\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")\u0001+\u0002a\u0001#\u0006!1\u000f]3d!\t\u0011#+\u0003\u0002T'\tyAi\\2lKJ\u001cuN\u001c;bS:,'/\u0001\bti\u0006\u0014HoQ8oi\u0006Lg.\u001a:\u0015\u0005YcFCA,\\!\r)\u0005\n\u0017\t\u00039eK!AW\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0017\u001a\u0001\u001d\u0001\u0014\u0005\u0006;\u001a\u0001\raJ\u0001\u0003S\u0012\f\u0001#\u001b8ta\u0016\u001cGoQ8oi\u0006Lg.\u001a:\u0015\u0005\u0001LGCA1i!\r)\u0005J\u0019\t\u00049\r,\u0017B\u00013\u001e\u0005\u0019y\u0005\u000f^5p]B\u0011!EZ\u0005\u0003ON\u0011a#\u00138ta\u0016\u001cGoQ8oi\u0006Lg.\u001a:SKN,H\u000e\u001e\u0005\u0006\u0017\u001e\u0001\u001d\u0001\u0014\u0005\u0006;\u001e\u0001\raJ\u0001\u0013o&$\b\u000eT8h'R\u0014X-Y7MS:,7\u000fF\u0002mkZ$\"!\u001c9\u0015\u0007asw\u000eC\u0003\u0015\u0011\u0001\u000f\u0011\u0005C\u0003L\u0011\u0001\u000fA\nC\u0003r\u0011\u0001\u0007!/A\u0001g!\u0011a2o\n-\n\u0005Ql\"!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015i\u0006\u00021\u0001(\u0011\u00159\b\u00021\u0001y\u0003\u001d9\u0018\u000e\u001e5FeJ\u0004\"\u0001H=\n\u0005il\"a\u0002\"p_2,\u0017M\\\u0001\u001eo&$\b\u000eT8h'R\u0014X-Y7MS:,7OU3rk&\u0014X-\\3oiR)Q0a\u0002\u0002\nQ\u0019a0a\u0001\u0015\t]{\u0018\u0011\u0001\u0005\u0006)%\u0001\u001d!\t\u0005\u0006\u0017&\u0001\u001d\u0001\u0014\u0005\u0007c&\u0001\r!!\u0002\u0011\tq\u0019x\u0005\u001f\u0005\u0006;&\u0001\ra\n\u0005\u0006o&\u0001\r\u0001_\u0001\u000bY&\u001cH/S7bO\u0016\u001cHCAA\b)\u0011\t\t\"!\u0007\u0011\t\u0015C\u00151\u0003\t\u0005Q\u0005Uq%C\u0002\u0002\u0018E\u00121aU3u\u0011\u0015Y%\u0002q\u0001M\u0003%\u0001X\u000f\u001c7J[\u0006<W\r\u0006\u0003\u0002 \u0005\rBcA,\u0002\"!)1j\u0003a\u0002\u0019\"1\u0011QE\u0006A\u0002\u001d\nQ![7bO\u0016\faA]3n_Z,G\u0003CA\u0016\u0003_\t\t$!\u000e\u0015\u0007]\u000bi\u0003C\u0003L\u0019\u0001\u000fA\nC\u0003^\u0019\u0001\u0007q\u0005\u0003\u0005\u000241\u0001\n\u00111\u0001y\u0003\u00151wN]2f\u0011!\t9\u0004\u0004I\u0001\u0002\u0004A\u0018!\u0004:f[>4XMV8mk6,7/A\u0003dY>\u001cX\rF\u0001Y\u0001")
public class SpotifyDockerCommandExecutor
implements DockerCommandExecutor {
    private final String host;
    private final DockerClient client;

    public boolean remove$default$2() {
        return DockerCommandExecutor.remove$default$2$((DockerCommandExecutor)this);
    }

    public boolean remove$default$3() {
        return DockerCommandExecutor.remove$default$3$((DockerCommandExecutor)this);
    }

    public String host() {
        return this.host;
    }

    public Future<String> createContainer(DockerContainer spec, ExecutionContext ec) {
        scala.collection.immutable.Map portBindings = (scala.collection.immutable.Map)spec.bindPorts().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int guestPort = tuple2._1$mcI$sp();
                DockerPortMapping dockerPortMapping = (DockerPortMapping)tuple2._2();
                if (dockerPortMapping != null) {
                    Option option = dockerPortMapping.hostPort();
                    String address = dockerPortMapping.address();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int hostPort = BoxesRunTime.unboxToInt((Object)some.value());
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)guestPort)).toString()), Collections.singletonList(com.spotify.docker.client.messages.PortBinding.of((String)address, (int)hostPort)));
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int guestPort = tuple2._1$mcI$sp();
            DockerPortMapping dockerPortMapping = (DockerPortMapping)tuple2._2();
            if (dockerPortMapping == null) throw new MatchError((Object)tuple2);
            Option option = dockerPortMapping.hostPort();
            String address = dockerPortMapping.address();
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)guestPort)).toString()), Collections.singletonList(com.spotify.docker.client.messages.PortBinding.randomPort((String)address)));
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Seq binds = (Seq)spec.volumeMappings().map((Function1 & Serializable & scala.Serializable)volumeMapping -> {
            String rw = volumeMapping.rw() ? ":rw" : "";
            return new StringBuilder(1).append(volumeMapping.host()).append(":").append(volumeMapping.container()).append(rw).toString();
        }, Seq$.MODULE$.canBuildFrom());
        HostConfig.Builder hostConfigBase = HostConfig.builder().portBindings((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)portBindings).asJava()).binds((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(binds).asJava());
        Seq links = (Seq)spec.links().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ContainerLink containerLink = x0$2;
            if (containerLink == null) {
                throw new MatchError((Object)containerLink);
            }
            DockerContainer container = containerLink.container();
            String alias = containerLink.alias();
            String string = new StringBuilder(1).append(container.name().get()).append(":").append(alias).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        HostConfig.Builder hostConfigBuilder = links.isEmpty() ? hostConfigBase : hostConfigBase.links((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(links).asJava());
        HostConfig hostConfig = ((HostConfig.Builder)package.OptionalOps$.MODULE$.withOption$extension(package$.MODULE$.OptionalOps(package.OptionalOps$.MODULE$.withOption$extension(package$.MODULE$.OptionalOps(package.OptionalOps$.MODULE$.withOption$extension(package$.MODULE$.OptionalOps(package.OptionalOps$.MODULE$.withOption$extension(package$.MODULE$.OptionalOps((Object)hostConfigBuilder), spec.networkMode(), (Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HostConfig.Builder config = (HostConfig.Builder)tuple2._1();
            String networkMode = (String)tuple2._2();
            HostConfig.Builder builder = config.networkMode(networkMode);
            return builder;
        })), spec.hostConfig().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.tmpfs()), (Function2 & Serializable & scala.Serializable)(x0$4, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HostConfig.Builder config = (HostConfig.Builder)tuple2._1();
            scala.collection.immutable.Map value = (scala.collection.immutable.Map)tuple2._2();
            HostConfig.Builder builder = config.tmpfs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)value).asJava());
            return builder;
        })), spec.hostConfig().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.memory()), (Function2 & Serializable & scala.Serializable)(x0$5, x1$3) -> SpotifyDockerCommandExecutor.$anonfun$createContainer$8(x0$5, BoxesRunTime.unboxToLong((Object)x1$3)))), spec.hostConfig().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.memoryReservation()), (Function2 & Serializable & scala.Serializable)(x0$6, x1$4) -> SpotifyDockerCommandExecutor.$anonfun$createContainer$10(x0$6, BoxesRunTime.unboxToLong((Object)x1$4)))).build();
        ContainerConfig containerConfig = ((ContainerConfig.Builder)package.OptionalOps$.MODULE$.withOption$extension(package$.MODULE$.OptionalOps(package.OptionalOps$.MODULE$.withOption$extension(package$.MODULE$.OptionalOps(package.OptionalOps$.MODULE$.withOption$extension(package$.MODULE$.OptionalOps(package.OptionalOps$.MODULE$.withOption$extension(package$.MODULE$.OptionalOps((Object)ContainerConfig.builder().image(spec.image()).hostConfig(hostConfig).exposedPorts((String[])((TraversableOnce)spec.bindPorts().map((Function1 & Serializable & scala.Serializable)x$4 -> ((Object)BoxesRunTime.boxToInteger((int)x$4._1$mcI$sp())).toString(), Iterable$.MODULE$.canBuildFrom())).toSeq().toArray(ClassTag$.MODULE$.apply(String.class))).tty(Predef$.MODULE$.boolean2Boolean(spec.tty())).attachStdin(Predef$.MODULE$.boolean2Boolean(spec.stdinOpen())).env((String[])spec.env().toArray(ClassTag$.MODULE$.apply(String.class)))), spec.user(), (Function2 & Serializable & scala.Serializable)(x0$7, x1$5) -> {
            Tuple2 tuple2 = new Tuple2(x0$7, x1$5);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ContainerConfig.Builder config = (ContainerConfig.Builder)tuple2._1();
            String user = (String)tuple2._2();
            ContainerConfig.Builder builder = config.user(user);
            return builder;
        })), spec.hostname(), (Function2 & Serializable & scala.Serializable)(x0$8, x1$6) -> {
            Tuple2 tuple2 = new Tuple2(x0$8, x1$6);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ContainerConfig.Builder config = (ContainerConfig.Builder)tuple2._1();
            String hostname = (String)tuple2._2();
            ContainerConfig.Builder builder = config.hostname(hostname);
            return builder;
        })), spec.command(), (Function2 & Serializable & scala.Serializable)(x0$9, x1$7) -> {
            Tuple2 tuple2 = new Tuple2(x0$9, x1$7);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ContainerConfig.Builder config = (ContainerConfig.Builder)tuple2._1();
            Seq command = (Seq)tuple2._2();
            ContainerConfig.Builder builder = config.cmd((String[])command.toArray(ClassTag$.MODULE$.apply(String.class)));
            return builder;
        })), spec.entrypoint(), (Function2 & Serializable & scala.Serializable)(x0$10, x1$8) -> {
            Tuple2 tuple2 = new Tuple2(x0$10, x1$8);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ContainerConfig.Builder config = (ContainerConfig.Builder)tuple2._1();
            Seq entrypoint = (Seq)tuple2._2();
            ContainerConfig.Builder builder = config.entrypoint((String[])entrypoint.toArray(ClassTag$.MODULE$.apply(String.class)));
            return builder;
        })).build();
        Future creation = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ContainerCreation)spec.name().fold((Function0 & Serializable & scala.Serializable)() -> $this.client.createContainer(containerConfig), (Function1 & Serializable & scala.Serializable)x$5 -> $this.client.createContainer(containerConfig, x$5)), ec);
        return creation.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.id(), ec);
    }

    public Future<BoxedUnit> startContainer(String id, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client.startContainer(id), ec);
    }

    public Future<Option<InspectContainerResult>> inspectContainer(String id, ExecutionContext ec) {
        return RetryUtils$.MODULE$.looped((Function0 & Serializable & scala.Serializable)() -> this.inspect$1(id, ec), 5, FiniteDuration$.MODULE$.apply(1L, TimeUnit.SECONDS), ec);
    }

    public void withLogStreamLines(String id, boolean withErr, Function1<String, BoxedUnit> f, DockerCommandExecutor docker, ExecutionContext ec) {
        .colon.colon colon2;
        .colon.colon baseParams = new .colon.colon((Object)DockerClient.AttachParameter.STDOUT, (List)new .colon.colon((Object)DockerClient.AttachParameter.STREAM, (List)new .colon.colon((Object)DockerClient.AttachParameter.LOGS, (List)Nil$.MODULE$)));
        if (withErr) {
            DockerClient.AttachParameter attachParameter = DockerClient.AttachParameter.STDERR;
            colon2 = baseParams.$colon$colon((Object)attachParameter);
        } else {
            colon2 = baseParams;
        }
        .colon.colon logParams = colon2;
        Future streamF = Future$.MODULE$.apply(() -> SpotifyDockerCommandExecutor.$anonfun$withLogStreamLines$1(this, id, (List)logParams), ec);
        streamF.flatMap((Function1 & Serializable & scala.Serializable)stream -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> stream.forEachRemaining((Consumer)new Consumer<LogMessage>(null, f, id){
            private final Function1 f$1;
            private final String id$3;

            public Consumer<LogMessage> andThen(Consumer<? super LogMessage> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(LogMessage t) {
                String str = StandardCharsets.US_ASCII.decode(t.content()).toString();
                this.f$1.apply((Object)new StringBuilder(3).append("[").append(this.id$3).append("] ").append(str).toString());
            }
            {
                this.f$1 = f$1;
                this.id$3 = id$3;
            }
        }), ec), ec);
    }

    public Future<BoxedUnit> withLogStreamLinesRequirement(String id, boolean withErr, Function1<String, Object> f, DockerCommandExecutor docker, ExecutionContext ec) {
        .colon.colon colon2;
        .colon.colon baseParams = new .colon.colon((Object)DockerClient.AttachParameter.STDOUT, (List)new .colon.colon((Object)DockerClient.AttachParameter.STREAM, (List)new .colon.colon((Object)DockerClient.AttachParameter.LOGS, (List)Nil$.MODULE$)));
        if (withErr) {
            DockerClient.AttachParameter attachParameter = DockerClient.AttachParameter.STDERR;
            colon2 = baseParams.$colon$colon((Object)attachParameter);
        } else {
            colon2 = baseParams;
        }
        .colon.colon logParams = colon2;
        Future streamF = Future$.MODULE$.apply(() -> SpotifyDockerCommandExecutor.$anonfun$withLogStreamLinesRequirement$1(this, id, (List)logParams), ec);
        return streamF.flatMap((Function1 & Serializable & scala.Serializable)stream -> {
            Promise p = Promise$.MODULE$.apply();
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> stream.forEachRemaining((Consumer)new Consumer<LogMessage>(null, f, p, stream){
                private final Function1 f$2;
                private final Promise p$1;
                private final LogStream stream$2;

                public Consumer<LogMessage> andThen(Consumer<? super LogMessage> x$1) {
                    return Consumer.super.andThen(x$1);
                }

                public void accept(LogMessage t) {
                    block0: {
                        String str = StandardCharsets.US_ASCII.decode(t.content()).toString();
                        if (!BoxesRunTime.unboxToBoolean((Object)this.f$2.apply((Object)str))) break block0;
                        this.p$1.trySuccess((Object)BoxedUnit.UNIT);
                        Closeables.close((Closeable)this.stream$2, (boolean)true);
                    }
                }
                {
                    this.f$2 = f$2;
                    this.p$1 = p$1;
                    this.stream$2 = stream$2;
                }
            }), ec);
            return p.future();
        }, ec);
    }

    public Future<Set<String>> listImages(ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.client.listImages(new DockerClient.ListImagesParam[0])).asScala()).flatMap((Function1 & Serializable & scala.Serializable)img -> (Seq)Option$.MODULE$.apply((Object)img.repoTags()).map((Function1 & Serializable & scala.Serializable)x$12 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)x$12).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()), Buffer$.MODULE$.canBuildFrom())).toSet(), ec);
    }

    public Future<BoxedUnit> pullImage(String image, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client.pull(image), ec);
    }

    public Future<BoxedUnit> remove(String id, boolean force, boolean removeVolumes, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client.removeContainer(id, new DockerClient.RemoveContainerParam[]{DockerClient.RemoveContainerParam.forceKill((boolean)force), DockerClient.RemoveContainerParam.removeVolumes((boolean)removeVolumes)}), ec);
    }

    public void close() {
        Closeables.close((Closeable)this.client, (boolean)true);
    }

    public static final /* synthetic */ HostConfig.Builder $anonfun$createContainer$8(HostConfig.Builder x0$5, long x1$3) {
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)BoxesRunTime.boxToLong((long)x1$3));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HostConfig.Builder config = (HostConfig.Builder)tuple2._1();
        long memory = tuple2._2$mcJ$sp();
        HostConfig.Builder builder = config.memory(Predef$.MODULE$.long2Long(memory));
        return builder;
    }

    public static final /* synthetic */ HostConfig.Builder $anonfun$createContainer$10(HostConfig.Builder x0$6, long x1$4) {
        Tuple2 tuple2 = new Tuple2((Object)x0$6, (Object)BoxesRunTime.boxToLong((long)x1$4));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HostConfig.Builder config = (HostConfig.Builder)tuple2._1();
        long reservation = tuple2._2$mcJ$sp();
        HostConfig.Builder builder = config.memoryReservation(Predef$.MODULE$.long2Long(reservation));
        return builder;
    }

    public static final /* synthetic */ boolean $anonfun$inspectContainer$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final Future inspect$1(String id$2, ExecutionContext ec$1) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.client.inspectContainer(id$2), ec$1).flatMap((Function1 & Serializable & scala.Serializable)info -> {
            Future future;
            Option networkPorts = Option$.MODULE$.apply((Object)info.networkSettings().ports());
            Option option = networkPorts;
            if (option instanceof Some) {
                scala.collection.immutable.Map ports = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)info.networkSettings().ports()).asScala()).collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, java.util.List<com.spotify.docker.client.messages.PortBinding>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String cPort = (String)A1._1();
                            java.util.List bindings = (java.util.List)A1._2();
                            if (Option$.MODULE$.apply((Object)bindings).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$applyOrElse$1(x$7)))) {
                                List binds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(bindings).asScala()).map((Function1 & Serializable & scala.Serializable)b -> new PortBinding(b.hostIp(), new StringOps(Predef$.MODULE$.augmentString(b.hostPort())).toInt()), Buffer$.MODULE$.canBuildFrom())).toList();
                                object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ContainerPort$.MODULE$.parse(cPort)), (Object)binds);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, java.util.List<com.spotify.docker.client.messages.PortBinding>> x1) {
                        java.util.List bindings;
                        Tuple2<String, java.util.List<com.spotify.docker.client.messages.PortBinding>> tuple2 = x1;
                        boolean bl = tuple2 != null && Option$.MODULE$.apply((Object)(bindings = (java.util.List)tuple2._2())).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$isDefinedAt$1(x$7)));
                        return bl;
                    }

                    public static final /* synthetic */ boolean $anonfun$applyOrElse$1(java.util.List x$7) {
                        return !x$7.isEmpty();
                    }

                    public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(java.util.List x$7) {
                        return !x$7.isEmpty();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(java.util.List ), $anonfun$applyOrElse$2(com.spotify.docker.client.messages.PortBinding ), $anonfun$isDefinedAt$1$adapted(java.util.List )}, serializedLambda);
                    }
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Iterable addresses = (Iterable)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)info.networkSettings().networks()).map((Function1 & Serializable & scala.Serializable)x$8 -> (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)x$8).asScala())).toSeq().flatMap((Function1 & Serializable & scala.Serializable)networks -> (scala.collection.mutable.Iterable)networks.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SpotifyDockerCommandExecutor.$anonfun$inspectContainer$5(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
                    Tuple2 tuple2 = x$9;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    AttachedNetwork network = (AttachedNetwork)tuple2._2();
                    Iterable iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)network.ipAddress()).map((Function1 & Serializable & scala.Serializable)ip -> ip));
                    return iterable;
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                future = Future$.MODULE$.successful((Object)new Some((Object)new InspectContainerResult(Predef$.MODULE$.Boolean2boolean(info.state().running()), ports, info.name(), addresses.toSeq())));
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new Exception("can't extract ports"));
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ec$1).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = A1 instanceof ContainerNotFoundException ? None$.MODULE$ : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof ContainerNotFoundException;
                return bl;
            }
        }, ec$1);
    }

    public static final /* synthetic */ LogStream $anonfun$withLogStreamLines$1(SpotifyDockerCommandExecutor $this, String id$3, List logParams$1) {
        return $this.client.attachContainer(id$3, (DockerClient.AttachParameter[])logParams$1.toArray(ClassTag$.MODULE$.apply(DockerClient.AttachParameter.class)));
    }

    public static final /* synthetic */ LogStream $anonfun$withLogStreamLinesRequirement$1(SpotifyDockerCommandExecutor $this, String id$4, List logParams$2) {
        return $this.client.attachContainer(id$4, (DockerClient.AttachParameter[])logParams$2.toArray(ClassTag$.MODULE$.apply(DockerClient.AttachParameter.class)));
    }

    public SpotifyDockerCommandExecutor(String host, DockerClient client) {
        this.host = host;
        this.client = client;
    }
}

