/*
 * Decompiled with CFR 0.152.
 */
package com.whisk.scalapb.playjson;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.duration.Duration;
import com.trueaccord.scalapb.GeneratedEnum;
import com.trueaccord.scalapb.GeneratedEnumCompanion;
import com.trueaccord.scalapb.GeneratedMessage;
import com.trueaccord.scalapb.GeneratedMessageCompanion;
import com.trueaccord.scalapb.Message;
import com.whisk.scalapb.playjson.FormatRegistry;
import com.whisk.scalapb.playjson.FormatRegistry$;
import com.whisk.scalapb.playjson.JsonFormatException;
import com.whisk.scalapb.playjson.Parser;
import com.whisk.scalapb.playjson.Parser$;
import com.whisk.scalapb.playjson.Printer;
import com.whisk.scalapb.playjson.Printer$;
import com.whisk.scalapb.playjson.WellKnownTypes$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import play.api.libs.json.Format;
import play.api.libs.json.Format$;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsString;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JsonFormat$ {
    public static JsonFormat$ MODULE$;
    private final FormatRegistry DefaultRegistry;
    private final Printer printer;
    private final Parser parser;

    static {
        new JsonFormat$();
    }

    public FormatRegistry DefaultRegistry() {
        return this.DefaultRegistry;
    }

    public Printer printer() {
        return this.printer;
    }

    public Parser parser() {
        return this.parser;
    }

    public <A extends GeneratedMessage> String toJsonString(A m) {
        return this.printer().print(m);
    }

    public <A extends GeneratedMessage> JsValue toJson(A m) {
        return this.printer().toJson(m);
    }

    public <A extends GeneratedMessage & Message<A>> A fromJson(JsValue value, GeneratedMessageCompanion<A> evidence$1) {
        return this.parser().fromJson(value, evidence$1);
    }

    public <A extends GeneratedMessage & Message<A>> A fromJsonString(String str, GeneratedMessageCompanion<A> evidence$2) {
        return this.parser().fromJsonString(str, evidence$2);
    }

    public Object defaultValue(Descriptors.FieldDescriptor fd) {
        Object object;
        Predef$.MODULE$.require(fd.isOptional());
        Descriptors.FieldDescriptor.JavaType javaType = fd.getJavaType();
        if (Descriptors.FieldDescriptor.JavaType.INT.equals(javaType)) {
            object = BoxesRunTime.boxToInteger((int)0);
        } else if (Descriptors.FieldDescriptor.JavaType.LONG.equals(javaType)) {
            object = BoxesRunTime.boxToLong((long)0L);
        } else {
            boolean bl = Descriptors.FieldDescriptor.JavaType.FLOAT.equals(javaType) ? true : Descriptors.FieldDescriptor.JavaType.DOUBLE.equals(javaType);
            if (bl) {
                object = BoxesRunTime.boxToDouble((double)0.0);
            } else if (Descriptors.FieldDescriptor.JavaType.BOOLEAN.equals(javaType)) {
                object = BoxesRunTime.boxToBoolean((boolean)false);
            } else if (Descriptors.FieldDescriptor.JavaType.STRING.equals(javaType)) {
                object = "";
            } else if (Descriptors.FieldDescriptor.JavaType.BYTE_STRING.equals(javaType)) {
                object = ByteString.EMPTY;
            } else if (Descriptors.FieldDescriptor.JavaType.ENUM.equals(javaType)) {
                object = fd.getEnumType().getValues().get(0);
            } else {
                if (Descriptors.FieldDescriptor.JavaType.MESSAGE.equals(javaType)) {
                    throw new RuntimeException("No default value for message");
                }
                throw new MatchError((Object)javaType);
            }
        }
        return object;
    }

    public JsValue defaultJValue(Descriptors.FieldDescriptor fd) {
        JsNumber jsNumber;
        Predef$.MODULE$.require(fd.isOptional());
        Descriptors.FieldDescriptor.JavaType javaType = fd.getJavaType();
        boolean bl = Descriptors.FieldDescriptor.JavaType.INT.equals(javaType) ? true : Descriptors.FieldDescriptor.JavaType.LONG.equals(javaType);
        if (bl) {
            jsNumber = new JsNumber(BigDecimal$.MODULE$.int2bigDecimal(0));
        } else {
            boolean bl2 = Descriptors.FieldDescriptor.JavaType.FLOAT.equals(javaType) ? true : Descriptors.FieldDescriptor.JavaType.DOUBLE.equals(javaType);
            if (bl2) {
                jsNumber = new JsNumber(BigDecimal$.MODULE$.int2bigDecimal(0));
            } else if (Descriptors.FieldDescriptor.JavaType.BOOLEAN.equals(javaType)) {
                jsNumber = JsBoolean$.MODULE$.apply(false);
            } else if (Descriptors.FieldDescriptor.JavaType.STRING.equals(javaType)) {
                jsNumber = new JsString("");
            } else if (Descriptors.FieldDescriptor.JavaType.BYTE_STRING.equals(javaType)) {
                jsNumber = new JsString("");
            } else if (Descriptors.FieldDescriptor.JavaType.ENUM.equals(javaType)) {
                jsNumber = new JsString(((Descriptors.EnumValueDescriptor)fd.getEnumType().getValues().get(0)).getName());
            } else {
                if (Descriptors.FieldDescriptor.JavaType.MESSAGE.equals(javaType)) {
                    throw new RuntimeException("No default value for message");
                }
                throw new MatchError((Object)javaType);
            }
        }
        return jsNumber;
    }

    public <A extends GeneratedMessage> Writes<A> writes() {
        return new Writes<A>(){

            public Writes<A> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<A> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public JsValue writes(A o) {
                return JsonFormat$.MODULE$.toJson(o);
            }
            {
                Writes.$init$((Writes)this);
            }
        };
    }

    public <A extends GeneratedMessage & Message<A>> Reads<A> reads(GeneratedMessageCompanion<A> evidence$3) {
        return new Reads<A>(evidence$3){
            private final GeneratedMessageCompanion evidence$3$1;

            public <B> Reads<B> map(Function1<A, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<A, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<A> filter(Function1<A, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<A> filter(JsonValidationError error, Function1<A, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<A> filterNot(Function1<A, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<A> filterNot(JsonValidationError error, Function1<A, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<A, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<A> orElse(Reads<A> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<A> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef.$less$colon$less<A, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public JsResult<A> reads(JsValue json) {
                JsSuccess jsSuccess;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JsonFormat$.MODULE$.fromJson(json, $this.evidence$3$1));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    GeneratedMessage value = (GeneratedMessage)success.value();
                    jsSuccess = new JsSuccess((Object)value, JsSuccess$.MODULE$.apply$default$2());
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable f = failure.exception();
                    jsSuccess = JsError$.MODULE$.apply(f.getMessage());
                } else {
                    throw new MatchError((Object)try_);
                }
                return jsSuccess;
            }
            {
                this.evidence$3$1 = evidence$3$1;
                Reads.$init$((Reads)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$reads$1(com.whisk.scalapb.playjson.JsonFormat$$anon$2 play.api.libs.json.JsValue )}, serializedLambda);
            }
        };
    }

    public <A extends GeneratedMessage & Message<A>> Format<A> format(GeneratedMessageCompanion<A> evidence$4) {
        return Format$.MODULE$.apply(this.reads(evidence$4), this.writes());
    }

    public <A extends GeneratedEnum> Writes<A> enumWrites() {
        return new Writes<A>(){

            public Writes<A> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<A> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public JsValue writes(A o) {
                return new JsString(o.name());
            }
            {
                Writes.$init$((Writes)this);
            }
        };
    }

    public <A extends GeneratedEnum> Reads<A> enumReads(GeneratedEnumCompanion<A> evidence$5) {
        return new Reads<A>(evidence$5){
            private final GeneratedEnumCompanion evidence$5$1;

            public <B> Reads<B> map(Function1<A, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<A, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<A> filter(Function1<A, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<A> filter(JsonValidationError error, Function1<A, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<A> filterNot(Function1<A, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<A> filterNot(JsonValidationError error, Function1<A, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<A, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<A> orElse(Reads<A> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<A> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef.$less$colon$less<A, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public JsResult<A> reads(JsValue json) {
                Object object;
                JsValue jsValue = json;
                if (jsValue instanceof JsString) {
                    JsSuccess jsSuccess;
                    JsString jsString = (JsString)jsValue;
                    String value = jsString.value();
                    Option option = ((GeneratedEnumCompanion)Predef$.MODULE$.implicitly((Object)this.evidence$5$1)).fromName(value);
                    if (None$.MODULE$.equals(option)) {
                        jsSuccess = new JsSuccess((Object)((GeneratedEnumCompanion)Predef$.MODULE$.implicitly((Object)this.evidence$5$1)).fromValue(-1), JsSuccess$.MODULE$.apply$default$2());
                    } else if (option instanceof Some) {
                        Some some = (Some)option;
                        GeneratedEnum v = (GeneratedEnum)some.value();
                        jsSuccess = new JsSuccess((Object)v, JsSuccess$.MODULE$.apply$default$2());
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object = jsSuccess;
                } else {
                    object = JsNull$.MODULE$.equals(jsValue) ? new JsSuccess((Object)((GeneratedEnumCompanion)Predef$.MODULE$.implicitly((Object)this.evidence$5$1)).fromValue(-1), JsSuccess$.MODULE$.apply$default$2()) : JsError$.MODULE$.apply("incompatible json format");
                }
                return object;
            }
            {
                this.evidence$5$1 = evidence$5$1;
                Reads.$init$((Reads)this);
            }
        };
    }

    public <A extends GeneratedEnum> Format<A> enumFormat(GeneratedEnumCompanion<A> evidence$6) {
        return Format$.MODULE$.apply(this.enumReads(evidence$6), this.enumWrites());
    }

    private JsonFormat$() {
        MODULE$ = this;
        this.DefaultRegistry = new FormatRegistry(FormatRegistry$.MODULE$.apply$default$1()).registerWriter((Function1 & Serializable & scala.Serializable)duration -> WellKnownTypes$.MODULE$.writeDuration((Duration)duration), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            JsValue jsValue = x0$1;
            if (!(jsValue instanceof JsString)) {
                throw new JsonFormatException("Expected a string.");
            }
            JsString jsString = (JsString)jsValue;
            String str = jsString.value();
            Duration duration = WellKnownTypes$.MODULE$.parseDuration(str);
            return duration;
        }, ClassTag$.MODULE$.apply(Duration.class));
        this.printer = new Printer(Printer$.MODULE$.$lessinit$greater$default$1(), Printer$.MODULE$.$lessinit$greater$default$2(), Printer$.MODULE$.$lessinit$greater$default$3());
        this.parser = new Parser(Parser$.MODULE$.$lessinit$greater$default$1());
    }
}

