/*
 * Decompiled with CFR 0.152.
 */
package com.whisk.scalapb.playjson;

import com.google.protobuf.duration.Duration;
import java.text.ParseException;
import play.api.libs.json.JsString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class WellKnownTypes$ {
    public static WellKnownTypes$ MODULE$;
    private final long TIMESTAMP_SECONDS_MIN;
    private final long TIMESTAMP_SECONDS_MAX;
    private final int NANOS_PER_SECOND;
    private final int NANOS_PER_MILLISECOND;
    private final int NANOS_PER_MICROSECOND;
    private final int MILLIS_PER_SECOND;
    private final int MICROS_PER_SECOND;
    private final long DURATION_SECONDS_MIN;
    private final long DURATION_SECONDS_MAX;

    static {
        new WellKnownTypes$();
    }

    public long TIMESTAMP_SECONDS_MIN() {
        return this.TIMESTAMP_SECONDS_MIN;
    }

    public long TIMESTAMP_SECONDS_MAX() {
        return this.TIMESTAMP_SECONDS_MAX;
    }

    public int NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public int NANOS_PER_MILLISECOND() {
        return this.NANOS_PER_MILLISECOND;
    }

    public int NANOS_PER_MICROSECOND() {
        return this.NANOS_PER_MICROSECOND;
    }

    public int MILLIS_PER_SECOND() {
        return this.MILLIS_PER_SECOND;
    }

    public int MICROS_PER_SECOND() {
        return this.MICROS_PER_SECOND;
    }

    public long DURATION_SECONDS_MIN() {
        return this.DURATION_SECONDS_MIN;
    }

    public long DURATION_SECONDS_MAX() {
        return this.DURATION_SECONDS_MAX;
    }

    public void checkValid(Duration duration) {
        boolean secondsInRange = duration.seconds() >= this.DURATION_SECONDS_MIN() && duration.seconds() <= this.DURATION_SECONDS_MAX();
        boolean nanosInRange = (long)duration.nanos() >= -999999999L && duration.nanos() <= this.NANOS_PER_SECOND();
        boolean sameSign = duration.seconds() >= 0L && duration.nanos() >= 0 || duration.seconds() <= 0L && duration.nanos() <= 0;
        Predef$.MODULE$.require(secondsInRange && nanosInRange && sameSign, (Function0 & java.io.Serializable & Serializable)() -> "Duration is not valid.");
    }

    public String formatNanos(int nanos) {
        return nanos % this.NANOS_PER_MILLISECOND() == 0 ? new StringOps(Predef$.MODULE$.augmentString("%1$03d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / this.NANOS_PER_MILLISECOND()))})) : (nanos % this.NANOS_PER_MICROSECOND() == 0 ? new StringOps(Predef$.MODULE$.augmentString("%1$06d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / this.NANOS_PER_MICROSECOND()))})) : new StringOps(Predef$.MODULE$.augmentString("%1$09d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nanos)})));
    }

    public JsString writeDuration(Duration duration) {
        BoxedUnit boxedUnit;
        Tuple2.mcJI.sp sp2;
        Tuple2.mcJI.sp sp3;
        this.checkValid(duration);
        StringBuilder result = new StringBuilder();
        if (duration.seconds() < 0L || duration.nanos() < 0) {
            result.append("-");
            sp3 = new Tuple2.mcJI.sp(-duration.seconds(), -duration.nanos());
        } else {
            sp3 = sp2 = new Tuple2.mcJI.sp(duration.seconds(), duration.nanos());
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long seconds = sp2._1$mcJ$sp();
        int nanos = sp2._2$mcI$sp();
        Tuple2.mcJI.sp sp4 = new Tuple2.mcJI.sp(seconds, nanos);
        Tuple2.mcJI.sp sp5 = sp4;
        long seconds2 = sp5._1$mcJ$sp();
        int nanos2 = sp5._2$mcI$sp();
        result.append(seconds2);
        if (nanos2 != 0) {
            result.append(".");
            boxedUnit = result.append(this.formatNanos(nanos2));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        result.append("s");
        return new JsString(result.result());
    }

    public int parseNanos(String value) {
        String h = (String)new StringOps(Predef$.MODULE$.augmentString(value)).take(9);
        if (!new StringOps(Predef$.MODULE$.augmentString(h)).forall((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$2)))))) {
            throw new ParseException("Invalid nanoseconds.", 0);
        }
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(h)).padTo(9, (Object)BoxesRunTime.boxToCharacter((char)'0'), Predef$.MODULE$.StringCanBuildFrom()))).toInt();
    }

    public Duration parseDuration(String value) {
        int nanos;
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (!value.endsWith("s")) {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        Tuple2 tuple23 = tuple22 = value.startsWith("-") ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)value.substring(1, value.length() - 1)) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)value.substring(0, value.length() - 1));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean negative = tuple22._1$mcZ$sp();
        String number = (String)tuple22._2();
        Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)negative), (Object)number);
        Tuple2 tuple25 = tuple24;
        boolean negative2 = tuple25._1$mcZ$sp();
        String number2 = (String)tuple25._2();
        int pointPosition = number2.indexOf(46);
        Tuple2 tuple26 = tuple2 = pointPosition != -1 ? new Tuple2((Object)number2.substring(0, pointPosition), (Object)number2.substring(pointPosition + 1)) : new Tuple2((Object)number2, (Object)"");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String secondsStr = (String)tuple2._1();
        String nanosStr = (String)tuple2._2();
        Tuple2 tuple27 = new Tuple2((Object)secondsStr, (Object)nanosStr);
        Tuple2 tuple28 = tuple27;
        String secondsStr2 = (String)tuple28._1();
        String nanosStr2 = (String)tuple28._2();
        long seconds = new StringOps(Predef$.MODULE$.augmentString(secondsStr2)).toLong();
        int n = nanos = nanosStr2.isEmpty() ? 0 : this.parseNanos(nanosStr2);
        if (seconds < 0L) {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        return new Duration(negative2 ? -seconds : seconds, negative2 ? -nanos : nanos);
    }

    private WellKnownTypes$() {
        MODULE$ = this;
        this.TIMESTAMP_SECONDS_MIN = -62135596800L;
        this.TIMESTAMP_SECONDS_MAX = 253402300799L;
        this.NANOS_PER_SECOND = 1000000000;
        this.NANOS_PER_MILLISECOND = 1000000;
        this.NANOS_PER_MICROSECOND = 1000;
        this.MILLIS_PER_SECOND = 1000;
        this.MICROS_PER_SECOND = 1000000;
        this.DURATION_SECONDS_MIN = -315576000000L;
        this.DURATION_SECONDS_MAX = 315576000000L;
    }
}

