/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.assertions.support.SupportKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\u001a)\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u0010\u0010\b\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0010\u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0010\u0010\n\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a)\u0010\u000b\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u0018\u0010\f\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\r\u001a\u00020\u0003\u001a\u0010\u0010\u000e\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a8\u0006\u0010"}, d2={"isDirectory", "", "Lassertk/Assert;", "Ljava/nio/file/Path;", "options", "", "Ljava/nio/file/LinkOption;", "(Lassertk/Assert;[Ljava/nio/file/LinkOption;)V", "isExecutable", "isHidden", "isReadable", "isRegularFile", "isSameFileAs", "expected", "isSymbolicLink", "isWritable", "assertk-jvm"})
public final class PathKt {
    public static final void isRegularFile(@NotNull Assert<? extends Path> $receiver, LinkOption ... options) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        if (!Files.isRegularFile($receiver.getActual(), Arrays.copyOf(options, options.length))) {
            SupportKt.expected$default($receiver, SupportKt.show$default($receiver.getActual(), null, 2, null) + " to be a regular file, but it is not", null, null, 6, null);
        }
    }

    public static final void isDirectory(@NotNull Assert<? extends Path> $receiver, LinkOption ... options) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        if (!Files.isDirectory($receiver.getActual(), Arrays.copyOf(options, options.length))) {
            SupportKt.expected$default($receiver, SupportKt.show$default($receiver.getActual(), null, 2, null) + " to be a directory, but it is not", null, null, 6, null);
        }
    }

    public static final void isExecutable(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (!Files.isExecutable($receiver.getActual())) {
            SupportKt.expected$default($receiver, SupportKt.show$default($receiver.getActual(), null, 2, null) + " to be an executable, but it is not", null, null, 6, null);
        }
    }

    public static final void isHidden(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (!Files.isHidden($receiver.getActual())) {
            SupportKt.expected$default($receiver, SupportKt.show$default($receiver.getActual(), null, 2, null) + " to be hidden, but it is not", null, null, 6, null);
        }
    }

    public static final void isReadable(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (!Files.isReadable($receiver.getActual())) {
            SupportKt.expected$default($receiver, SupportKt.show$default($receiver.getActual(), null, 2, null) + " to be readable, but it is not", null, null, 6, null);
        }
    }

    public static final void isSymbolicLink(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (!Files.isSymbolicLink($receiver.getActual())) {
            SupportKt.expected$default($receiver, SupportKt.show$default($receiver.getActual(), null, 2, null) + " to be a symbolic link, but it is not", null, null, 6, null);
        }
    }

    public static final void isWritable(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (!Files.isWritable($receiver.getActual())) {
            SupportKt.expected$default($receiver, SupportKt.show$default($receiver.getActual(), null, 2, null) + " to be writable, but it is not", null, null, 6, null);
        }
    }

    public static final void isSameFileAs(@NotNull Assert<? extends Path> $receiver, @NotNull Path expected) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        if (!Files.isSameFile($receiver.getActual(), expected)) {
            SupportKt.expected$default($receiver, SupportKt.show$default($receiver.getActual(), null, 2, null) + " to be the same file as " + SupportKt.show$default($receiver.getActual(), null, 2, null) + " but is not", null, null, 6, null);
        }
    }
}

