/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.AnyKt;
import assertk.assertions.CollectionKt$size$1;
import assertk.assertions.support.SupportKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\u001a1\u0010\u0000\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a1\u0010\b\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a1\u0010\t\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a \u0010\n\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u001c\u0010\f\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u000f\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u0001*\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00030\u0002\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0002*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u00a8\u0006\u0012"}, d2={"containsAll", "", "Lassertk/Assert;", "", "elements", "", "", "(Lassertk/Assert;[Ljava/lang/Object;)V", "containsNone", "containsOnly", "hasSameSizeAs", "other", "hasSize", "size", "", "isEmpty", "isNotEmpty", "isNullOrEmpty", "assertk-jvm"})
public final class CollectionKt {
    @NotNull
    public static final Assert<Integer> size(@NotNull Assert<? extends Collection<?>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return AnyKt.prop($receiver, "size", (Function1)CollectionKt$size$1.INSTANCE);
    }

    public static final void isEmpty(@NotNull Assert<? extends Collection<?>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Assert<? extends Collection<?>> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                if (actual.isEmpty()) {
                    return;
                }
                Void void_ = SupportKt.expected$default($receiver, "to be empty but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw null;
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNotEmpty(@NotNull Assert<? extends Collection<?>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Assert<? extends Collection<?>> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Collection actual;
                Collection collection = actual = (Collection)((ValueAssert)this_$iv).getValue();
                if (!collection.isEmpty()) {
                    return;
                }
                Void void_ = SupportKt.expected$default($receiver, "to not be empty", null, null, 6, null);
                throw null;
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNullOrEmpty(@NotNull Assert<? extends Collection<?>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Assert<? extends Collection<?>> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                if (actual == null || actual.isEmpty()) {
                    return;
                }
                Void void_ = SupportKt.expected$default($receiver, "to be null or empty but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw null;
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void hasSize(@NotNull Assert<? extends Collection<?>> $receiver, int size2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        AnyKt.isEqualTo(CollectionKt.size($receiver), size2);
    }

    public static final void hasSameSizeAs(@NotNull Assert<? extends Collection<?>> $receiver, @NotNull Collection<?> other) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Assert<? extends Collection<?>> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                int actualSize = actual.size();
                int otherSize = other.size();
                if (actualSize == otherSize) {
                    return;
                }
                Void void_ = SupportKt.expected$default($receiver, "to have same size as:" + SupportKt.show$default(other, null, 2, null) + " (" + otherSize + ") but was size:(" + actualSize + ')', null, null, 6, null);
                throw null;
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void containsNone(@NotNull Assert<? extends Collection<?>> $receiver, Object ... elements) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Assert<? extends Collection<?>> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                void $receiver$iv$iv;
                Object[] $receiver$iv;
                boolean bl;
                Collection actual;
                block6: {
                    actual = (Collection)((ValueAssert)this_$iv).getValue();
                    for (Object element$iv : elements) {
                        Object it = element$iv;
                        if (!actual.contains(it)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (bl) {
                    return;
                }
                Object[] objectArray = $receiver$iv = elements;
                Collection destination$iv$iv = new ArrayList();
                for (void element$iv$iv : $receiver$iv$iv) {
                    void it = element$iv$iv;
                    if (!actual.contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List notExpected = (List)destination$iv$iv;
                Void void_ = SupportKt.expected$default($receiver, "to contain none of:" + SupportKt.show$default(elements, null, 2, null) + " some elements were not expected:" + SupportKt.show$default(notExpected, null, 2, null), null, null, 6, null);
                throw null;
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void containsAll(@NotNull Assert<? extends Collection<?>> $receiver, Object ... elements) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Assert<? extends Collection<?>> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                void $receiver$iv$iv;
                Object[] $receiver$iv;
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                if (actual.containsAll(ArraysKt.toList((Object[])elements))) {
                    return;
                }
                Object[] objectArray = $receiver$iv = elements;
                Collection destination$iv$iv = new ArrayList();
                for (void element$iv$iv : $receiver$iv$iv) {
                    void it = element$iv$iv;
                    if (actual.contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List notFound = (List)destination$iv$iv;
                Void void_ = SupportKt.expected$default($receiver, "to contain all:" + SupportKt.show$default(elements, null, 2, null) + " some elements were not found:" + SupportKt.show$default(notFound, null, 2, null), null, null, 6, null);
                throw null;
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void containsOnly(@NotNull Assert<? extends Collection<?>> $receiver, Object ... elements) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Assert<? extends Collection<?>> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                void $receiver$iv$iv;
                Object it;
                void $receiver$iv$iv2;
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                Object[] $receiver$iv = elements;
                Object object = $receiver$iv;
                Iterable<void> destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    it = element$iv$iv;
                    if (actual.contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List notInActual = (List)destination$iv$iv;
                Iterable $receiver$iv2 = actual;
                destination$iv$iv = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    it = element$iv$iv;
                    if (ArraysKt.contains((Object[])elements, it)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List notInExpected = (List)destination$iv$iv2;
                if (notInExpected.isEmpty() && notInActual.isEmpty()) {
                    return;
                }
                object = notInActual;
                if (!object.isEmpty()) {
                    Void void_ = SupportKt.expected$default($receiver, "to contain only:" + SupportKt.show$default(elements, null, 2, null) + " but some elements were not found:" + SupportKt.show$default(notInActual, null, 2, null), null, null, 6, null);
                    throw null;
                }
                object = notInExpected;
                if (!object.isEmpty()) {
                    Void void_ = SupportKt.expected$default($receiver, "to contain only:" + SupportKt.show$default(elements, null, 2, null) + " but extra elements were found:" + SupportKt.show$default(notInExpected, null, 2, null), null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }
}

