/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.PathKt;
import assertk.assertions.support.SupportKt;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a)\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\u000b\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\f\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a)\u0010\r\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\u000e\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u000f\u001a\u00020\u0003\u001a\u0010\u0010\u0010\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\u0011\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a&\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"bytes", "Lassertk/Assert;", "", "Ljava/nio/file/Path;", "isDirectory", "", "options", "", "Ljava/nio/file/LinkOption;", "(Lassertk/Assert;[Ljava/nio/file/LinkOption;)V", "isExecutable", "isHidden", "isReadable", "isRegularFile", "isSameFileAs", "expected", "isSymbolicLink", "isWritable", "lines", "", "", "charset", "Ljava/nio/charset/Charset;", "assertk-jvm"})
public final class PathKt {
    @NotNull
    public static final Assert<List<String>> lines(@NotNull Assert<? extends Path> $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return Assert.transform$default($receiver, null, (Function1)new Function1<Path, List<String>>(charset){
            final /* synthetic */ Charset $charset;

            public final List<String> invoke(@NotNull Path actual) {
                Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
                return Files.readAllLines(actual, this.$charset);
            }
            {
                this.$charset = charset;
                super(1);
            }
        }, 1, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Assert lines$default(Assert assert_, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return PathKt.lines(assert_, charset);
    }

    @NotNull
    public static final Assert<byte[]> bytes(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Assert.transform$default($receiver, null, bytes.1.INSTANCE, 1, null);
    }

    public static final void isRegularFile(@NotNull Assert<? extends Path> $receiver, LinkOption ... options) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Assert<? extends Path> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                if (!Files.isRegularFile(actual, Arrays.copyOf(options, options.length))) {
                    Void void_ = SupportKt.expected$default($receiver, SupportKt.show$default(actual, null, 2, null) + " to be a regular file, but it is not", null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isDirectory(@NotNull Assert<? extends Path> $receiver, LinkOption ... options) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Assert<? extends Path> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                if (!Files.isDirectory(actual, Arrays.copyOf(options, options.length))) {
                    Void void_ = SupportKt.expected$default($receiver, SupportKt.show$default(actual, null, 2, null) + " to be a directory, but it is not", null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isExecutable(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Assert<? extends Path> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                if (!Files.isExecutable(actual)) {
                    Void void_ = SupportKt.expected$default($receiver, SupportKt.show$default(actual, null, 2, null) + " to be an executable, but it is not", null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isHidden(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Assert<? extends Path> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                if (!Files.isHidden(actual)) {
                    Void void_ = SupportKt.expected$default($receiver, SupportKt.show$default(actual, null, 2, null) + " to be hidden, but it is not", null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isReadable(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Assert<? extends Path> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                if (!Files.isReadable(actual)) {
                    Void void_ = SupportKt.expected$default($receiver, SupportKt.show$default(actual, null, 2, null) + " to be readable, but it is not", null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isSymbolicLink(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Assert<? extends Path> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                if (!Files.isSymbolicLink(actual)) {
                    Void void_ = SupportKt.expected$default($receiver, SupportKt.show$default(actual, null, 2, null) + " to be a symbolic link, but it is not", null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isWritable(@NotNull Assert<? extends Path> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Assert<? extends Path> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                if (!Files.isWritable(actual)) {
                    Void void_ = SupportKt.expected$default($receiver, SupportKt.show$default(actual, null, 2, null) + " to be writable, but it is not", null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isSameFileAs(@NotNull Assert<? extends Path> $receiver, @NotNull Path expected) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        Assert<? extends Path> this_$iv = $receiver;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                if (!Files.isSameFile(actual, expected)) {
                    Void void_ = SupportKt.expected$default($receiver, SupportKt.show$default(actual, null, 2, null) + " to be the same file as " + SupportKt.show$default(actual, null, 2, null) + " but is not", null, null, 6, null);
                    throw null;
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }
}

