/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailingAssert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.support.SupportKt;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a \u0010\b\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a!\u0010\n\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\u00032\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\u0010\r\u001a1\u0010\u000e\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a*\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0002\"\u0004\b\u0000\u0010\u0010*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u0011\u001a1\u0010\u0012\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\u0013"}, d2={"containsExactly", "", "Lassertk/Assert;", "", "elements", "", "", "(Lassertk/Assert;[Ljava/lang/Object;)V", "containsSubList", "sublist", "contentEquals", "", "other", "(Ljava/util/List;[Ljava/lang/Object;)Z", "endsWith", "index", "T", "", "startsWith", "assertk"})
@SourceDebugExtension(value={"SMAP\nlist.kt\nKotlin\n*S Kotlin\n*F\n+ 1 list.kt\nassertk/assertions/ListKt\n+ 2 assert.kt\nassertk/Assert\n*L\n1#1,163:1\n29#2,10:164\n53#2,8:174\n53#2,8:182\n53#2,8:190\n53#2,8:198\n*S KotlinDebug\n*F\n+ 1 list.kt\nassertk/assertions/ListKt\n*L\n17#1:164,10\n37#1:174,8\n68#1:182,8\n112#1:190,8\n144#1:198,8\n*E\n"})
public final class ListKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Assert<T> index(@NotNull Assert<? extends List<? extends T>> $this$index, int index) {
        Assert assert_;
        void this_$iv;
        Intrinsics.checkNotNullParameter($this$index, (String)"<this>");
        Assert<? extends List<? extends T>> assert_2 = $this$index;
        String name$iv = SupportKt.appendName$default($this$index, SupportKt.show(index, "[]"), null, 2, null);
        boolean $i$f$transform = false;
        void var5_5 = this_$iv;
        if (var5_5 instanceof ValueAssert) {
            Assert<Object> assert_3;
            try {
                void actual;
                List list = (List)((ValueAssert)this_$iv).getValue();
                void var9_8 = this_$iv;
                boolean bl = false;
                if (!(0 <= index ? index < actual.size() : false)) {
                    SupportKt.expected$default($this$index, "index to be in range:[0-" + actual.size() + ") but was:" + SupportKt.show$default(index, null, 2, null), null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                assert_3 = var9_8.assertThat(actual.get(index), name$iv);
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
                assert_3 = this_$iv.failing(e$iv, name$iv);
            }
            assert_ = assert_3;
        } else if (var5_5 instanceof FailingAssert) {
            assert_ = this_$iv.failing(((FailingAssert)this_$iv).getError(), name$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return assert_;
    }

    public static final void containsExactly(@NotNull Assert<? extends List<?>> $this$containsExactly, Object ... elements) {
        Intrinsics.checkNotNullParameter($this$containsExactly, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Assert<? extends List<?>> this_$iv = $this$containsExactly;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                List actual = (List)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (ListKt.contentEquals(actual, elements)) {
                    return;
                }
                SupportKt.expectedListDiff($this$containsExactly, ArraysKt.toList((Object[])elements), actual);
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final boolean contentEquals(@NotNull List<?> $this$contentEquals, @NotNull Object[] other) {
        Intrinsics.checkNotNullParameter($this$contentEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$contentEquals.size() != other.length) {
            return false;
        }
        int n = $this$contentEquals.size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual($this$contentEquals.get(i), (Object)other[i])) continue;
            return false;
        }
        return true;
    }

    public static final void containsSubList(@NotNull Assert<? extends List<?>> $this$containsSubList, @NotNull List<?> sublist) {
        Intrinsics.checkNotNullParameter($this$containsSubList, (String)"<this>");
        Intrinsics.checkNotNullParameter(sublist, (String)"sublist");
        Assert<? extends List<?>> this_$iv = $this$containsSubList;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                int matchOfFirstInTarget;
                List actual = (List)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                boolean sublistMatched = sublist.isEmpty();
                List target = actual;
                while (!sublistMatched && (matchOfFirstInTarget = CollectionsKt.indexOf((List)target, (Object)CollectionsKt.first(sublist))) != -1) {
                    Object b;
                    Object a;
                    int n;
                    for (n = 1; n < sublist.size() && matchOfFirstInTarget + n < target.size() && Intrinsics.areEqual(a = target.get(matchOfFirstInTarget + n), b = sublist.get(n)); ++n) {
                    }
                    boolean bl2 = sublistMatched = n == sublist.size();
                    if (sublistMatched || matchOfFirstInTarget + n == target.size()) break;
                    target = target.subList(matchOfFirstInTarget + 1, target.size());
                }
                if (!sublistMatched) {
                    SupportKt.expected$default($this$containsSubList, "to contain the exact sublist (in the same order) as:" + SupportKt.show$default(sublist, null, 2, null) + ", but found none matching in:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void startsWith(@NotNull Assert<? extends List<?>> $this$startsWith, Object ... elements) {
        Intrinsics.checkNotNullParameter($this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Assert<? extends List<?>> this_$iv = $this$startsWith;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                List sublist;
                List actual = (List)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                List list = sublist = actual.size() >= elements.length ? actual.subList(0, elements.length) : actual;
                if (ListKt.contentEquals(sublist, elements)) {
                    return;
                }
                SupportKt.expected$default($this$startsWith, "to start with:" + SupportKt.show$default(elements, null, 2, null) + ", but was:" + SupportKt.show$default(sublist, null, 2, null) + " in:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void endsWith(@NotNull Assert<? extends List<?>> $this$endsWith, Object ... elements) {
        Intrinsics.checkNotNullParameter($this$endsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Assert<? extends List<?>> this_$iv = $this$endsWith;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                List sublist;
                List actual = (List)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                List list = sublist = actual.size() >= elements.length ? actual.subList(actual.size() - elements.length, actual.size()) : actual;
                if (ListKt.contentEquals(sublist, elements)) {
                    return;
                }
                SupportKt.expected$default($this$endsWith, "to end with:" + SupportKt.show$default(elements, null, 2, null) + ", but was:" + SupportKt.show$default(sublist, null, 2, null) + " in:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }
}

