/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.AnyKt;
import assertk.assertions.CharsequenceKt;
import assertk.assertions.support.SupportKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\u001a3\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u001a\"\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a(\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\n\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a3\u0010\r\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u001a\"\u0010\r\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a(\u0010\r\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010\u000e\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\u0010\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0018\u0010\u0013\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0012\u001a\u0018\u0010\u0015\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u0003\u001a\u0010\u0010\u0016\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0002*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\u001a\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001b"}, d2={"contains", "", "Lassertk/Assert;", "", "expected", "", "ignoreCase", "", "(Lassertk/Assert;[Ljava/lang/CharSequence;Z)V", "", "containsMatch", "regex", "Lkotlin/text/Regex;", "doesNotContain", "endsWith", "other", "hasLength", "length", "", "hasLineCount", "lineCount", "hasSameLengthAs", "isEmpty", "isNotEmpty", "isNullOrEmpty", "matches", "startsWith", "assertk"})
@SourceDebugExtension(value={"SMAP\ncharsequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 charsequence.kt\nassertk/assertions/CharsequenceKt\n+ 2 assert.kt\nassertk/Assert\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n54#2,8:156\n54#2,8:164\n54#2,8:172\n54#2,8:180\n54#2,8:188\n54#2,8:196\n54#2,3:204\n57#2,5:209\n54#2,3:214\n57#2,5:220\n54#2,8:225\n54#2,3:233\n57#2,5:238\n54#2,3:243\n57#2,5:249\n54#2,8:254\n54#2,8:262\n54#2,8:270\n54#2,8:278\n12271#3,2:207\n18717#3,2:236\n1726#4,3:217\n2624#4,3:246\n*S KotlinDebug\n*F\n+ 1 charsequence.kt\nassertk/assertions/CharsequenceKt\n*L\n17#1:156,8\n26#1:164,8\n35#1:172,8\n50#1:180,8\n60#1:188,8\n70#1:196,8\n79#1:204,3\n79#1:209,5\n88#1:214,3\n88#1:220,5\n97#1:225,8\n106#1:233,3\n106#1:238,5\n115#1:243,3\n115#1:249,5\n125#1:254,8\n135#1:262,8\n143#1:270,8\n151#1:278,8\n80#1:207,2\n107#1:236,2\n89#1:217,3\n116#1:246,3\n*E\n"})
public final class CharsequenceKt {
    @NotNull
    public static final Assert<Integer> length(@NotNull Assert<? extends CharSequence> $this$length) {
        Intrinsics.checkNotNullParameter($this$length, (String)"<this>");
        return AnyKt.prop($this$length, "length", (Function1)length.1.INSTANCE);
    }

    public static final void isEmpty(@NotNull Assert<? extends CharSequence> $this$isEmpty) {
        Intrinsics.checkNotNullParameter($this$isEmpty, (String)"<this>");
        Assert<? extends CharSequence> this_$iv = $this$isEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.length() == 0) {
                    return;
                }
                SupportKt.expected$default($this$isEmpty, "to be empty but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNotEmpty(@NotNull Assert<? extends CharSequence> $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter($this$isNotEmpty, (String)"<this>");
        Assert<? extends CharSequence> this_$iv = $this$isNotEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.length() > 0) {
                    return;
                }
                SupportKt.expected$default($this$isNotEmpty, "to not be empty", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNullOrEmpty(@NotNull Assert<? extends CharSequence> $this$isNullOrEmpty) {
        Intrinsics.checkNotNullParameter($this$isNullOrEmpty, (String)"<this>");
        Assert<? extends CharSequence> this_$iv = $this$isNullOrEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                CharSequence charSequence = actual;
                if (charSequence == null || charSequence.length() == 0) {
                    return;
                }
                SupportKt.expected$default($this$isNullOrEmpty, "to be null or empty but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void hasLength(@NotNull Assert<? extends CharSequence> $this$hasLength, int length2) {
        Intrinsics.checkNotNullParameter($this$hasLength, (String)"<this>");
        AnyKt.isEqualTo(CharsequenceKt.length($this$hasLength), length2);
    }

    public static final void hasSameLengthAs(@NotNull Assert<? extends CharSequence> $this$hasSameLengthAs, @NotNull CharSequence other) {
        Intrinsics.checkNotNullParameter($this$hasSameLengthAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Assert<? extends CharSequence> this_$iv = $this$hasSameLengthAs;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                int actualLength = actual.length();
                int otherLength = other.length();
                if (actualLength == otherLength) {
                    return;
                }
                SupportKt.expected$default($this$hasSameLengthAs, "to have same length as:" + SupportKt.show$default(other, null, 2, null) + " (" + otherLength + ") but was:" + SupportKt.show$default(actual, null, 2, null) + " (" + actualLength + ')', null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void hasLineCount(@NotNull Assert<? extends CharSequence> $this$hasLineCount, int lineCount) {
        Intrinsics.checkNotNullParameter($this$hasLineCount, (String)"<this>");
        Assert<? extends CharSequence> this_$iv = $this$hasLineCount;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                int actualLineCount = StringsKt.lines((CharSequence)actual).size();
                if (actualLineCount == lineCount) {
                    return;
                }
                SupportKt.expected$default($this$hasLineCount, "to have line count:" + SupportKt.show$default(lineCount, null, 2, null) + " but was:" + SupportKt.show$default(actualLineCount, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void contains(@NotNull Assert<? extends CharSequence> $this$contains, @NotNull CharSequence expected, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Assert<? extends CharSequence> this_$iv = $this$contains;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (StringsKt.contains((CharSequence)actual, (CharSequence)expected, (boolean)ignoreCase)) {
                    return;
                }
                SupportKt.expected$default($this$contains, "to contain:" + SupportKt.show$default(expected, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static /* synthetic */ void contains$default(Assert assert_, CharSequence charSequence, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        CharsequenceKt.contains((Assert<? extends CharSequence>)assert_, charSequence, bl);
    }

    public static final void contains(@NotNull Assert<? extends CharSequence> $this$contains, @NotNull CharSequence[] expected, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Assert<? extends CharSequence> this_$iv = $this$contains;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                boolean bl;
                CharSequence actual;
                block5: {
                    actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                    boolean bl2 = false;
                    CharSequence[] $this$all$iv = expected;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        CharSequence element$iv;
                        CharSequence it = element$iv = $this$all$iv[i];
                        boolean bl3 = false;
                        if (StringsKt.contains((CharSequence)actual, (CharSequence)it, (boolean)ignoreCase)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (bl) {
                    return;
                }
                SupportKt.expected$default($this$contains, "to contain:" + SupportKt.show$default(expected, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static /* synthetic */ void contains$default(Assert assert_, CharSequence[] charSequenceArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        CharsequenceKt.contains((Assert<? extends CharSequence>)assert_, charSequenceArray, bl);
    }

    public static final void contains(@NotNull Assert<? extends CharSequence> $this$contains, @NotNull Iterable<? extends CharSequence> expected, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Assert<? extends CharSequence> this_$iv = $this$contains;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                boolean bl;
                CharSequence actual;
                block7: {
                    actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                    boolean bl2 = false;
                    Iterable<? extends CharSequence> $this$all$iv = expected;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<? extends CharSequence> iterator = $this$all$iv.iterator();
                        while (iterator.hasNext()) {
                            CharSequence element$iv;
                            CharSequence it = element$iv = iterator.next();
                            boolean bl3 = false;
                            if (StringsKt.contains((CharSequence)actual, (CharSequence)it, (boolean)ignoreCase)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
                SupportKt.expected$default($this$contains, "to contain:" + SupportKt.show$default(expected, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static /* synthetic */ void contains$default(Assert assert_, Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        CharsequenceKt.contains((Assert<? extends CharSequence>)assert_, iterable, bl);
    }

    public static final void doesNotContain(@NotNull Assert<? extends CharSequence> $this$doesNotContain, @NotNull CharSequence expected, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$doesNotContain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Assert<? extends CharSequence> this_$iv = $this$doesNotContain;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!StringsKt.contains((CharSequence)actual, (CharSequence)expected, (boolean)ignoreCase)) {
                    return;
                }
                SupportKt.expected$default($this$doesNotContain, "to not contain:" + SupportKt.show$default(expected, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static /* synthetic */ void doesNotContain$default(Assert assert_, CharSequence charSequence, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        CharsequenceKt.doesNotContain((Assert<? extends CharSequence>)assert_, charSequence, bl);
    }

    public static final void doesNotContain(@NotNull Assert<? extends CharSequence> $this$doesNotContain, @NotNull CharSequence[] expected, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$doesNotContain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Assert<? extends CharSequence> this_$iv = $this$doesNotContain;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                boolean bl;
                CharSequence actual;
                block5: {
                    actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                    boolean bl2 = false;
                    CharSequence[] $this$none$iv = expected;
                    boolean $i$f$none = false;
                    int n = $this$none$iv.length;
                    for (int i = 0; i < n; ++i) {
                        CharSequence element$iv;
                        CharSequence it = element$iv = $this$none$iv[i];
                        boolean bl3 = false;
                        if (!StringsKt.contains((CharSequence)actual, (CharSequence)it, (boolean)ignoreCase)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (bl) {
                    return;
                }
                SupportKt.expected$default($this$doesNotContain, "to not contain:" + SupportKt.show$default(expected, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static /* synthetic */ void doesNotContain$default(Assert assert_, CharSequence[] charSequenceArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        CharsequenceKt.doesNotContain((Assert<? extends CharSequence>)assert_, charSequenceArray, bl);
    }

    public static final void doesNotContain(@NotNull Assert<? extends CharSequence> $this$doesNotContain, @NotNull Iterable<? extends CharSequence> expected, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$doesNotContain, (String)"<this>");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Assert<? extends CharSequence> this_$iv = $this$doesNotContain;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                boolean bl;
                CharSequence actual;
                block7: {
                    actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                    boolean bl2 = false;
                    Iterable<? extends CharSequence> $this$none$iv = expected;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<? extends CharSequence> iterator = $this$none$iv.iterator();
                        while (iterator.hasNext()) {
                            CharSequence element$iv;
                            CharSequence it = element$iv = iterator.next();
                            boolean bl3 = false;
                            if (!StringsKt.contains((CharSequence)actual, (CharSequence)it, (boolean)ignoreCase)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
                SupportKt.expected$default($this$doesNotContain, "to not contain:" + SupportKt.show$default(expected, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static /* synthetic */ void doesNotContain$default(Assert assert_, Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        CharsequenceKt.doesNotContain((Assert<? extends CharSequence>)assert_, iterable, bl);
    }

    public static final void startsWith(@NotNull Assert<? extends CharSequence> $this$startsWith, @NotNull CharSequence other, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Assert<? extends CharSequence> this_$iv = $this$startsWith;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (StringsKt.startsWith((CharSequence)actual, (CharSequence)other, (boolean)ignoreCase)) {
                    return;
                }
                SupportKt.expected$default($this$startsWith, "to start with:" + SupportKt.show$default(other, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static /* synthetic */ void startsWith$default(Assert assert_, CharSequence charSequence, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        CharsequenceKt.startsWith(assert_, charSequence, bl);
    }

    public static final void endsWith(@NotNull Assert<? extends CharSequence> $this$endsWith, @NotNull CharSequence other, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter($this$endsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Assert<? extends CharSequence> this_$iv = $this$endsWith;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (StringsKt.endsWith((CharSequence)actual, (CharSequence)other, (boolean)ignoreCase)) {
                    return;
                }
                SupportKt.expected$default($this$endsWith, "to end with:" + SupportKt.show$default(other, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static /* synthetic */ void endsWith$default(Assert assert_, CharSequence charSequence, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        CharsequenceKt.endsWith(assert_, charSequence, bl);
    }

    public static final void matches(@NotNull Assert<? extends CharSequence> $this$matches, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter($this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Assert<? extends CharSequence> this_$iv = $this$matches;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (regex.matches(actual)) {
                    return;
                }
                SupportKt.expected$default($this$matches, "to match:" + SupportKt.show$default(regex, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void containsMatch(@NotNull Assert<? extends CharSequence> $this$containsMatch, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter($this$containsMatch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Assert<? extends CharSequence> this_$iv = $this$containsMatch;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                CharSequence actual = (CharSequence)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (regex.containsMatchIn(actual)) {
                    return;
                }
                SupportKt.expected$default($this$containsMatch, "to contain match:" + SupportKt.show$default(regex, null, 2, null) + " but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }
}

