/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailingAssert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.support.SupportKt;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a)\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a)\u0010\n\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\u000b\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\f\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\r\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a)\u0010\u000e\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\u000f\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0010\u001a\u00020\u0003\u001a\u0010\u0010\u0011\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\u0012\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a&\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"bytes", "Lassertk/Assert;", "", "Ljava/nio/file/Path;", "exists", "", "options", "", "Ljava/nio/file/LinkOption;", "(Lassertk/Assert;[Ljava/nio/file/LinkOption;)V", "isDirectory", "isExecutable", "isHidden", "isReadable", "isRegularFile", "isSameFileAs", "expected", "isSymbolicLink", "isWritable", "lines", "", "", "charset", "Ljava/nio/charset/Charset;", "assertk"})
@SourceDebugExtension(value={"SMAP\npath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 path.kt\nassertk/assertions/PathKt\n+ 2 assert.kt\nassertk/Assert\n*L\n1#1,102:1\n29#2,11:103\n29#2,11:114\n54#2,8:125\n54#2,8:133\n54#2,8:141\n54#2,8:149\n54#2,8:157\n54#2,8:165\n54#2,8:173\n54#2,8:181\n54#2,8:189\n*S KotlinDebug\n*F\n+ 1 path.kt\nassertk/assertions/PathKt\n*L\n17#1:103,11\n21#1:114,11\n28#1:125,8\n39#1:133,8\n46#1:141,8\n53#1:149,8\n60#1:157,8\n67#1:165,8\n74#1:173,8\n85#1:181,8\n97#1:189,8\n*E\n"})
public final class PathKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Assert<List<String>> lines(@NotNull Assert<? extends Path> $this$lines, @NotNull Charset charset) {
        Object object;
        Intrinsics.checkNotNullParameter($this$lines, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String name$iv = $this$lines.getName();
        boolean $i$f$transform = false;
        Assert<? extends Path> assert_ = $this$lines;
        if (assert_ instanceof ValueAssert) {
            Assert<List<String>> assert_2;
            try {
                void actual;
                assert_2 = (Path)((ValueAssert)$this$lines).getValue();
                Assert<? extends Path> assert_3 = $this$lines;
                boolean bl = false;
                assert_2 = assert_3.assertThat(Files.readAllLines((Path)actual, charset), name$iv);
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
                assert_2 = $this$lines.failing(e$iv, name$iv);
            }
            object = assert_2;
        } else if (assert_ instanceof FailingAssert) {
            object = $this$lines.failing(((FailingAssert)$this$lines).getError(), name$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static /* synthetic */ Assert lines$default(Assert assert_, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return PathKt.lines(assert_, charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Assert<byte[]> bytes(@NotNull Assert<? extends Path> $this$bytes) {
        Object object;
        Intrinsics.checkNotNullParameter($this$bytes, (String)"<this>");
        String name$iv = $this$bytes.getName();
        boolean $i$f$transform = false;
        Assert<? extends Path> assert_ = $this$bytes;
        if (assert_ instanceof ValueAssert) {
            Assert<byte[]> assert_2;
            try {
                void actual;
                assert_2 = (Path)((ValueAssert)$this$bytes).getValue();
                Assert<? extends Path> assert_3 = $this$bytes;
                boolean bl = false;
                assert_2 = assert_3.assertThat(Files.readAllBytes((Path)actual), name$iv);
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
                assert_2 = $this$bytes.failing(e$iv, name$iv);
            }
            object = assert_2;
        } else if (assert_ instanceof FailingAssert) {
            object = $this$bytes.failing(((FailingAssert)$this$bytes).getError(), name$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static final void isRegularFile(@NotNull Assert<? extends Path> $this$isRegularFile, LinkOption ... options) {
        Intrinsics.checkNotNullParameter($this$isRegularFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Assert<? extends Path> this_$iv = $this$isRegularFile;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.isRegularFile(actual, Arrays.copyOf(options, options.length))) {
                    SupportKt.expected$default($this$isRegularFile, SupportKt.show$default(actual, null, 2, null) + " to be a regular file, but it is not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isDirectory(@NotNull Assert<? extends Path> $this$isDirectory, LinkOption ... options) {
        Intrinsics.checkNotNullParameter($this$isDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Assert<? extends Path> this_$iv = $this$isDirectory;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.isDirectory(actual, Arrays.copyOf(options, options.length))) {
                    SupportKt.expected$default($this$isDirectory, SupportKt.show$default(actual, null, 2, null) + " to be a directory, but it is not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isExecutable(@NotNull Assert<? extends Path> $this$isExecutable) {
        Intrinsics.checkNotNullParameter($this$isExecutable, (String)"<this>");
        Assert<? extends Path> this_$iv = $this$isExecutable;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.isExecutable(actual)) {
                    SupportKt.expected$default($this$isExecutable, SupportKt.show$default(actual, null, 2, null) + " to be an executable, but it is not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isHidden(@NotNull Assert<? extends Path> $this$isHidden) {
        Intrinsics.checkNotNullParameter($this$isHidden, (String)"<this>");
        Assert<? extends Path> this_$iv = $this$isHidden;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.isHidden(actual)) {
                    SupportKt.expected$default($this$isHidden, SupportKt.show$default(actual, null, 2, null) + " to be hidden, but it is not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isReadable(@NotNull Assert<? extends Path> $this$isReadable) {
        Intrinsics.checkNotNullParameter($this$isReadable, (String)"<this>");
        Assert<? extends Path> this_$iv = $this$isReadable;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.isReadable(actual)) {
                    SupportKt.expected$default($this$isReadable, SupportKt.show$default(actual, null, 2, null) + " to be readable, but it is not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isSymbolicLink(@NotNull Assert<? extends Path> $this$isSymbolicLink) {
        Intrinsics.checkNotNullParameter($this$isSymbolicLink, (String)"<this>");
        Assert<? extends Path> this_$iv = $this$isSymbolicLink;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.isSymbolicLink(actual)) {
                    SupportKt.expected$default($this$isSymbolicLink, SupportKt.show$default(actual, null, 2, null) + " to be a symbolic link, but it is not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isWritable(@NotNull Assert<? extends Path> $this$isWritable) {
        Intrinsics.checkNotNullParameter($this$isWritable, (String)"<this>");
        Assert<? extends Path> this_$iv = $this$isWritable;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.isWritable(actual)) {
                    SupportKt.expected$default($this$isWritable, SupportKt.show$default(actual, null, 2, null) + " to be writable, but it is not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isSameFileAs(@NotNull Assert<? extends Path> $this$isSameFileAs, @NotNull Path expected) {
        Intrinsics.checkNotNullParameter($this$isSameFileAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Assert<? extends Path> this_$iv = $this$isSameFileAs;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.isSameFile(actual, expected)) {
                    SupportKt.expected$default($this$isSameFileAs, SupportKt.show$default(actual, null, 2, null) + " to be the same file as " + SupportKt.show$default(actual, null, 2, null) + " but is not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void exists(@NotNull Assert<? extends Path> $this$exists, LinkOption ... options) {
        Intrinsics.checkNotNullParameter($this$exists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Assert<? extends Path> this_$iv = $this$exists;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Path actual = (Path)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!Files.exists(actual, Arrays.copyOf(options, options.length))) {
                    SupportKt.expected$default($this$exists, SupportKt.show$default(actual, null, 2, null) + " to exist, but it does not", null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }
}

