/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.fuzzywuzzy.diffutils;

import com.willowtreeapps.fuzzywuzzy.diffutils.DiffUtils$WhenMappings;
import com.willowtreeapps.fuzzywuzzy.diffutils.DiffUtilsKt;
import com.willowtreeapps.fuzzywuzzy.diffutils.structs.EditOp;
import com.willowtreeapps.fuzzywuzzy.diffutils.structs.EditType;
import com.willowtreeapps.fuzzywuzzy.diffutils.structs.MatchingBlock;
import com.willowtreeapps.fuzzywuzzy.diffutils.structs.OpCode;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J[\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J3\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016J3\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001bJ1\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u001eJ1\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004\u00a2\u0006\u0002\u0010\u001fJ!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\u001e\u0010#\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0007J(\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0007H\u0002\u00a8\u0006+"}, d2={"Lcom/willowtreeapps/fuzzywuzzy/diffutils/DiffUtils;", "", "()V", "editOpsFromCostMatrix", "", "Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/EditOp;", "len1", "", "c1", "", "p1", "o1", "len2", "c2", "p2", "o2", "matrix", "", "(ILjava/lang/String;IIILjava/lang/String;II[I)[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/EditOp;", "editOpsToOpCodes", "Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/OpCode;", "ops", "([Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/EditOp;II)[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/OpCode;", "getEditOps", "s1", "s2", "(ILjava/lang/String;ILjava/lang/String;)[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/EditOp;", "(Ljava/lang/String;Ljava/lang/String;)[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/EditOp;", "getMatchingBlocks", "Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/MatchingBlock;", "(II[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/EditOp;)[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/MatchingBlock;", "(II[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/OpCode;)[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/MatchingBlock;", "(Ljava/lang/String;Ljava/lang/String;)[Lcom/willowtreeapps/fuzzywuzzy/diffutils/structs/MatchingBlock;", "getRatio", "", "levEditDistance", "xcost", "memchr", "haystack", "offset", "needle", "", "num", "fuzzywuzzy-kotlin"})
public final class DiffUtils {
    public static final DiffUtils INSTANCE;

    private final EditOp[] getEditOps(String s1, String s2) {
        return this.getEditOps(s1.length(), s1, s2.length(), s2);
    }

    private final EditOp[] getEditOps(int len1, String s1, int len2, String s2) {
        int len1Copy = len1;
        int len2Copy = len2;
        int len1o = 0;
        int len2o = 0;
        int i = 0;
        int[] matrix = null;
        String c1 = s1;
        String c2 = s2;
        int p1 = 0;
        int p2 = 0;
        while (len1Copy > 0 && len2Copy > 0 && c1.charAt(p1) == c2.charAt(p2)) {
            --len1Copy;
            --len2Copy;
            ++p1;
            ++p2;
            ++len1o;
        }
        len2o = len1o;
        while (len1Copy > 0 && len2Copy > 0 && c1.charAt(p1 + len1Copy - 1) == c2.charAt(p2 + len2Copy - 1)) {
            --len1Copy;
            --len2Copy;
        }
        matrix = new int[++len2Copy * ++len1Copy];
        while (i < len2Copy) {
            matrix[i] = i;
            ++i;
        }
        for (i = 1; i < len1Copy; ++i) {
            matrix[len2Copy * i] = i;
        }
        for (i = 1; i < len1Copy; ++i) {
            int ptrPrev = (i - 1) * len2Copy;
            int ptrC = i * len2Copy;
            int ptrEnd = ptrC + len2Copy - 1;
            char char1 = c1.charAt(p1 + i - 1);
            int ptrChar2 = p2;
            int x = i;
            ++ptrC;
            while (ptrC <= ptrEnd) {
                int c3;
                if (++x > (c3 = matrix[ptrPrev++] + (char1 != c2.charAt(ptrChar2++) ? 1 : 0))) {
                    x = c3;
                }
                if (x > (c3 = matrix[ptrPrev] + 1)) {
                    x = c3;
                }
                matrix[ptrC++] = x;
            }
        }
        return this.editOpsFromCostMatrix(len1Copy, c1, p1, len1o, len2Copy, c2, p2, len2o, matrix);
    }

    private final EditOp[] editOpsFromCostMatrix(int len1, String c1, int p1, int o1, int len2, String c2, int p2, int o2, int[] matrix) {
        int i = len1 - 1;
        int j = len2 - 1;
        int pos = matrix[len1 * len2 - 1];
        int ptr = len1 * len2 - 1;
        Object[] ops = null;
        int dir = 0;
        ops = new EditOp[pos];
        while (i > 0 || j > 0) {
            EditOp eop;
            if (dir < 0 && j != 0 && matrix[ptr] == matrix[ptr - 1] + 1) {
                eop = new EditOp(null, 0, 0, 7, null);
                ops[--pos] = eop;
                eop.setType(EditType.INSERT);
                eop.setSpos(i + o1);
                eop.setDpos(--j + o2);
                --ptr;
                continue;
            }
            if (dir > 0 && i != 0 && matrix[ptr] == matrix[ptr - len2] + 1) {
                eop = new EditOp(null, 0, 0, 7, null);
                ops[--pos] = eop;
                eop.setType(EditType.DELETE);
                eop.setSpos(--i + o1);
                eop.setDpos(j + o2);
                ptr -= len2;
                continue;
            }
            if (i != 0 && j != 0 && matrix[ptr] == matrix[ptr - len2 - 1] && c1.charAt(p1 + i - 1) == c2.charAt(p2 + j - 1)) {
                --i;
                --j;
                ptr -= len2 + 1;
                dir = 0;
                continue;
            }
            if (i != 0 && j != 0 && matrix[ptr] == matrix[ptr - len2 - 1] + 1) {
                eop = new EditOp(null, 0, 0, 7, null);
                ops[--pos] = eop;
                eop.setType(EditType.REPLACE);
                eop.setSpos(--i + o1);
                eop.setDpos(--j + o2);
                ptr -= len2 + 1;
                dir = 0;
                continue;
            }
            if (dir == 0 && j != 0 && matrix[ptr] == matrix[ptr - 1] + 1) {
                eop = new EditOp(null, 0, 0, 7, null);
                ops[--pos] = eop;
                eop.setType(EditType.INSERT);
                eop.setSpos(i + o1);
                eop.setDpos(--j + o2);
                --ptr;
                dir = -1;
                continue;
            }
            if (dir == 0 && i != 0 && matrix[ptr] == matrix[ptr - len2] + 1) {
                eop = new EditOp(null, 0, 0, 7, null);
                ops[--pos] = eop;
                eop.setType(EditType.DELETE);
                eop.setSpos(--i + o1);
                eop.setDpos(j + o2);
                ptr -= len2;
                dir = 1;
                continue;
            }
            DiffUtilsKt.assert(false);
        }
        return (EditOp[])ArraysKt.requireNoNulls((Object[])ops);
    }

    @NotNull
    public final MatchingBlock[] getMatchingBlocks(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkParameterIsNotNull((Object)s1, (String)"s1");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s2");
        return this.getMatchingBlocks(s1.length(), s2.length(), this.getEditOps(s1, s2));
    }

    @NotNull
    public final MatchingBlock[] getMatchingBlocks(int len1, int len2, @NotNull OpCode[] ops) {
        Intrinsics.checkParameterIsNotNull((Object)ops, (String)"ops");
        int n = ops.length;
        int noOfMB = 0;
        int i = 0;
        int o = 0;
        i = n;
        while (i-- != 0) {
            if (ops[o].getType() == EditType.KEEP) {
                ++noOfMB;
                while (i != 0 && ops[o].getType() == EditType.KEEP) {
                    --i;
                    ++o;
                }
                if (i == 0) break;
            }
            ++o;
        }
        MatchingBlock[] matchingBlocks = new MatchingBlock[noOfMB + 1];
        int mb = 0;
        o = 0;
        matchingBlocks[mb] = new MatchingBlock();
        i = n;
        while (i != 0) {
            if (ops[o].getType() == EditType.KEEP) {
                MatchingBlock matchingBlock = matchingBlocks[mb];
                if (matchingBlock == null) {
                    Intrinsics.throwNpe();
                }
                matchingBlock.setSpos(ops[o].getSbeg());
                MatchingBlock matchingBlock2 = matchingBlocks[mb];
                if (matchingBlock2 == null) {
                    Intrinsics.throwNpe();
                }
                matchingBlock2.setDpos(ops[o].getDbeg());
                while (i != 0 && ops[o].getType() == EditType.KEEP) {
                    --i;
                    ++o;
                }
                if (i == 0) {
                    MatchingBlock matchingBlock3 = matchingBlocks[mb];
                    if (matchingBlock3 == null) {
                        Intrinsics.throwNpe();
                    }
                    MatchingBlock matchingBlock4 = matchingBlocks[mb];
                    if (matchingBlock4 == null) {
                        Intrinsics.throwNpe();
                    }
                    matchingBlock3.setLength(len1 - matchingBlock4.getSpos());
                    ++mb;
                    break;
                }
                MatchingBlock matchingBlock5 = matchingBlocks[mb];
                if (matchingBlock5 == null) {
                    Intrinsics.throwNpe();
                }
                int n2 = ops[o].getSbeg();
                MatchingBlock matchingBlock6 = matchingBlocks[mb];
                if (matchingBlock6 == null) {
                    Intrinsics.throwNpe();
                }
                matchingBlock5.setLength(n2 - matchingBlock6.getSpos());
                matchingBlocks[++mb] = new MatchingBlock();
            }
            --i;
            ++o;
        }
        DiffUtilsKt.assert(mb == noOfMB);
        MatchingBlock finalBlock = new MatchingBlock();
        finalBlock.setSpos(len1);
        finalBlock.setDpos(len2);
        finalBlock.setLength(0);
        matchingBlocks[mb] = finalBlock;
        return matchingBlocks;
    }

    private final MatchingBlock[] getMatchingBlocks(int len1, int len2, EditOp[] ops) {
        MatchingBlock mb;
        int n = ops.length;
        int numberOfMatchingBlocks = 0;
        int i = 0;
        int spos = 0;
        int dpos = 0;
        int o = 0;
        spos = dpos = 0;
        EditType type = null;
        i = n;
        while (i != 0) {
            while (ops[o].getType() == EditType.KEEP && --i != 0) {
                ++o;
            }
            if (i == 0) break;
            if (spos < ops[o].getSpos() || dpos < ops[o].getDpos()) {
                ++numberOfMatchingBlocks;
                spos = ops[o].getSpos();
                dpos = ops[o].getDpos();
            }
            if (ops[o].getType() == null) {
                Intrinsics.throwNpe();
            }
            switch (DiffUtils$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    while (--i != 0 && ops[++o].getType() == type && ++spos == ops[o].getSpos() && ++dpos == ops[o].getDpos()) {
                    }
                    break;
                }
                case 2: {
                    while (--i != 0 && ops[++o].getType() == type && ++spos == ops[o].getSpos() && dpos == ops[o].getDpos()) {
                    }
                    break;
                }
                case 3: {
                    while (--i != 0 && ops[++o].getType() == type && spos == ops[o].getSpos() && ++dpos == ops[o].getDpos()) {
                    }
                    break;
                }
            }
        }
        if (spos < len1 || dpos < len2) {
            ++numberOfMatchingBlocks;
        }
        Object[] matchingBlocks = new MatchingBlock[numberOfMatchingBlocks + 1];
        o = 0;
        spos = dpos = 0;
        int mbIndex = 0;
        i = n;
        while (i != 0) {
            while (ops[o].getType() == EditType.KEEP && --i != 0) {
                ++o;
            }
            if (i == 0) break;
            if (spos < ops[o].getSpos() || dpos < ops[o].getDpos()) {
                mb = new MatchingBlock();
                mb.setSpos(spos);
                mb.setDpos(dpos);
                mb.setLength(ops[o].getSpos() - spos);
                spos = ops[o].getSpos();
                dpos = ops[o].getDpos();
                matchingBlocks[mbIndex++] = mb;
            }
            if (ops[o].getType() == null) {
                Intrinsics.throwNpe();
            }
            switch (DiffUtils$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    while (--i != 0 && ops[++o].getType() == type && ++spos == ops[o].getSpos() && ++dpos == ops[o].getDpos()) {
                    }
                    break;
                }
                case 2: {
                    while (--i != 0 && ops[++o].getType() == type && ++spos == ops[o].getSpos() && dpos == ops[o].getDpos()) {
                    }
                    break;
                }
                case 3: {
                    while (--i != 0 && ops[++o].getType() == type && spos == ops[o].getSpos() && ++dpos == ops[o].getDpos()) {
                    }
                    break;
                }
            }
        }
        if (spos < len1 || dpos < len2) {
            DiffUtilsKt.assert(len1 - spos == len2 - dpos);
            mb = new MatchingBlock();
            mb.setSpos(spos);
            mb.setDpos(dpos);
            mb.setLength(len1 - spos);
            matchingBlocks[mbIndex++] = mb;
        }
        DiffUtilsKt.assert(numberOfMatchingBlocks == mbIndex);
        MatchingBlock finalBlock = new MatchingBlock();
        finalBlock.setSpos(len1);
        finalBlock.setDpos(len2);
        finalBlock.setLength(0);
        matchingBlocks[mbIndex] = finalBlock;
        Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])matchingBlocks);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        MatchingBlock[] matchingBlockArray = thisCollection$iv.toArray(new MatchingBlock[0]);
        if (matchingBlockArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return matchingBlockArray;
    }

    private final OpCode[] editOpsToOpCodes(EditOp[] ops, int len1, int len2) {
        int n = ops.length;
        int noOfBlocks = 0;
        int i = 0;
        int spos = 0;
        int dpos = 0;
        int o = 0;
        EditType type = null;
        spos = dpos = 0;
        i = n;
        while (i != 0) {
            while (ops[o].getType() == EditType.KEEP && --i != 0) {
                ++o;
            }
            if (i == 0) break;
            if (spos < ops[o].getSpos() || dpos < ops[o].getDpos()) {
                ++noOfBlocks;
                spos = ops[o].getSpos();
                dpos = ops[o].getDpos();
            }
            ++noOfBlocks;
            if (ops[o].getType() == null) {
                Intrinsics.throwNpe();
            }
            switch (DiffUtils$WhenMappings.$EnumSwitchMapping$2[type.ordinal()]) {
                case 1: {
                    while (--i != 0 && ops[++o].getType() == type && ++spos == ops[o].getSpos() && ++dpos == ops[o].getDpos()) {
                    }
                    break;
                }
                case 2: {
                    while (--i != 0 && ops[++o].getType() == type && ++spos == ops[o].getSpos() && dpos == ops[o].getDpos()) {
                    }
                    break;
                }
                case 3: {
                    while (--i != 0 && ops[++o].getType() == type && spos == ops[o].getSpos() && ++dpos == ops[o].getDpos()) {
                    }
                    break;
                }
            }
        }
        if (spos < len1 || dpos < len2) {
            ++noOfBlocks;
        }
        OpCode[] opCodes = new OpCode[noOfBlocks];
        o = 0;
        spos = dpos = 0;
        int oIndex = 0;
        i = n;
        while (i != 0) {
            OpCode oc;
            while (ops[o].getType() == EditType.KEEP && --i != 0) {
                ++o;
            }
            if (i == 0) break;
            opCodes[oIndex] = oc = new OpCode();
            oc.setSbeg(spos);
            oc.setDbeg(dpos);
            if (spos < ops[o].getSpos() || dpos < ops[o].getDpos()) {
                OpCode oc2;
                oc.setType(EditType.KEEP);
                oc.setSend(ops[o].getSpos());
                spos = oc.getSend();
                oc.setDend(ops[o].getDpos());
                dpos = oc.getDend();
                opCodes[++oIndex] = oc2 = new OpCode();
                oc2.setSbeg(spos);
                oc2.setDbeg(dpos);
            }
            if (ops[o].getType() == null) {
                Intrinsics.throwNpe();
            }
            switch (DiffUtils$WhenMappings.$EnumSwitchMapping$3[type.ordinal()]) {
                case 1: {
                    while (--i != 0 && ops[++o].getType() == type && ++spos == ops[o].getSpos() && ++dpos == ops[o].getDpos()) {
                    }
                    break;
                }
                case 2: {
                    while (--i != 0 && ops[++o].getType() == type && ++spos == ops[o].getSpos() && dpos == ops[o].getDpos()) {
                    }
                    break;
                }
                case 3: {
                    while (--i != 0 && ops[++o].getType() == type && spos == ops[o].getSpos() && ++dpos == ops[o].getDpos()) {
                    }
                    break;
                }
            }
            OpCode opCode = opCodes[oIndex];
            if (opCode == null) {
                Intrinsics.throwNpe();
            }
            opCode.setType(type);
            OpCode opCode2 = opCodes[oIndex];
            if (opCode2 == null) {
                Intrinsics.throwNpe();
            }
            opCode2.setSend(spos);
            OpCode opCode3 = opCodes[oIndex];
            if (opCode3 == null) {
                Intrinsics.throwNpe();
            }
            opCode3.setDend(dpos);
            ++oIndex;
        }
        if (spos < len1 || dpos < len2) {
            DiffUtilsKt.assert(len1 - spos == len2 - dpos);
            if (opCodes[oIndex] == null) {
                opCodes[oIndex] = new OpCode();
            }
            OpCode opCode = opCodes[oIndex];
            if (opCode == null) {
                Intrinsics.throwNpe();
            }
            opCode.setType(EditType.KEEP);
            OpCode opCode4 = opCodes[oIndex];
            if (opCode4 == null) {
                Intrinsics.throwNpe();
            }
            opCode4.setSbeg(spos);
            OpCode opCode5 = opCodes[oIndex];
            if (opCode5 == null) {
                Intrinsics.throwNpe();
            }
            opCode5.setDbeg(dpos);
            OpCode opCode6 = opCodes[oIndex];
            if (opCode6 == null) {
                Intrinsics.throwNpe();
            }
            opCode6.setSend(len1);
            OpCode opCode7 = opCodes[oIndex];
            if (opCode7 == null) {
                Intrinsics.throwNpe();
            }
            opCode7.setDend(len2);
            ++oIndex;
        }
        DiffUtilsKt.assert(oIndex == noOfBlocks);
        return opCodes;
    }

    public final int levEditDistance(@NotNull String s1, @NotNull String s2, int xcost) {
        Intrinsics.checkParameterIsNotNull((Object)s1, (String)"s1");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s2");
        int i = 0;
        int half = 0;
        String c1 = s1;
        String c2 = s2;
        int str1 = 0;
        int str2 = 0;
        int len1 = s1.length();
        int len2 = s2.length();
        while (len1 > 0 && len2 > 0 && c1.charAt(str1) == c2.charAt(str2)) {
            --len1;
            --len2;
            ++str1;
            ++str2;
        }
        while (len1 > 0 && len2 > 0 && c1.charAt(str1 + len1 - 1) == c2.charAt(str2 + len2 - 1)) {
            --len1;
            --len2;
        }
        if (len1 == 0) {
            return len2;
        }
        if (len2 == 0) {
            return len1;
        }
        if (len1 > len2) {
            int nx = len1;
            int temp = str1;
            len1 = len2;
            len2 = nx;
            str1 = str2;
            str2 = temp;
            String t = c2;
            c2 = c1;
            c1 = t;
        }
        if (len1 == 1) {
            return xcost != 0 ? len2 + 1 - 2 * this.memchr(c2, str2, c1.charAt(str1), len2) : len2 - this.memchr(c2, str2, c1.charAt(str1), len2);
        }
        half = ++len1 >> 1;
        int[] row = new int[++len2];
        int end = len2 - 1;
        for (i = 0; i < len2 - (xcost != 0 ? 0 : half); ++i) {
            row[i] = i;
        }
        if (xcost != 0) {
            for (i = 1; i < len1; ++i) {
                int p = 1;
                char ch1 = c1.charAt(str1 + i - 1);
                int c2p = str2;
                int D = i;
                int x = i;
                while (p <= end) {
                    x = ch1 == c2.charAt(c2p++) ? --D : ++x;
                    D = row[p];
                    if (x > ++D) {
                        x = D;
                    }
                    row[p++] = x;
                }
            }
        } else {
            row[0] = len1 - half - 1;
            for (i = 1; i < len1; ++i) {
                int c3;
                int p = 0;
                char ch1 = c1.charAt(str1 + i - 1);
                int c2p = 0;
                int D = 0;
                int x = 0;
                if (i >= len1 - half) {
                    int offset = i - (len1 - half);
                    int c32 = 0;
                    c2p = str2 + offset;
                    p = offset;
                    c32 = row[p++] + (ch1 != c2.charAt(c2p++) ? 1 : 0);
                    x = row[p];
                    D = ++x;
                    if (x > c32) {
                        x = c32;
                    }
                    row[p++] = x;
                } else {
                    p = 1;
                    c2p = str2;
                    D = x = i;
                }
                if (i <= half + 1) {
                    end = len2 + i - half - 2;
                }
                while (p <= end) {
                    if (++x > (c3 = --D + (ch1 != c2.charAt(c2p++) ? 1 : 0))) {
                        x = c3;
                    }
                    D = row[p];
                    if (x > ++D) {
                        x = D;
                    }
                    row[p++] = x;
                }
                if (i > half) continue;
                if (++x > (c3 = --D + (ch1 != c2.charAt(c2p) ? 1 : 0))) {
                    x = c3;
                }
                row[p] = x;
            }
        }
        i = row[end];
        return i;
    }

    private final int memchr(String haystack, int offset, char needle, int num) {
        int numCopy = num;
        if (numCopy != 0) {
            int p = 0;
            do {
                if (haystack.charAt(offset + p) == needle) {
                    return 1;
                }
                ++p;
            } while (--numCopy != 0);
        }
        return 0;
    }

    public final double getRatio(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkParameterIsNotNull((Object)s1, (String)"s1");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s2");
        int len1 = s1.length();
        int len2 = s2.length();
        int lensum = len1 + len2;
        int editDistance = this.levEditDistance(s1, s2, 1);
        return (double)(lensum - editDistance) / (double)lensum;
    }

    private DiffUtils() {
    }

    static {
        DiffUtils diffUtils;
        INSTANCE = diffUtils = new DiffUtils();
    }
}

