/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.fuzzywuzzy.diffutils;

import com.willowtreeapps.fuzzywuzzy.ToStringFunction;
import com.willowtreeapps.fuzzywuzzy.diffutils.Applicable;
import com.willowtreeapps.fuzzywuzzy.diffutils.algorithms.Utils;
import com.willowtreeapps.fuzzywuzzy.diffutils.model.BoundExtractedResult;
import com.willowtreeapps.fuzzywuzzy.diffutils.model.ExtractedResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0005\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJD\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0012\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000fJL\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0012\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003JD\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0012\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000fJ*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/willowtreeapps/fuzzywuzzy/diffutils/Extractor;", "", "cutoff", "", "(I)V", "extractOne", "Lcom/willowtreeapps/fuzzywuzzy/diffutils/model/BoundExtractedResult;", "T", "query", "", "choices", "", "toStringFunction", "Lcom/willowtreeapps/fuzzywuzzy/ToStringFunction;", "func", "Lcom/willowtreeapps/fuzzywuzzy/diffutils/Applicable;", "Lcom/willowtreeapps/fuzzywuzzy/diffutils/model/ExtractedResult;", "extractTop", "", "limit", "extractWithoutOrder", "with", "fuzzywuzzy-kotlin"})
public final class Extractor {
    private int cutoff;

    @NotNull
    public final Extractor with(int cutoff) {
        this.cutoff = cutoff;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExtractedResult> extractWithoutOrder(@NotNull String query, @NotNull Collection<String> choices, @NotNull Applicable func) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        ArrayList<ExtractedResult> yields = new ArrayList<ExtractedResult>();
        boolean bl = false;
        for (String s : (Iterable)choices) {
            void index;
            int score = func.apply(query, s);
            if (score >= this.cutoff) {
                yields.add(new ExtractedResult(s, score, (int)index));
            }
            ++index;
        }
        return yields;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<BoundExtractedResult<T>> extractWithoutOrder(@NotNull String query, @NotNull Collection<? extends T> choices, @NotNull ToStringFunction<T> toStringFunction, @NotNull Applicable func) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        Intrinsics.checkParameterIsNotNull(toStringFunction, (String)"toStringFunction");
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        ArrayList yields = new ArrayList();
        boolean bl = false;
        for (Object t : (Iterable)choices) {
            void index;
            String s = toStringFunction.apply(t);
            int score = func.apply(query, s);
            if (score >= this.cutoff) {
                yields.add(new BoundExtractedResult(t, s, score, (int)index));
            }
            ++index;
        }
        return yields;
    }

    @NotNull
    public final ExtractedResult extractOne(@NotNull String query, @NotNull Collection<String> choices, @NotNull Applicable func) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        List<ExtractedResult> extracted = this.extractWithoutOrder(query, choices, func);
        Comparable comparable = CollectionsKt.max((Iterable)extracted);
        if (comparable == null) {
            Intrinsics.throwNpe();
        }
        return (ExtractedResult)comparable;
    }

    @NotNull
    public final <T> BoundExtractedResult<T> extractOne(@NotNull String query, @NotNull Collection<? extends T> choices, @NotNull ToStringFunction<T> toStringFunction, @NotNull Applicable func) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        Intrinsics.checkParameterIsNotNull(toStringFunction, (String)"toStringFunction");
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        List<BoundExtractedResult<? extends T>> extracted = this.extractWithoutOrder(query, choices, toStringFunction, func);
        Comparable comparable = CollectionsKt.max((Iterable)extracted);
        if (comparable == null) {
            Intrinsics.throwNpe();
        }
        return (BoundExtractedResult)comparable;
    }

    @NotNull
    public final List<ExtractedResult> extractTop(@NotNull String query, @NotNull Collection<String> choices, @NotNull Applicable func) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        List<ExtractedResult> best = this.extractWithoutOrder(query, choices, func);
        return CollectionsKt.sortedDescending((Iterable)best);
    }

    @NotNull
    public final <T> List<BoundExtractedResult<T>> extractTop(@NotNull String query, @NotNull Collection<? extends T> choices, @NotNull ToStringFunction<T> toStringFunction, @NotNull Applicable func) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        Intrinsics.checkParameterIsNotNull(toStringFunction, (String)"toStringFunction");
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        List<BoundExtractedResult<? extends T>> best = this.extractWithoutOrder(query, choices, toStringFunction, func);
        return CollectionsKt.sortedDescending((Iterable)best);
    }

    @NotNull
    public final List<ExtractedResult> extractTop(@NotNull String query, @NotNull Collection<String> choices, @NotNull Applicable func, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        List<ExtractedResult> best = this.extractWithoutOrder(query, choices, func);
        List<ExtractedResult> results = Utils.INSTANCE.findTopKHeap(best, limit);
        return CollectionsKt.sortedDescending((Iterable)results);
    }

    @NotNull
    public final <T> List<BoundExtractedResult<T>> extractTop(@NotNull String query, @NotNull Collection<? extends T> choices, @NotNull ToStringFunction<T> toStringFunction, @NotNull Applicable func, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        Intrinsics.checkParameterIsNotNull(toStringFunction, (String)"toStringFunction");
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        List<BoundExtractedResult<? extends T>> best = this.extractWithoutOrder(query, choices, toStringFunction, func);
        List<BoundExtractedResult<? extends T>> results = Utils.INSTANCE.findTopKHeap(best, limit);
        return CollectionsKt.sortedDescending((Iterable)results);
    }

    public Extractor(int cutoff) {
        this.cutoff = cutoff;
    }

    public /* synthetic */ Extractor(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public Extractor() {
        this(0, 1, null);
    }
}

