/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.fuzzywuzzy.diffutils;

import com.willowtreeapps.fuzzywuzzy.diffutils.PriorityQueueKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\t\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\"B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012 \b\u0002\u0010\u0005\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0096\u0002J\u000b\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\u000b\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001e\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0004H\u0002R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR&\u0010\u0005\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/willowtreeapps/fuzzywuzzy/diffutils/PriorityQueue;", "T", "", "size", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(ILjava/util/Comparator;)V", "arr", "", "[Ljava/lang/Object;", "<set-?>", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)V", "contains", "", "(Ljava/lang/Object;)Z", "containsAll", "elements", "isEmpty", "iterator", "", "peek", "()Ljava/lang/Object;", "poll", "resize", "sink", "n", "swim", "Companion", "fuzzywuzzy-kotlin"})
public final class PriorityQueue<T>
implements Collection<T>,
KMappedMarker {
    private int size;
    private T[] arr;
    private final Comparator<T> comparator;
    public static final Companion Companion = new Companion(null);

    public int getSize() {
        return this.size;
    }

    public final void add(T element) {
        if (this.size() + 1 == this.arr.length) {
            this.resize();
        }
        PriorityQueue priorityQueue = this;
        priorityQueue.size = priorityQueue.size() + 1;
        this.arr[priorityQueue.size()] = element;
        this.swim(this.size());
    }

    public final T peek() {
        if (this.size() == 0) {
            throw (Throwable)new NoSuchElementException();
        }
        T t = this.arr[1];
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    public final T poll() {
        if (this.size() == 0) {
            throw (Throwable)new NoSuchElementException();
        }
        T res = this.peek();
        int n = this.size();
        this.size = n + -1;
        PriorityQueueKt.swap(this.arr, 1, n);
        this.sink(1);
        this.arr[this.size() + 1] = null;
        if (this.size() > 0 && this.size() == (this.arr.length - 1) / 4) {
            this.resize();
        }
        return res;
    }

    private final void swim(int n) {
        Companion.swim(this.arr, n, this.comparator);
    }

    private final void sink(int n) {
        Companion.sink(this.arr, n, this.size(), this.comparator);
    }

    private final void resize() {
        T[] old;
        T[] TArray = old = this.arr;
        int n = old.length + 1;
        PriorityQueue priorityQueue = this;
        boolean bl = false;
        T[] TArray2 = Arrays.copyOf(TArray, n);
        Intrinsics.checkExpressionValueIsNotNull(TArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        T[] TArray3 = TArray2;
        priorityQueue.arr = TArray3;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object element) {
        for (T obj : this) {
            if (!Intrinsics.areEqual(obj, (Object)element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        for (Object object : elements) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<T> iterator() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = this.arr;
        int n = 1;
        int n2 = this.size() + 1;
        boolean bl = false;
        Object[] $this$map$iv = ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2);
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var6_8 = $this$mapTo$iv$iv;
        int n3 = ((void)var6_8).length;
        for (int i = 0; i < n3; ++i) {
            void var13_15;
            void it;
            void item$iv$iv;
            void var10_12 = item$iv$iv = var6_8[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (it == null) {
                Intrinsics.throwNpe();
            }
            collection.add(var13_15);
        }
        return ((List)destination$iv$iv).iterator();
    }

    public PriorityQueue(int size, @Nullable Comparator<T> comparator) {
        Comparable[] comparableArray;
        this.comparator = comparator;
        PriorityQueue priorityQueue = this;
        Comparable[] comparableArray2 = new Comparable[size];
        int n = 0;
        while (n < size) {
            int n2 = n;
            int n3 = n++;
            comparableArray = comparableArray2;
            boolean bl = false;
            Object var10_10 = null;
            comparableArray[n3] = var10_10;
        }
        comparableArray = comparableArray2;
        priorityQueue.arr = comparableArray;
    }

    public /* synthetic */ PriorityQueue(int n, Comparator comparator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            comparator = null;
        }
        this(n, comparator);
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JO\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u001c\b\u0002\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\fj\n\u0012\u0004\u0012\u0002H\u0005\u0018\u0001`\rH\u0002\u00a2\u0006\u0002\u0010\u000eJM\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u001c\b\u0002\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\fj\n\u0012\u0004\u0012\u0002H\u0005\u0018\u0001`\r\u00a2\u0006\u0002\u0010\u0013JK\u0010\u0014\u001a\u00020\u0010\"\u0004\b\u0001\u0010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\u00072\u0006\u0010\u0012\u001a\u00020\t2 \b\u0002\u0010\u000b\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u0001H\u0005\u0018\u00010\fj\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0005\u0018\u0001`\r\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/willowtreeapps/fuzzywuzzy/diffutils/PriorityQueue$Companion;", "", "()V", "greater", "", "T", "arr", "", "i", "", "j", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "([Ljava/lang/Object;IILjava/util/Comparator;)Z", "sink", "", "a", "size", "([Ljava/lang/Object;IILjava/util/Comparator;)V", "swim", "([Ljava/lang/Object;ILjava/util/Comparator;)V", "fuzzywuzzy-kotlin"})
    public static final class Companion {
        private final <T> boolean greater(T[] arr, int i, int j, Comparator<T> comparator) {
            boolean bl;
            if (comparator != null) {
                bl = comparator.compare(arr[i], arr[j]) > 0;
            } else {
                T t = arr[i];
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Comparable<T>");
                }
                Comparable left = (Comparable)t;
                T t2 = arr[j];
                if (t2 == null) {
                    Intrinsics.throwNpe();
                }
                bl = left.compareTo(t2) > 0;
            }
            return bl;
        }

        static /* synthetic */ boolean greater$default(Companion companion, Object[] objectArray, int n, int n2, Comparator comparator, int n3, Object object) {
            if ((n3 & 8) != 0) {
                comparator = null;
            }
            return companion.greater(objectArray, n, n2, comparator);
        }

        public final <T> void sink(@NotNull T[] arr, int a, int size, @Nullable Comparator<T> comparator) {
            Intrinsics.checkParameterIsNotNull(arr, (String)"arr");
            int k = a;
            while (2 * k <= size) {
                int j = 2 * k;
                if (j < size && this.greater(arr, j, j + 1, comparator)) {
                    ++j;
                }
                if (!this.greater(arr, k, j, comparator)) break;
                PriorityQueueKt.swap(arr, k, j);
                k = j;
            }
        }

        public static /* synthetic */ void sink$default(Companion companion, Object[] objectArray, int n, int n2, Comparator comparator, int n3, Object object) {
            if ((n3 & 8) != 0) {
                comparator = null;
            }
            companion.sink(objectArray, n, n2, comparator);
        }

        public final <T> void swim(@NotNull T[] arr, int size, @Nullable Comparator<T> comparator) {
            Intrinsics.checkParameterIsNotNull(arr, (String)"arr");
            for (int n = size; n > 1 && this.greater(arr, n / 2, n, comparator); n /= 2) {
                PriorityQueueKt.swap(arr, n, n / 2);
            }
        }

        public static /* synthetic */ void swim$default(Companion companion, Object[] objectArray, int n, Comparator comparator, int n2, Object object) {
            if ((n2 & 4) != 0) {
                comparator = null;
            }
            companion.swim(objectArray, n, comparator);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

