/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.fuzzywuzzy.diffutils.algorithms;

import com.willowtreeapps.fuzzywuzzy.ToStringFunction;
import com.willowtreeapps.fuzzywuzzy.diffutils.FuzzySearch;
import com.willowtreeapps.fuzzywuzzy.diffutils.algorithms.BasicAlgorithm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willowtreeapps/fuzzywuzzy/diffutils/algorithms/WeightedRatio;", "Lcom/willowtreeapps/fuzzywuzzy/diffutils/algorithms/BasicAlgorithm;", "()V", "apply", "", "s1", "", "s2", "stringProcessor", "Lcom/willowtreeapps/fuzzywuzzy/ToStringFunction;", "Companion", "fuzzywuzzy-kotlin"})
public final class WeightedRatio
extends BasicAlgorithm {
    public static final double UNBASE_SCALE = 0.95;
    public static final double PARTIAL_SCALE = 0.9;
    public static final boolean TRY_PARTIALS = true;
    public static final Companion Companion = new Companion(null);

    @Override
    public int apply(@NotNull String s1, @NotNull String s2, @NotNull ToStringFunction<String> stringProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)s1, (String)"s1");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s2");
        Intrinsics.checkParameterIsNotNull(stringProcessor, (String)"stringProcessor");
        String s1Copy = s1;
        String s2Copy = s2;
        s1Copy = stringProcessor.apply(s1Copy);
        s2Copy = stringProcessor.apply(s2Copy);
        int len1 = s1Copy.length();
        int len2 = s2Copy.length();
        if (len1 == 0 || len2 == 0) {
            return 0;
        }
        boolean tryPartials = true;
        double unbaseScale = 0.95;
        double partialScale = 0.9;
        int base = FuzzySearch.INSTANCE.ratio(s1Copy, s2Copy);
        boolean bl = false;
        double d = Math.max(len1, len2);
        bl = false;
        int n = Math.min(len1, len2);
        double lenRatio = d / (double)n;
        if (lenRatio < 1.5) {
            tryPartials = false;
        }
        if (lenRatio > (double)8) {
            partialScale = 0.6;
        }
        if (tryPartials) {
            double partial = (double)FuzzySearch.INSTANCE.partialRatio(s1Copy, s2Copy) * partialScale;
            double partialSor = (double)FuzzySearch.INSTANCE.tokenSortPartialRatio(s1Copy, s2Copy) * unbaseScale * partialScale;
            double partialSet = (double)FuzzySearch.INSTANCE.tokenSetPartialRatio(s1Copy, s2Copy) * unbaseScale * partialScale;
            double d2 = base;
            boolean bl2 = false;
            d2 = Math.max(d2, partial);
            bl2 = false;
            d2 = Math.max(d2, partialSor);
            bl2 = false;
            d2 = Math.max(d2, partialSet);
            bl2 = false;
            return (int)Math.rint(d2);
        }
        double tokenSort = (double)FuzzySearch.INSTANCE.tokenSortRatio(s1Copy, s2Copy) * unbaseScale;
        double tokenSet = (double)FuzzySearch.INSTANCE.tokenSetRatio(s1Copy, s2Copy) * unbaseScale;
        double d3 = base;
        boolean bl3 = false;
        d3 = Math.max(d3, tokenSort);
        bl3 = false;
        d3 = Math.max(d3, tokenSet);
        bl3 = false;
        return (int)Math.rint(d3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/willowtreeapps/fuzzywuzzy/diffutils/algorithms/WeightedRatio$Companion;", "", "()V", "PARTIAL_SCALE", "", "TRY_PARTIALS", "", "UNBASE_SCALE", "fuzzywuzzy-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

