/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.fuzzywuzzy.diffutils.ratio;

import com.willowtreeapps.fuzzywuzzy.Ratio;
import com.willowtreeapps.fuzzywuzzy.ToStringFunction;
import com.willowtreeapps.fuzzywuzzy.diffutils.DiffUtils;
import com.willowtreeapps.fuzzywuzzy.diffutils.structs.MatchingBlock;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/willowtreeapps/fuzzywuzzy/diffutils/ratio/PartialRatio;", "Lcom/willowtreeapps/fuzzywuzzy/Ratio;", "()V", "apply", "", "s1", "", "s2", "sp", "Lcom/willowtreeapps/fuzzywuzzy/ToStringFunction;", "fuzzywuzzy-kotlin"})
public final class PartialRatio
implements Ratio {
    @Override
    public int apply(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkParameterIsNotNull((Object)s1, (String)"s1");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s2");
        String shorter = null;
        String longer = null;
        if (s1.length() < s2.length()) {
            shorter = s1;
            longer = s2;
        } else {
            shorter = s2;
            longer = s1;
        }
        MatchingBlock[] matchingBlocks = DiffUtils.INSTANCE.getMatchingBlocks(shorter, longer);
        ArrayList<Double> scores = new ArrayList<Double>();
        for (MatchingBlock mb : matchingBlocks) {
            String longSubstr;
            int dist = mb.getDpos() - mb.getSpos();
            int longStart = dist > 0 ? dist : 0;
            int longEnd = longStart + shorter.length();
            if (longEnd > longer.length()) {
                longEnd = longer.length();
            }
            String string = longer;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(longStart, longEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            double ratio = DiffUtils.INSTANCE.getRatio(shorter, longSubstr);
            if (ratio > 0.995) {
                return 100;
            }
            scores.add(ratio);
        }
        double d = 100;
        Double d2 = CollectionsKt.max((Iterable)scores);
        if (d2 == null) {
            Intrinsics.throwNpe();
        }
        double d3 = d * d2;
        boolean bl = false;
        return (int)Math.rint(d3);
    }

    @Override
    public int apply(@NotNull String s1, @NotNull String s2, @NotNull ToStringFunction<String> sp) {
        Intrinsics.checkParameterIsNotNull((Object)s1, (String)"s1");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s2");
        Intrinsics.checkParameterIsNotNull(sp, (String)"sp");
        return this.apply(sp.apply(s1), sp.apply(s2));
    }
}

