/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.willowtreeapps.hyperion.attr.AttributeOverlayView;
import com.willowtreeapps.hyperion.attr.R;
import com.willowtreeapps.hyperion.plugin.v1.HyperionMenu;
import com.willowtreeapps.hyperion.plugin.v1.MenuState;
import com.willowtreeapps.hyperion.plugin.v1.OnMenuStateChangedListener;
import com.willowtreeapps.hyperion.plugin.v1.OnOverlayViewChangedListener;
import com.willowtreeapps.hyperion.plugin.v1.OverlayContainer;
import com.willowtreeapps.hyperion.plugin.v1.PluginExtension;
import com.willowtreeapps.hyperion.plugin.v1.PluginModule;

class AttributeInspectorModule
extends PluginModule
implements View.OnClickListener,
OnOverlayViewChangedListener,
OnMenuStateChangedListener {
    private static final String OVERLAY_TAG = "attribute_inspector_overlay";
    private OverlayContainer overlay;
    private HyperionMenu menu;
    private View view;

    AttributeInspectorModule() {
    }

    protected void onCreate() {
        PluginExtension extension = this.getExtension();
        this.overlay = extension.getOverlayContainer();
        this.menu = extension.getHyperionMenu();
        this.overlay.addOnOverlayViewChangedListener((OnOverlayViewChangedListener)this);
        this.menu.addOnMenuStateChangedListener((OnMenuStateChangedListener)this);
    }

    @Nullable
    public View createPluginView(@NonNull LayoutInflater layoutInflater, @NonNull ViewGroup parent) {
        View view = layoutInflater.inflate(R.layout.ha_item_plugin, parent, false);
        view.setOnClickListener((View.OnClickListener)this);
        View overlayView = this.overlay.getOverlayView();
        view.setSelected(overlayView != null && OVERLAY_TAG.equals(overlayView.getTag()));
        this.view = view;
        return view;
    }

    protected void onDestroy() {
        this.overlay.removeOnOverlayViewChangedListener((OnOverlayViewChangedListener)this);
        this.menu.removeOnMenuStateChangedListener((OnMenuStateChangedListener)this);
    }

    public void onClick(View v) {
        View currentOverlay = this.overlay.getOverlayView();
        if (currentOverlay == null || !OVERLAY_TAG.equals(currentOverlay.getTag())) {
            AttributeOverlayView newOverlay = new AttributeOverlayView(this.getContext());
            newOverlay.setTag(OVERLAY_TAG);
            this.overlay.setOverlayView((View)newOverlay);
        } else {
            this.overlay.removeOverlayView();
        }
    }

    public void onOverlayViewChanged(@Nullable View view) {
        this.view.setSelected(view != null && OVERLAY_TAG.equals(view.getTag()));
    }

    public void onMenuStateChanged(@NonNull MenuState menuState) {
        View currentOverlay;
        if (menuState == MenuState.OPENING && (currentOverlay = this.overlay.getOverlayView()) != null && OVERLAY_TAG.equals(currentOverlay.getTag())) {
            AttributeOverlayView attributeOverlayView = (AttributeOverlayView)currentOverlay;
            attributeOverlayView.dismissPopupIfNeeded();
        }
    }
}

