/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr;

import android.view.View;
import com.willowtreeapps.hyperion.attr.AttributeCollectors;
import com.willowtreeapps.hyperion.attr.Section;
import com.willowtreeapps.hyperion.attr.ViewAttribute;
import com.willowtreeapps.hyperion.attr.collectors.TypedAttributeCollector;
import com.willowtreeapps.hyperion.plugin.v1.AttributeTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

class AttributeLoader {
    private final AttributeTranslator attributeTranslator;
    private final List<TypedAttributeCollector> typedCollectors;

    @Inject
    AttributeLoader(AttributeTranslator attributeTranslator) {
        this.attributeTranslator = attributeTranslator;
        this.typedCollectors = AttributeCollectors.get();
    }

    List<Section<ViewAttribute>> getAttributesForView(View view) {
        ArrayList<Section<ViewAttribute>> sections = new ArrayList<Section<ViewAttribute>>(12);
        for (TypedAttributeCollector aggregator : this.typedCollectors) {
            if (!aggregator.acceptsType(view.getClass())) continue;
            List<ViewAttribute> attributes = aggregator.collect(view, this.attributeTranslator);
            Section<ViewAttribute> section = new Section<ViewAttribute>(aggregator.getType(), attributes);
            sections.add(section);
        }
        Collections.sort(sections);
        return sections;
    }
}

