/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.PopupWindowCompat;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import com.willowtreeapps.hyperion.attr.AttributeDetailView;
import com.willowtreeapps.hyperion.attr.R;
import com.willowtreeapps.hyperion.plugin.v1.ExtensionProvider;
import com.willowtreeapps.hyperion.plugin.v1.MeasurementHelper;
import com.willowtreeapps.hyperion.plugin.v1.PluginExtension;

class AttributeOverlayView
extends FrameLayout {
    private final ViewGroup contentRoot;
    private final MeasurementHelper measurementHelper;
    private final Rect outRect = new Rect();
    private final Paint selectionPaint;
    private View currentView;
    private PopupWindow currentDetailWindow;

    AttributeOverlayView(Context context) {
        super(context);
        PluginExtension extension = ExtensionProvider.get((Context)context);
        this.contentRoot = extension.getContentRoot();
        this.measurementHelper = extension.getMeasurementHelper();
        this.selectionPaint = new Paint(1);
        this.selectionPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.ha_selection));
        this.selectionPaint.setStyle(Paint.Style.FILL);
        this.setWillNotDraw(false);
        this.setClickable(false);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismissPopupIfNeeded();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawRect(this.outRect, this.selectionPaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            return true;
        }
        if (event.getAction() == 1) {
            float y;
            float x = event.getX();
            View touchTarget = this.findTarget((View)this.contentRoot, x, y = event.getY());
            View newTarget = this.currentView == touchTarget ? (View)touchTarget.getParent() : touchTarget;
            this.setTarget(newTarget);
            this.invalidate();
            return true;
        }
        return super.onTouchEvent(event);
    }

    private View findTarget(View root, float x, float y) {
        View bestTarget = root;
        if (root instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)root;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                View target;
                View child = parent.getChildAt(i);
                this.measurementHelper.getScreenLocation(child, this.outRect);
                if (child.getVisibility() != 0 || !(x >= (float)this.outRect.left) || !(x <= (float)this.outRect.right) || !(y >= (float)this.outRect.top) || !(y <= (float)this.outRect.bottom) || (target = this.findTarget(child, x, y)).getWidth() > bestTarget.getWidth() || target.getHeight() > bestTarget.getHeight()) continue;
                bestTarget = target;
            }
        }
        return bestTarget;
    }

    private void setTarget(View view) {
        this.currentView = view;
        this.measurementHelper.getScreenLocation(view, this.outRect);
        this.dismissPopupIfNeeded();
        this.currentDetailWindow = this.createDetailWindowForView(view);
        PopupWindowCompat.showAsDropDown((PopupWindow)this.currentDetailWindow, (View)view, (int)0, (int)24, (int)1);
    }

    private PopupWindow createDetailWindowForView(View view) {
        Context context = this.getContext();
        int width = (int)((float)this.getMeasuredWidth() * 0.8f);
        int height = this.getMeasuredHeight() / 2;
        AttributeDetailView detailView = new AttributeDetailView(context);
        detailView.setTarget(view);
        PopupWindow popupWindow = new PopupWindow((View)detailView, width, height);
        popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(ContextCompat.getColor((Context)context, (int)R.color.ha_popup_background)));
        popupWindow.setOutsideTouchable(true);
        popupWindow.setFocusable(true);
        return popupWindow;
    }

    void dismissPopupIfNeeded() {
        if (this.currentDetailWindow != null && this.currentDetailWindow.isShowing()) {
            this.currentDetailWindow.dismiss();
        }
    }
}

