/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr.collectors;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.MenuItemCompat;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.willowtreeapps.hyperion.attr.ViewAttribute;
import com.willowtreeapps.hyperion.attr.collectors.ColorValue;
import com.willowtreeapps.hyperion.attr.collectors.PorterDuffModeValue;
import com.willowtreeapps.hyperion.attr.collectors.ResourceValue;
import java.util.ArrayList;
import java.util.Collection;

public final class Collectors {
    public static ViewAttribute<ColorValue> createColorAttribute(@NonNull String name, @Nullable ColorStateList color2) {
        return Collectors.createColorAttribute(null, name, color2);
    }

    public static ViewAttribute<ColorValue> createColorAttribute(@Nullable View view, @NonNull String name, @Nullable ColorStateList color2) {
        int tintColorInt;
        if (color2 == null) {
            tintColorInt = 0;
        } else {
            int[] state = view == null ? new int[]{} : view.getDrawableState();
            tintColorInt = color2.getColorForState(state, color2.getDefaultColor());
        }
        return new ViewAttribute<ColorValue>(name, new ColorValue(tintColorInt), (Drawable)new ColorDrawable(tintColorInt));
    }

    public static Collection<ViewAttribute> createMenuAttributes(@NonNull Context context, @NonNull Menu menu) {
        Resources res = context.getResources();
        ArrayList<ViewAttribute> attributes = new ArrayList<ViewAttribute>();
        attributes.add(new ViewAttribute<Integer>("MenuSize", menu.size()));
        attributes.add(new ViewAttribute<Boolean>("MenuHasVisibleItems", menu.hasVisibleItems()));
        for (int i = 0; i < menu.size(); ++i) {
            MenuItem item = menu.getItem(i);
            String prefix = "Item " + i + ": ";
            attributes.add(new ViewAttribute<CharSequence>(prefix + "Title", item.getTitle()));
            attributes.add(new ViewAttribute<CharSequence>(prefix + "ContentDescription", MenuItemCompat.getContentDescription((MenuItem)item)));
            attributes.add(new ViewAttribute<CharSequence>(prefix + "TooltipText", MenuItemCompat.getTooltipText((MenuItem)item)));
            attributes.add(new ViewAttribute<Boolean>(prefix + "Checkable", item.isCheckable()));
            attributes.add(new ViewAttribute<Boolean>(prefix + "Checked", item.isChecked()));
            attributes.add(new ViewAttribute<Boolean>(prefix + "Enabled", item.isEnabled()));
            attributes.add(new ViewAttribute<Boolean>(prefix + "Visible", item.isVisible()));
            attributes.add(new ViewAttribute<Integer>(prefix + "Order", item.getOrder()));
            attributes.add(new ViewAttribute(prefix + "Icon", item.getIcon()));
            attributes.add(Collectors.createColorAttribute("IconTint", MenuItemCompat.getIconTintList((MenuItem)item)));
            attributes.add(new ViewAttribute<PorterDuffModeValue>("IconTintMode", new PorterDuffModeValue(MenuItemCompat.getIconTintMode((MenuItem)item))));
            attributes.add(new ViewAttribute<ResourceValue>(prefix + "Id", new ResourceValue(res, item.getItemId())));
            attributes.add(new ViewAttribute<ResourceValue>(prefix + "GroupId", new ResourceValue(res, item.getGroupId())));
        }
        return attributes;
    }

    private Collectors() {
        throw new AssertionError((Object)"No instances");
    }
}

