/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr.collectors;

import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.view.ViewCompat;
import android.view.View;
import com.willowtreeapps.hyperion.attr.MutableBooleanViewAttribute;
import com.willowtreeapps.hyperion.attr.MutableStringViewAttribute;
import com.willowtreeapps.hyperion.attr.ViewAttribute;
import com.willowtreeapps.hyperion.attr.collectors.Collectors;
import com.willowtreeapps.hyperion.attr.collectors.GravityValue;
import com.willowtreeapps.hyperion.attr.collectors.PorterDuffModeValue;
import com.willowtreeapps.hyperion.attr.collectors.ResourceValue;
import com.willowtreeapps.hyperion.attr.collectors.TypedAttributeCollector;
import com.willowtreeapps.hyperion.plugin.v1.AttributeTranslator;
import java.util.ArrayList;
import java.util.List;

public class ViewAttributeCollector
extends TypedAttributeCollector<View> {
    public ViewAttributeCollector() {
        super(View.class);
    }

    @Override
    @NonNull
    public List<ViewAttribute> collect(final View view, AttributeTranslator attributeTranslator) {
        ArrayList<ViewAttribute> attributes = new ArrayList<ViewAttribute>();
        Rect rect = new Rect();
        attributes.add(new ViewAttribute<ResourceValue>("Id", new ResourceValue(view.getResources(), view.getId())));
        String value = attributeTranslator.translatePx(view.getHeight());
        attributes.add(new ViewAttribute<String>("Height", value));
        value = attributeTranslator.translatePx(view.getWidth());
        attributes.add(new ViewAttribute<String>("Width", value));
        attributes.add(new ViewAttribute<Integer>("Baseline", view.getBaseline()));
        view.getGlobalVisibleRect(rect);
        attributes.add(new ViewAttribute<String>("GlobalLeft", String.valueOf(rect.left)));
        attributes.add(new ViewAttribute<String>("GlobalTop", String.valueOf(rect.top)));
        attributes.add(new ViewAttribute<String>("GlobalRight", String.valueOf(rect.right)));
        attributes.add(new ViewAttribute<String>("GlobalBottom", String.valueOf(rect.bottom)));
        view.getLocalVisibleRect(rect);
        attributes.add(new ViewAttribute<String>("LocalLeft", String.valueOf(rect.left)));
        attributes.add(new ViewAttribute<String>("LocalTop", String.valueOf(rect.top)));
        attributes.add(new ViewAttribute<String>("LocalRight", String.valueOf(rect.right)));
        attributes.add(new ViewAttribute<String>("LocalBottom", String.valueOf(rect.bottom)));
        if (Build.VERSION.SDK_INT >= 18) {
            attributes.add(new ViewAttribute<Boolean>("InLayout", view.isInLayout()));
        }
        attributes.add(new MutableBooleanViewAttribute("Clickable", view.isClickable()){

            @Override
            protected void mutate(Boolean value) {
                view.setClickable(value.booleanValue());
            }
        });
        attributes.add(new MutableBooleanViewAttribute("LongClickable", view.isLongClickable()){

            @Override
            protected void mutate(Boolean value) {
                view.setLongClickable(value.booleanValue());
            }
        });
        if (Build.VERSION.SDK_INT >= 23) {
            attributes.add(new ViewAttribute<Boolean>("ContextClickable", view.isContextClickable()));
        }
        attributes.add(new MutableBooleanViewAttribute("Enabled", view.isEnabled()){

            @Override
            protected void mutate(Boolean value) {
                view.setEnabled(value.booleanValue());
            }
        });
        attributes.add(new MutableBooleanViewAttribute("Activated", view.isActivated()){

            @Override
            protected void mutate(Boolean value) {
                view.setActivated(value.booleanValue());
            }
        });
        attributes.add(new MutableBooleanViewAttribute("Selected", view.isSelected()){

            @Override
            protected void mutate(Boolean value) {
                view.setSelected(value.booleanValue());
            }
        });
        attributes.add(new ViewAttribute<Boolean>("AttachedToWindow", ViewCompat.isAttachedToWindow((View)view)));
        attributes.add(new ViewAttribute<Boolean>("Dirty", view.isDirty()));
        attributes.add(new MutableBooleanViewAttribute("IsFocusable", view.isFocusable()){

            @Override
            protected void mutate(Boolean value) {
                view.setFocusable(value.booleanValue());
            }
        });
        attributes.add(new MutableBooleanViewAttribute("IsFocusableInTouchMode", view.isFocusableInTouchMode()){

            @Override
            protected void mutate(Boolean value) {
                view.setFocusableInTouchMode(value.booleanValue());
            }
        });
        attributes.add(new ViewAttribute<Boolean>("HasFocus", view.hasFocus()));
        attributes.add(new ViewAttribute<Boolean>("HasFocusable", view.hasFocusable()));
        if (Build.VERSION.SDK_INT >= 16) {
            attributes.add(new ViewAttribute<Boolean>("HasTransientState", view.hasTransientState()));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            attributes.add(new ViewAttribute<GravityValue>("ForegroundGravity", new GravityValue(view.getForegroundGravity())));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            attributes.add(new MutableStringViewAttribute("TransitionName", view.getTransitionName()){

                @Override
                @RequiresApi(api=21)
                protected void mutate(CharSequence value) {
                    view.setTransitionName(value.toString());
                }
            });
            attributes.add(new ViewAttribute<Float>("Elevation", Float.valueOf(view.getElevation())));
        }
        attributes.add(new ViewAttribute<PorterDuffModeValue>("BackgroundTintMode", new PorterDuffModeValue(ViewCompat.getBackgroundTintMode((View)view))));
        attributes.add(Collectors.createColorAttribute(view, "BackgroundTint", ViewCompat.getBackgroundTintList((View)view)));
        if (Build.VERSION.SDK_INT >= 23) {
            attributes.add(new ViewAttribute<CharSequence>("AccessibilityClassName", view.getAccessibilityClassName()));
        }
        return attributes;
    }
}

