/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.buildconfig.list;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import com.willowtreeapps.hyperion.buildconfig.R;
import com.willowtreeapps.hyperion.buildconfig.list.BuildConfigListAdapter;
import com.willowtreeapps.hyperion.buildconfig.model.BuildConfigValue;
import com.willowtreeapps.hyperion.plugin.v1.HyperionIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@HyperionIgnore
public class BuildConfigListActivity
extends AppCompatActivity {
    private static final String TAG = "BuildConfig";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hbc_activity_build_config_list);
        this.setSupportActionBar((Toolbar)this.findViewById(R.id.tmb_toolbar));
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.hbc_recycler);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        recyclerView.setAdapter((RecyclerView.Adapter)new BuildConfigListAdapter(this.getBuildConfigValues()));
    }

    public boolean onSupportNavigateUp() {
        this.onBackPressed();
        return true;
    }

    private String buildConfigName() {
        String resString = this.getString(R.string.hbc_target_build_config_name);
        if (resString.isEmpty()) {
            return this.getPackageName() + ".BuildConfig";
        }
        return resString;
    }

    private List<BuildConfigValue> getBuildConfigValues() {
        LinkedList<BuildConfigValue> buildConfigValues = new LinkedList<BuildConfigValue>();
        try {
            Field[] declaredFields;
            Class<?> buildConfigClass = Class.forName(this.buildConfigName());
            Log.d((String)TAG, (String)("Checking BuildConfig " + buildConfigClass.getName()));
            for (Field declaredField : declaredFields = buildConfigClass.getDeclaredFields()) {
                Log.d((String)TAG, (String)("Inspecting " + declaredField.toString()));
                if (!Modifier.isStatic(declaredField.getModifiers())) continue;
                try {
                    if (!declaredField.isAccessible()) {
                        declaredField.setAccessible(true);
                    }
                    Class<?> fieldType = declaredField.getType();
                    String name = declaredField.getName() + " (" + fieldType.getSimpleName() + ")";
                    String value = this.objectToString(declaredField.get(null));
                    buildConfigValues.add(new BuildConfigValue(name, value));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Failed to process field from config.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to read BuildConfig", (Throwable)e);
        }
        return buildConfigValues;
    }

    private String objectToString(Object obj) {
        if (obj.getClass().isArray()) {
            if (obj instanceof boolean[]) {
                return Arrays.toString((boolean[])obj);
            }
            if (obj instanceof byte[]) {
                return Arrays.toString((byte[])obj);
            }
            if (obj instanceof int[]) {
                return Arrays.toString((int[])obj);
            }
            if (obj instanceof short[]) {
                return Arrays.toString((short[])obj);
            }
            if (obj instanceof long[]) {
                return Arrays.toString((long[])obj);
            }
            if (obj instanceof float[]) {
                return Arrays.toString((float[])obj);
            }
            if (obj instanceof double[]) {
                return Arrays.toString((double[])obj);
            }
            if (obj instanceof char[]) {
                return Arrays.toString((char[])obj);
            }
            return Arrays.toString((Object[])obj);
        }
        return obj.toString();
    }
}

