/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.disk;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ThumbnailUtils;
import android.os.Parcelable;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.PopupMenu;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.willowtreeapps.hyperion.disk.FileItem;
import com.willowtreeapps.hyperion.disk.Files;
import com.willowtreeapps.hyperion.disk.R;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileExplorerView
extends FrameLayout
implements Files.Listener {
    private Files files;
    private RecyclerView recycler;
    private Adapter adapter;

    public FileExplorerView(@NonNull Context context) {
        this(context, null);
    }

    public FileExplorerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FileExplorerView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        FileExplorerView.inflate((Context)context, (int)R.layout.hd_view_file_explorer, (ViewGroup)this);
        try {
            PackageManager pm = context.getPackageManager();
            String name = context.getPackageName();
            PackageInfo info = pm.getPackageInfo(name, 0);
            String initialPath = info.applicationInfo.dataDir;
            this.files = new Files(initialPath);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            this.files = new Files(context.getFilesDir().getPath());
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        Context context = this.getContext();
        this.recycler = (RecyclerView)this.findViewById(R.id.recycler);
        this.adapter = new Adapter();
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recycler.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(context, 1));
        this.recycler.setHasFixedSize(true);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.files.addListener(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.files.removeListener(this);
    }

    @Override
    public void onFilesChanged(List<File> files) {
        this.adapter.list = this.toItems(files);
        this.adapter.notifyDataSetChanged();
    }

    private List<FileItem> toItems(List<File> files) {
        ArrayList<FileItem> ret = new ArrayList<FileItem>(files.size());
        for (File file : files) {
            ret.add(new FileItem(this.getContext(), file));
        }
        return ret;
    }

    private static class UpViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final Files files;

        private UpViewHolder(Files files, View itemView) {
            super(itemView);
            this.files = files;
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            this.files.pop();
        }
    }

    private static class FileViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final Files files;
        private final ImageView image;
        private final TextView text;
        private final TextView date;
        private final View options;
        private FileItem item;

        private FileViewHolder(Files files, final View itemView) {
            super(itemView);
            this.files = files;
            itemView.setOnClickListener((View.OnClickListener)this);
            this.image = (ImageView)itemView.findViewById(R.id.image);
            this.text = (TextView)itemView.findViewById(R.id.name);
            this.date = (TextView)itemView.findViewById(R.id.date);
            this.options = itemView.findViewById(R.id.options);
            this.options.setOnClickListener(new View.OnClickListener(){

                public void onClick(final View v) {
                    PopupMenu menu2 = new PopupMenu(itemView.getContext(), FileViewHolder.this.options);
                    menu2.inflate(R.menu.hd_file_options);
                    menu2.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

                        public boolean onMenuItemClick(MenuItem item) {
                            Context context = v.getContext();
                            int id2 = item.getItemId();
                            if (id2 == R.id.share) {
                                Intent intent = new Intent("android.intent.action.SEND");
                                intent.setType(((FileViewHolder)FileViewHolder.this).item.mimeType);
                                intent.putExtra("android.intent.extra.STREAM", (Parcelable)((FileViewHolder)FileViewHolder.this).item.uri);
                                context.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share file"));
                                return true;
                            }
                            if (id2 == R.id.delete) {
                                boolean deleted = ((FileViewHolder)FileViewHolder.this).item.file.delete();
                                if (!deleted) {
                                    Toast.makeText((Context)context, (CharSequence)"Could not delete file.", (int)1).show();
                                }
                                return true;
                            }
                            return false;
                        }
                    });
                    menu2.show();
                }
            });
        }

        private void bind(FileItem item) {
            this.item = item;
            if (item.isVideo()) {
                Bitmap thumbnail = ThumbnailUtils.createVideoThumbnail((String)item.path, (int)1);
                this.image.setImageBitmap(thumbnail);
            } else if (item.isImage()) {
                BitmapFactory.Options bmOptions = new BitmapFactory.Options();
                Bitmap bitmap = BitmapFactory.decodeFile((String)item.path, (BitmapFactory.Options)bmOptions);
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.itemView.getWidth(), (int)this.itemView.getHeight(), (boolean)true);
                this.image.setImageBitmap(bitmap);
            } else if (item.isDirectory) {
                this.image.setImageResource(R.drawable.hd_ic_folder);
            } else {
                this.image.setImageResource(R.drawable.hd_ic_file);
            }
            this.text.setText((CharSequence)item.name);
            this.date.setText((CharSequence)item.lastModified);
        }

        public void onClick(View v) {
            if (this.item.isDirectory) {
                this.files.setPath(this.item.path);
            }
        }
    }

    private class Adapter
    extends RecyclerView.Adapter {
        private List<FileItem> list;

        private Adapter() {
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            if (viewType == 1) {
                View itemView = inflater.inflate(R.layout.hd_item_up, parent, false);
                return new UpViewHolder(FileExplorerView.this.files, itemView);
            }
            View itemView = inflater.inflate(R.layout.hd_item_file, parent, false);
            return new FileViewHolder(FileExplorerView.this.files, itemView);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (holder instanceof FileViewHolder) {
                ((FileViewHolder)holder).bind(this.list.get(FileExplorerView.this.files.atRoot() ? position : position - 1));
            }
        }

        public int getItemCount() {
            int count = this.list == null ? 0 : this.list.size();
            return FileExplorerView.this.files.atRoot() ? count : ++count;
        }

        public int getItemViewType(int position) {
            if (!FileExplorerView.this.files.atRoot() && position == 0) {
                return 1;
            }
            return super.getItemViewType(position);
        }
    }
}

