/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.disk;

import android.content.Context;
import android.net.Uri;
import android.support.v4.content.FileProvider;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.util.Date;

class FileItem {
    File file;
    String path;
    String name;
    Uri uri;
    String extension;
    String mimeType;
    long size;
    boolean isDirectory;
    String lastModified;

    FileItem(Context context, File file) {
        this.file = file;
        this.path = file.getPath();
        this.name = file.getName();
        try {
            this.uri = FileProvider.getUriForFile((Context)context, (String)"com.willowtreeapps.hyperion.disk.fileprovider", (File)file);
            this.extension = MimeTypeMap.getFileExtensionFromUrl((String)this.uri.toString());
        }
        catch (Throwable e) {
            this.uri = null;
        }
        if (this.extension != null) {
            this.mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(this.extension);
        }
        if (this.mimeType == null) {
            this.mimeType = "application/octet-stream";
        }
        this.size = file.length();
        this.isDirectory = file.isDirectory();
        this.lastModified = new Date(file.lastModified()).toString();
    }

    boolean isImage() {
        return this.name.endsWith("png") || this.name.endsWith("jpg") || this.name.endsWith("jpeg");
    }

    boolean isVideo() {
        return this.name.endsWith("mp4") || this.name.endsWith("mkv");
    }
}

