/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.disk;

import android.os.FileObserver;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class Files {
    private static final Handler main = new Handler(Looper.getMainLooper());
    private final String root;
    private String path;
    private List<File> files;
    private FileObserver observer;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    Files(String root) {
        this.root = root;
        this.setPath(root);
        this.updateFiles();
    }

    boolean atRoot() {
        return this.root.equals(this.path);
    }

    void pop() {
        this.setPath(this.path.substring(0, this.path.lastIndexOf(47)));
    }

    void setPath(String path) {
        this.path = path;
        if (this.observer != null) {
            this.observer.stopWatching();
        }
        this.updateFiles();
        this.notifyFiles();
        this.observer = new FileObserver(path){

            public void onEvent(int event, String path) {
                switch (event & 0xFFF) {
                    case 2: 
                    case 256: 
                    case 512: {
                        Files.this.updateFiles();
                        Files.this.notifyFiles();
                    }
                }
            }
        };
        this.toggleObserver();
    }

    @NonNull
    List<File> getFiles() {
        return this.files;
    }

    private void updateFiles() {
        File file = new File(this.path);
        this.files = Arrays.asList(file.listFiles());
    }

    private void notifyFiles() {
        main.post(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : Files.this.listeners) {
                    listener.onFilesChanged(Files.this.files);
                }
            }
        });
    }

    void addListener(Listener listener) {
        this.listeners.add(listener);
        this.toggleObserver();
        listener.onFilesChanged(this.files);
    }

    void removeListener(Listener listener) {
        this.listeners.remove(listener);
        this.toggleObserver();
    }

    private void toggleObserver() {
        if (this.observer != null) {
            if (this.listeners.isEmpty()) {
                this.observer.stopWatching();
            } else {
                this.observer.startWatching();
            }
        }
    }

    static interface Listener {
        public void onFilesChanged(List<File> var1);
    }
}

