/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.geigercounter;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.SoundPool;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.Choreographer;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.willowtreeapps.hyperion.geigercounter.DroppedFrameDetectorObserver;
import java.util.HashSet;
import java.util.Set;

@RequiresApi(value=16)
class DroppedFrameDetector
implements Choreographer.FrameCallback {
    private final Context context;
    private final Set<DroppedFrameDetectorObserver> observers;
    private final SoundPool soundPool;
    private final int tickSoundID;
    private static final int NOT_LOADED = -1;
    private boolean isEnabled;
    private boolean areHapticsEnabled;
    private final double hardwareFrameIntervalSeconds;
    private long lastTimestampNanoseconds = -1L;
    private static final long NEVER = -1L;

    DroppedFrameDetector(Context context) {
        int tickSoundID;
        this.context = context;
        this.observers = new HashSet<DroppedFrameDetectorObserver>();
        this.soundPool = new SoundPool(1, 3, 0);
        try {
            AssetFileDescriptor tickSoundFileDescriptor = context.getAssets().openFd("sounds/GeigerCounterTick.wav");
            tickSoundID = this.soundPool.load(tickSoundFileDescriptor, 1);
        }
        catch (Exception exception) {
            Log.e((String)"Hyperion Geiger Counter", (String)exception.toString());
            tickSoundID = -1;
        }
        this.tickSoundID = tickSoundID;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        double hardwareFramesPerSecond = display.getRefreshRate();
        this.hardwareFrameIntervalSeconds = 1.0 / hardwareFramesPerSecond;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        Choreographer choreographer = Choreographer.getInstance();
        if (isEnabled) {
            choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
            choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        } else {
            choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
            this.lastTimestampNanoseconds = -1L;
        }
        for (DroppedFrameDetectorObserver observer : this.observers) {
            observer.droppedFrameDetectorIsEnabledDidChange(this, isEnabled);
        }
    }

    public boolean areHapticsEnabled() {
        return this.areHapticsEnabled;
    }

    public void setHapticsEnabled(boolean areHapticsEnabled) {
        this.areHapticsEnabled = areHapticsEnabled;
    }

    public void addObserver(DroppedFrameDetectorObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(DroppedFrameDetectorObserver observer) {
        this.observers.remove(observer);
    }

    private void playTickSound() {
        if (this.tickSoundID != -1) {
            this.soundPool.play(this.tickSoundID, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }

    private void playTickHaptics() {
        if (this.canUseVibrationEffect()) {
            this.playVibrationEffect();
        } else {
            this.playHapticFeedback();
        }
    }

    private boolean canUseVibrationEffect() {
        return 26 <= Build.VERSION.SDK_INT;
    }

    @RequiresApi(value=26)
    private void playVibrationEffect() {
        VibrationEffect effect = VibrationEffect.createOneShot((long)4L, (int)255);
        Vibrator vibrator = (Vibrator)this.context.getSystemService("vibrator");
        if (vibrator == null) {
            this.playHapticFeedback();
            return;
        }
        vibrator.vibrate(effect);
    }

    private void playHapticFeedback() {
        for (DroppedFrameDetectorObserver observer : this.observers) {
            View view = observer.getHostViewForDroppedFrameHapticFeedback();
            if (view == null) continue;
            view.performHapticFeedback(6, 2);
            break;
        }
    }

    public void doFrame(long timestampNanoseconds) {
        double frameIntervalSeconds;
        double droppedFrameIntervalSeconds;
        long frameIntervalNanoseconds = timestampNanoseconds - this.lastTimestampNanoseconds;
        if (this.lastTimestampNanoseconds != -1L && (droppedFrameIntervalSeconds = this.hardwareFrameIntervalSeconds * 1.5) < (frameIntervalSeconds = (double)frameIntervalNanoseconds / 1.0E9)) {
            this.playTickSound();
            if (this.areHapticsEnabled) {
                this.playTickHaptics();
            }
        }
        this.lastTimestampNanoseconds = timestampNanoseconds;
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }
}

