/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.geigercounter;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.PopupMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.willowtreeapps.hyperion.geigercounter.DroppedFrameDetector;
import com.willowtreeapps.hyperion.geigercounter.DroppedFrameDetectorObserver;
import com.willowtreeapps.hyperion.geigercounter.R;
import com.willowtreeapps.hyperion.plugin.v1.HyperionMenu;
import com.willowtreeapps.hyperion.plugin.v1.MenuState;
import com.willowtreeapps.hyperion.plugin.v1.OnMenuStateChangedListener;
import com.willowtreeapps.hyperion.plugin.v1.PluginModule;

@RequiresApi(value=16)
class GeigerCounterModule
extends PluginModule
implements View.OnClickListener,
OnMenuStateChangedListener,
DroppedFrameDetectorObserver {
    private final DroppedFrameDetector detector;
    private View view;
    private HyperionMenu hyperionMenu;
    private PopupMenu popupMenu;

    GeigerCounterModule(DroppedFrameDetector detector) {
        this.detector = detector;
    }

    private void updateView(boolean detectorIsEnabled) {
        if (this.view != null) {
            this.view.setSelected(detectorIsEnabled);
        }
    }

    private void showMenu(View anchor) {
        Context context = anchor.getContext();
        if (this.popupMenu != null) {
            this.popupMenu.dismiss();
        }
        this.popupMenu = new PopupMenu(context, anchor);
        this.popupMenu.inflate(R.menu.hgc_menu_options);
        Menu menu2 = this.popupMenu.getMenu();
        MenuItem areHapticsEnabledItem = menu2.findItem(R.id.menu_item_use_haptics);
        areHapticsEnabledItem.setChecked(this.detector.areHapticsEnabled());
        areHapticsEnabledItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                boolean areHapticsEnabled = !item.isChecked();
                item.setChecked(areHapticsEnabled);
                GeigerCounterModule.this.detector.setHapticsEnabled(areHapticsEnabled);
                return true;
            }
        });
        this.popupMenu.show();
    }

    private void warnIfNeedToRaiseVolume() {
        AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
        if (this.detector.isEnabled() && !this.detector.areHapticsEnabled() && audioManager != null && audioManager.getStreamVolume(3) <= 0) {
            Toast.makeText((Context)this.getContext(), (int)R.string.hgc_volume_warning, (int)0).show();
        }
    }

    protected void onCreate() {
        super.onCreate();
        this.hyperionMenu = this.getExtension().getHyperionMenu();
        if (this.hyperionMenu != null) {
            this.hyperionMenu.addOnMenuStateChangedListener((OnMenuStateChangedListener)this);
        }
        this.detector.addObserver(this);
    }

    @Nullable
    public View createPluginView(@NonNull LayoutInflater layoutInflater, @NonNull ViewGroup parent) {
        this.view = layoutInflater.inflate(R.layout.hgc_item_plugin, parent, false);
        this.view.setOnClickListener((View.OnClickListener)this);
        View optionsButton = this.view.findViewById(R.id.button_more);
        optionsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GeigerCounterModule.this.showMenu(v);
            }
        });
        this.updateView(this.detector.isEnabled());
        return this.view;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.hyperionMenu.removeOnMenuStateChangedListener((OnMenuStateChangedListener)this);
        this.detector.removeObserver(this);
    }

    public void onClick(View v) {
        this.detector.setEnabled(!this.detector.isEnabled());
        this.warnIfNeedToRaiseVolume();
    }

    public void onMenuStateChanged(@NonNull MenuState menuState) {
        if (menuState == MenuState.CLOSING && this.popupMenu != null) {
            this.popupMenu.dismiss();
        }
    }

    @Override
    public void droppedFrameDetectorIsEnabledDidChange(DroppedFrameDetector detector, boolean isEnabled) {
        this.updateView(isEnabled);
    }

    @Override
    @Nullable
    public View getHostViewForDroppedFrameHapticFeedback() {
        return this.view;
    }
}

